"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Comprehendmedical = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [comprehendmedical](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncomprehendmedical.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Comprehendmedical extends shared_1.PolicyStatement {
    /**
     * Grants permission to describe the properties of a medical entity detection job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_DescribeEntitiesDetectionV2Job.html
     */
    toDescribeEntitiesDetectionV2Job() {
        return this.to('DescribeEntitiesDetectionV2Job');
    }
    /**
     * Grants permission to describe the properties of an ICD-10-CM linking job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_DescribeICD10CMInferenceJob.html
     */
    toDescribeICD10CMInferenceJob() {
        return this.to('DescribeICD10CMInferenceJob');
    }
    /**
     * Grants permission to describe the properties of a PHI entity detection job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_DescribePHIDetectionJob.html
     */
    toDescribePHIDetectionJob() {
        return this.to('DescribePHIDetectionJob');
    }
    /**
     * Grants permission to describe the properties of an RxNorm linking job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_DescribeRxNormInferenceJob.html
     */
    toDescribeRxNormInferenceJob() {
        return this.to('DescribeRxNormInferenceJob');
    }
    /**
     * Grants permission to describe the properties of a SNOMED-CT linking job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_DescribeSNOMEDCTInferenceJob.html
     */
    toDescribeSNOMEDCTInferenceJob() {
        return this.to('DescribeSNOMEDCTInferenceJob');
    }
    /**
     * Grants permission to detect the named medical entities, and their relationships and traits within the given text document
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_DetectEntitiesV2.html
     */
    toDetectEntitiesV2() {
        return this.to('DetectEntitiesV2');
    }
    /**
     * Grants permission to detect the protected health information (PHI) entities within the given text document
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_DetectPHI.html
     */
    toDetectPHI() {
        return this.to('DetectPHI');
    }
    /**
     * Grants permission to detect the medical condition entities within the given text document and link them to ICD-10-CM codes
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_InferICD10CM.html
     */
    toInferICD10CM() {
        return this.to('InferICD10CM');
    }
    /**
     * Grants permission to detect the medication entities within the given text document and link them to RxCUI concept identifiers from the National Library of Medicine RxNorm database
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_InferRxNorm.html
     */
    toInferRxNorm() {
        return this.to('InferRxNorm');
    }
    /**
     * Grants permission to detect the medical condition, anatomy, and test, treatment, and procedure entities within the given text document and link them to SNOMED-CT codes
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_InferSNOMEDCT.html
     */
    toInferSNOMEDCT() {
        return this.to('InferSNOMEDCT');
    }
    /**
     * Grants permission to list the medical entity detection jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_ListEntitiesDetectionV2Jobs.html
     */
    toListEntitiesDetectionV2Jobs() {
        return this.to('ListEntitiesDetectionV2Jobs');
    }
    /**
     * Grants permission to list the ICD-10-CM linking jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_ListICD10CMInferenceJobs.html
     */
    toListICD10CMInferenceJobs() {
        return this.to('ListICD10CMInferenceJobs');
    }
    /**
     * Grants permission to list the PHI entity detection jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_ListPHIDetectionJobs.html
     */
    toListPHIDetectionJobs() {
        return this.to('ListPHIDetectionJobs');
    }
    /**
     * Grants permission to list the RxNorm linking jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_ListRxNormInferenceJobs.html
     */
    toListRxNormInferenceJobs() {
        return this.to('ListRxNormInferenceJobs');
    }
    /**
     * Grants permission to list the SNOMED-CT linking jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_ListSNOMEDCTInferenceJobs.html
     */
    toListSNOMEDCTInferenceJobs() {
        return this.to('ListSNOMEDCTInferenceJobs');
    }
    /**
     * Grants permission to start an asynchronous medical entity detection job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_StartEntitiesDetectionV2Job.html
     */
    toStartEntitiesDetectionV2Job() {
        return this.to('StartEntitiesDetectionV2Job');
    }
    /**
     * Grants permission to start an asynchronous ICD-10-CM linking job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_StartICD10CMInferenceJob.html
     */
    toStartICD10CMInferenceJob() {
        return this.to('StartICD10CMInferenceJob');
    }
    /**
     * Grants permission to start an asynchronous PHI entity detection job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_StartPHIDetectionJob.html
     */
    toStartPHIDetectionJob() {
        return this.to('StartPHIDetectionJob');
    }
    /**
     * Grants permission to start an asynchronous RxNorm linking job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_StartRxNormInferenceJob.html
     */
    toStartRxNormInferenceJob() {
        return this.to('StartRxNormInferenceJob');
    }
    /**
     * Grants permission to start an asynchronous SNOMED-CT linking job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_StartSNOMEDCTInferenceJob.html
     */
    toStartSNOMEDCTInferenceJob() {
        return this.to('StartSNOMEDCTInferenceJob');
    }
    /**
     * Grants permission to stop a medical entity detection job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_StopEntitiesDetectionV2Job.html
     */
    toStopEntitiesDetectionV2Job() {
        return this.to('StopEntitiesDetectionV2Job');
    }
    /**
     * Grants permission to stop an ICD-10-CM linking job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_StopICD10CMInferenceJob.html
     */
    toStopICD10CMInferenceJob() {
        return this.to('StopICD10CMInferenceJob');
    }
    /**
     * Grants permission to stop a PHI entity detection job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_StopPHIDetectionJob.html
     */
    toStopPHIDetectionJob() {
        return this.to('StopPHIDetectionJob');
    }
    /**
     * Grants permission to stop an RxNorm linking job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_StopRxNormInferenceJob.html
     */
    toStopRxNormInferenceJob() {
        return this.to('StopRxNormInferenceJob');
    }
    /**
     * Grants permission to stop a SNOMED-CT linking job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/api/API_StopSNOMEDCTInferenceJob.html
     */
    toStopSNOMEDCTInferenceJob() {
        return this.to('StopSNOMEDCTInferenceJob');
    }
    /**
     * Filters access by the presence of tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value, operator) {
        return this.if(`aws:TagKeys`, value, operator ?? 'StringLike');
    }
    /**
     * Statement provider for service [comprehendmedical](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncomprehendmedical.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'comprehendmedical';
        this.accessLevelList = {
            Read: [
                'DescribeEntitiesDetectionV2Job',
                'DescribeICD10CMInferenceJob',
                'DescribePHIDetectionJob',
                'DescribeRxNormInferenceJob',
                'DescribeSNOMEDCTInferenceJob',
                'DetectEntitiesV2',
                'DetectPHI',
                'InferICD10CM',
                'InferRxNorm',
                'InferSNOMEDCT',
                'ListEntitiesDetectionV2Jobs',
                'ListICD10CMInferenceJobs',
                'ListPHIDetectionJobs',
                'ListRxNormInferenceJobs',
                'ListSNOMEDCTInferenceJobs'
            ],
            Write: [
                'StartEntitiesDetectionV2Job',
                'StartICD10CMInferenceJob',
                'StartPHIDetectionJob',
                'StartRxNormInferenceJob',
                'StartSNOMEDCTInferenceJob',
                'StopEntitiesDetectionV2Job',
                'StopICD10CMInferenceJob',
                'StopPHIDetectionJob',
                'StopRxNormInferenceJob',
                'StopSNOMEDCTInferenceJob'
            ]
        };
    }
}
exports.Comprehendmedical = Comprehendmedical;
//# sourceMappingURL=data:application/json;base64,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