import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [connect-campaigns](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnectoutboundcampaigns.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class ConnectCampaigns extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a campaign
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toCreateCampaign(): this;
    /**
     * Grants permission to delete a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toDeleteCampaign(): this;
    /**
     * Grants permission to delete the channel subtype configuration of a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toDeleteCampaignChannelSubtypeConfig(): this;
    /**
     * Grants permission to delete the communication limits configuration of a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toDeleteCampaignCommunicationLimits(): this;
    /**
     * Grants permission to delete the communication time configuration of a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toDeleteCampaignCommunicationTime(): this;
    /**
     * Grants permission to remove configuration information for an Amazon Connect instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toDeleteConnectInstanceConfig(): this;
    /**
     * Grants permission to remove integration information for an Amazon Connect instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toDeleteConnectInstanceIntegration(): this;
    /**
     * Grants permission to remove onboarding job for an Amazon Connect instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toDeleteInstanceOnboardingJob(): this;
    /**
     * Grants permission to describe a specific campaign
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toDescribeCampaign(): this;
    /**
     * Grants permission to get state of a campaign
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toGetCampaignState(): this;
    /**
     * Grants permission to get state of campaigns
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toGetCampaignStateBatch(): this;
    /**
     * Grants permission to get configuration information for an Amazon Connect instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toGetConnectInstanceConfig(): this;
    /**
     * Grants permission to get the communication limits configuration of an Amazon Connect instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toGetInstanceCommunicationLimits(): this;
    /**
     * Grants permission to get onboarding job status for an Amazon Connect instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toGetInstanceOnboardingJobStatus(): this;
    /**
     * Grants permission to provide summary of all campaigns
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toListCampaigns(): this;
    /**
     * Grants permission to provide summary of all integrations with an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toListConnectInstanceIntegrations(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to pause a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toPauseCampaign(): this;
    /**
     * Grants permission to put an integration configuration with an Amazon Connect instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toPutConnectInstanceIntegration(): this;
    /**
     * Grants permission to create dial requests for the specified campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toPutDialRequestBatch(): this;
    /**
     * Grants permission to put the communication limits configuration of an Amazon Connect instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toPutInstanceCommunicationLimits(): this;
    /**
     * Grants permission to create dial requests for the specified campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toPutOutboundRequestBatch(): this;
    /**
     * Grants permission to create profile outbound requests for the specified campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toPutProfileOutboundRequestBatch(): this;
    /**
     * Grants permission to resume a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toResumeCampaign(): this;
    /**
     * Grants permission to start a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toStartCampaign(): this;
    /**
     * Grants permission to start onboarding job for an Amazon Connect instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toStartInstanceOnboardingJob(): this;
    /**
     * Grants permission to stop a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toStopCampaign(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the channel subtype configuration of a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toUpdateCampaignChannelSubtypeConfig(): this;
    /**
     * Grants permission to update the communication limits configuration of a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toUpdateCampaignCommunicationLimits(): this;
    /**
     * Grants permission to update the communication time configuration of a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toUpdateCampaignCommunicationTime(): this;
    /**
     * Grants permission to update the dialer configuration of a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toUpdateCampaignDialerConfig(): this;
    /**
     * Grants permission to update the flow association of a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toUpdateCampaignFlowAssociation(): this;
    /**
     * Grants permission to update the name of a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toUpdateCampaignName(): this;
    /**
     * Grants permission to update the outbound call configuration of a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toUpdateCampaignOutboundCallConfig(): this;
    /**
     * Grants permission to update the schedule of a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toUpdateCampaignSchedule(): this;
    /**
     * Grants permission to update the source of a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     */
    toUpdateCampaignSource(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type campaign to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-outbound-campaigns.html
     *
     * @param campaignId - Identifier for the campaignId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCampaign(campaignId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by actions based on the presence of tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateCampaign()
     * - .toDescribeCampaign()
     * - .toGetCampaignState()
     * - .toGetCampaignStateBatch()
     * - .toListCampaigns()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by actions based on tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toListTagsForResource()
     *
     * Applies to resource types:
     * - campaign
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by actions based on the presence of tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateCampaign()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [connect-campaigns](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnectoutboundcampaigns.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
