import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [consoleapp](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsconsolemobileapp.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Consoleapp extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to retrieve the device identity for a Console Mobile App device
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/consolemobileapp/latest/userguide/permissions-policies.html
     */
    toGetDeviceIdentity(): this;
    /**
     * Grants permission to retrieve a list of device identities
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/consolemobileapp/latest/userguide/permissions-policies.html
     */
    toListDeviceIdentities(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type DeviceIdentity to the statement
     *
     * https://docs.aws.amazon.com/consolemobileapp/latest/userguide/permissions-policies.html
     *
     * @param deviceId - Identifier for the deviceId.
     * @param identityId - Identifier for the identityId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDeviceIdentity(deviceId: string, identityId: string, account?: string, partition?: string): this;
    /**
     * Statement provider for service [consoleapp](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsconsolemobileapp.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
