"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Controlcatalog = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [controlcatalog](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscontrolcatalog.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Controlcatalog extends shared_1.PolicyStatement {
    /**
     * Grants permission to return details about a specific control
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_GetControl.html
     */
    toGetControl() {
        return this.to('GetControl');
    }
    /**
     * Grants permission to return a paginated list of common controls from the AWS Control Catalog
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListCommonControls.html
     */
    toListCommonControls() {
        return this.to('ListCommonControls');
    }
    /**
     * Grants permission to return a paginated list of control mappings from the AWS Control Catalog
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListControlMappings.html
     */
    toListControlMappings() {
        return this.to('ListControlMappings');
    }
    /**
     * Grants permission to return a paginated list of all available controls in the AWS Control Catalog library
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListControls.html
     */
    toListControls() {
        return this.to('ListControls');
    }
    /**
     * Grants permission to return a paginated list of domains from the AWS Control Catalog
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListDomains.html
     */
    toListDomains() {
        return this.to('ListDomains');
    }
    /**
     * Grants permission to return a paginated list of objectives from the AWS Control Catalog
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListObjectives.html
     */
    toListObjectives() {
        return this.to('ListObjectives');
    }
    /**
     * Adds a resource of type common-control to the statement
     *
     * https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_CommonControlSummary.html
     *
     * @param commonControlId - Identifier for the commonControlId.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCommonControl(commonControlId, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:controlcatalog:::common-control/${commonControlId}`);
    }
    /**
     * Adds a resource of type control to the statement
     *
     * https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ControlSummary.html
     *
     * @param controlId - Identifier for the controlId.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onControl(controlId, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:controlcatalog:::control/${controlId}`);
    }
    /**
     * Adds a resource of type domain to the statement
     *
     * https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_DomainSummary.html
     *
     * @param domainId - Identifier for the domainId.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDomain(domainId, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:controlcatalog:::domain/${domainId}`);
    }
    /**
     * Adds a resource of type objective to the statement
     *
     * https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ObjectiveSummary.html
     *
     * @param objectiveId - Identifier for the objectiveId.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onObjective(objectiveId, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:controlcatalog:::objective/${objectiveId}`);
    }
    /**
     * Statement provider for service [controlcatalog](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscontrolcatalog.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'controlcatalog';
        this.accessLevelList = {
            Read: [
                'GetControl'
            ],
            List: [
                'ListCommonControls',
                'ListControlMappings',
                'ListControls',
                'ListDomains',
                'ListObjectives'
            ]
        };
    }
}
exports.Controlcatalog = Controlcatalog;
//# sourceMappingURL=data:application/json;base64,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