import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [cur](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscostandusagereport.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Cur extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to delete Cost and Usage Report Definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_cur_DeleteReportDefinition.html
     */
    toDeleteReportDefinition(): this;
    /**
     * Grants permission to get Cost and Usage Report Definitions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_cur_DescribeReportDefinitions.html
     */
    toDescribeReportDefinitions(): this;
    /**
     * Grants permission to get Bills CSV report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cur/latest/userguide/security.html#user-permissions
     */
    toGetClassicReport(): this;
    /**
     * Grants permission to get the classic report enablement status for Usage Reports
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cur/latest/userguide/security.html#user-permissions
     */
    toGetClassicReportPreferences(): this;
    /**
     * Grants permission to get list of AWS services, usage type and operation for the Usage Report workflow. Allows or denies download of usage reports too
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cur/latest/userguide/security.html#user-permissions
     */
    toGetUsageReport(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_cur_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to modify Cost and Usage Report Definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_cur_ModifyReportDefinition.html
     */
    toModifyReportDefinition(): this;
    /**
     * Grants permission to enable classic reports
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cur/latest/userguide/security.html#user-permissions
     */
    toPutClassicReportPreferences(): this;
    /**
     * Grants permission to write Cost and Usage Report Definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_cur_PutReportDefinition.html
     */
    toPutReportDefinition(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_cur_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_cur_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to validates if the s3 bucket exists with appropriate permissions for CUR delivery
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cur/latest/userguide/security.html#user-permissions
     */
    toValidateReportDestination(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type cur to the statement
     *
     * https://docs.aws.amazon.com/cur/latest/userguide/what-is-cur.html
     *
     * @param reportName - Identifier for the reportName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCur(reportName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toPutReportDefinition()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toListTagsForResource()
     * - .toPutReportDefinition()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toPutReportDefinition()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [cur](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscostandusagereport.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
