import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [cost-optimization-hub](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscostoptimizationhub.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class CostOptimizationHub extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to get preferences
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostOptimizationHub_GetPreferences.html
     */
    toGetPreferences(): this;
    /**
     * Grants permission to get resource configuration and estimated cost impact for a recommendation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostOptimizationHub_GetRecommendation.html
     */
    toGetRecommendation(): this;
    /**
     * Grants permission to list enrollment statuses for the specified account or all members under a management account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostOptimizationHub_ListEnrollmentStatuses.html
     */
    toListEnrollmentStatuses(): this;
    /**
     * Grants permission to list recommendation summaries by group
     *
     * Access Level: List
     *
     * Dependent actions:
     * - cost-optimization-hub:GetRecommendation
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostOptimizationHub_ListRecommendationSummaries.html
     */
    toListRecommendationSummaries(): this;
    /**
     * Grants permission to list summary view of recommendations
     *
     * Access Level: List
     *
     * Dependent actions:
     * - cost-optimization-hub:GetRecommendation
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostOptimizationHub_ListRecommendations.html
     */
    toListRecommendations(): this;
    /**
     * Grants permission to update the enrollment status
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostOptimizationHub_UpdateEnrollmentStatus.html
     */
    toUpdateEnrollmentStatus(): this;
    /**
     * Grants permission to update preferences
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostOptimizationHub_UpdatePreferences.html
     */
    toUpdatePreferences(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [cost-optimization-hub](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscostoptimizationhub.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
