import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [customer-verification](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscustomerverificationservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class CustomerVerification extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create customer verification data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toCreateCustomerVerificationDetails(): this;
    /**
     * Grants permission to create upload URLs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toCreateUploadUrls(): this;
    /**
     * Grants permission to get customer verification data
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toGetCustomerVerificationDetails(): this;
    /**
     * Grants permission to get customer verification eligibility
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toGetCustomerVerificationEligibility(): this;
    /**
     * Grants permission to update customer verification data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     */
    toUpdateCustomerVerificationDetails(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [customer-verification](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscustomerverificationservice.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
