import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [datazone](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondatazone.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Datazone extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to accept prediction
     *
     * Access Level: Write
     */
    toAcceptPredictions(): this;
    /**
     * Grants permission to approve a subscription request for a Data Asset
     *
     * Access Level: Write
     */
    toAcceptSubscriptionRequest(): this;
    /**
     * Grants permission to add an owner to an entity like domain unit
     *
     * Access Level: Write
     */
    toAddEntityOwner(): this;
    /**
     * Grants permission to add a policy grant
     *
     * Access Level: Permissions management
     */
    toAddPolicyGrant(): this;
    /**
     * Grants permission to associate a role in a default service blueprint environment
     *
     * Access Level: Write
     */
    toAssociateEnvironmentRole(): this;
    /**
     * Grants permission to associate governed terms to an asset
     *
     * Access Level: Write
     */
    toAssociateGovernedTerms(): this;
    /**
     * Grants permission to remove linked type items from an Amazon DataZone Domain
     *
     * Access Level: Write
     */
    toBatchDeleteLinkedTypes(): this;
    /**
     * Grants permission to put linked type items to an Amazon DataZone Domain
     *
     * Access Level: Write
     */
    toBatchPutLinkedTypes(): this;
    /**
     * Grants permission to cancel metadata generation run
     *
     * Access Level: Write
     */
    toCancelMetadataGenerationRun(): this;
    /**
     * Grants permission to revoke or unsubscribe an approved subscription to Data Asset
     *
     * Access Level: Write
     */
    toCancelSubscription(): this;
    /**
     * Grants permission to create an account pool
     *
     * Access Level: Write
     */
    toCreateAccountPool(): this;
    /**
     * Grants permission to create asset
     *
     * Access Level: Write
     */
    toCreateAsset(): this;
    /**
     * Grants permission to create asset filter
     *
     * Access Level: Write
     */
    toCreateAssetFilter(): this;
    /**
     * Grants permission to create new revision of an asset
     *
     * Access Level: Write
     */
    toCreateAssetRevision(): this;
    /**
     * Grants permission to create an asset type
     *
     * Access Level: Write
     */
    toCreateAssetType(): this;
    /**
     * Grants permission to create connections
     *
     * Access Level: Write
     */
    toCreateConnection(): this;
    /**
     * Grants permission to create data product
     *
     * Access Level: Write
     */
    toCreateDataProduct(): this;
    /**
     * Grants permission to create data product revision
     *
     * Access Level: Write
     */
    toCreateDataProductRevision(): this;
    /**
     * Grants permission to create a new DataSource
     *
     * Access Level: Write
     */
    toCreateDataSource(): this;
    /**
     * Grants permission to provision a domain which is a top level entity that contains other Amazon DataZone resources
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     */
    toCreateDomain(): this;
    /**
     * Grants permission to create a domain unit
     *
     * Access Level: Write
     */
    toCreateDomainUnit(): this;
    /**
     * Grants permission to create a collection of configurated resources used to publish and subscribe to data
     *
     * Access Level: Write
     */
    toCreateEnvironment(): this;
    /**
     * Grants permission to create an environment action in a default service blueprint environment
     *
     * Access Level: Write
     */
    toCreateEnvironmentAction(): this;
    /**
     * Grants permission to create a custom Environment Blueprint that allow user to add Environments to their Project
     *
     * Access Level: Write
     */
    toCreateEnvironmentBlueprint(): this;
    /**
     * Grants permission to create a template from a Blueprint that can be used to create a Environment
     *
     * Access Level: Write
     */
    toCreateEnvironmentProfile(): this;
    /**
     * Grants permission to create a form type or a new revision of it
     *
     * Access Level: Write
     */
    toCreateFormType(): this;
    /**
     * Grants permission to create a business glossary
     *
     * Access Level: Write
     */
    toCreateGlossary(): this;
    /**
     * Grants permission to create a glossary term
     *
     * Access Level: Write
     */
    toCreateGlossaryTerm(): this;
    /**
     * Grants permission to create a DataZone group profile for an IAM Identity Center group
     *
     * Access Level: Write
     */
    toCreateGroupProfile(): this;
    /**
     * Grants permission to create listing change set
     *
     * Access Level: Write
     */
    toCreateListingChangeSet(): this;
    /**
     * Grants permission to create a Project to enable your team to publish and subscribe to data
     *
     * Access Level: Write
     */
    toCreateProject(): this;
    /**
     * Grants permission to add a user to a Project
     *
     * Access Level: Write
     */
    toCreateProjectMembership(): this;
    /**
     * Grants permission to create a project profile
     *
     * Access Level: Write
     */
    toCreateProjectProfile(): this;
    /**
     * Grants permission to create rule
     *
     * Access Level: Write
     */
    toCreateRule(): this;
    /**
     * Grants permission to create a grant for an approved subscription on a subscription target
     *
     * Access Level: Write
     */
    toCreateSubscriptionGrant(): this;
    /**
     * Grants permission to create a subscription request for a Data Asset
     *
     * Access Level: Write
     */
    toCreateSubscriptionRequest(): this;
    /**
     * Grants permission to create a subscription target for a Environment in the project
     *
     * Access Level: Write
     */
    toCreateSubscriptionTarget(): this;
    /**
     * Grants permission to create a user profile for an existing user in the customers IAM Identity Center
     *
     * Access Level: Write
     */
    toCreateUserProfile(): this;
    /**
     * Grants permission to delete an account pool
     *
     * Access Level: Write
     */
    toDeleteAccountPool(): this;
    /**
     * Grants permission to delete an asset
     *
     * Access Level: Write
     */
    toDeleteAsset(): this;
    /**
     * Grants permission to delete asset filter
     *
     * Access Level: Write
     */
    toDeleteAssetFilter(): this;
    /**
     * Grants permission to delete an asset type
     *
     * Access Level: Write
     */
    toDeleteAssetType(): this;
    /**
     * Grants permission to delete connections
     *
     * Access Level: Write
     */
    toDeleteConnection(): this;
    /**
     * Grants permission to delete data product
     *
     * Access Level: Write
     */
    toDeleteDataProduct(): this;
    /**
     * Grants permission to update existing DataSource
     *
     * Access Level: Write
     */
    toDeleteDataSource(): this;
    /**
     * Grants permission to delete a provisioned domain
     *
     * Access Level: Write
     */
    toDeleteDomain(): this;
    /**
     * Grants permission to delete a resource policy for a DataZone Domain
     *
     * Access Level: Permissions management
     */
    toDeleteDomainSharingPolicy(): this;
    /**
     * Grants permission to delete an existing domain unit
     *
     * Access Level: Write
     */
    toDeleteDomainUnit(): this;
    /**
     * Grants permission to Delete Environment
     *
     * Access Level: Write
     */
    toDeleteEnvironment(): this;
    /**
     * Grants permission to delete an environment action in a default service blueprint environment
     *
     * Access Level: Write
     */
    toDeleteEnvironmentAction(): this;
    /**
     * Grants permission to delete Environment Blueprint
     *
     * Access Level: Write
     */
    toDeleteEnvironmentBlueprint(): this;
    /**
     * Grants permission to delete environment blueprint configuration
     *
     * Access Level: Write
     */
    toDeleteEnvironmentBlueprintConfiguration(): this;
    /**
     * Grants permission to delete Environment Profile
     *
     * Access Level: Write
     */
    toDeleteEnvironmentProfile(): this;
    /**
     * Grants permission to delete a form type
     *
     * Access Level: Write
     */
    toDeleteFormType(): this;
    /**
     * Grants permission to delete a business glossary
     *
     * Access Level: Write
     */
    toDeleteGlossary(): this;
    /**
     * Grants permission to delete a glossary term
     *
     * Access Level: Write
     */
    toDeleteGlossaryTerm(): this;
    /**
     * Grants permission to delete listing
     *
     * Access Level: Write
     */
    toDeleteListing(): this;
    /**
     * Grants permission to delete a Project that enables your team to publish and subscribe to data
     *
     * Access Level: Write
     */
    toDeleteProject(): this;
    /**
     * Grants permission to remove a user from a project
     *
     * Access Level: Write
     */
    toDeleteProjectMembership(): this;
    /**
     * Grants permission to delete a project profile
     *
     * Access Level: Write
     */
    toDeleteProjectProfile(): this;
    /**
     * Grants permission to delete rule
     *
     * Access Level: Write
     */
    toDeleteRule(): this;
    /**
     * Grants permission to delete a subscription grant from a subscription target
     *
     * Access Level: Write
     */
    toDeleteSubscriptionGrant(): this;
    /**
     * Grants permission to delete a pending subscription request for a Data Asset
     *
     * Access Level: Write
     */
    toDeleteSubscriptionRequest(): this;
    /**
     * Grants permission to delete a subscription target from a Environment in the project
     *
     * Access Level: Write
     */
    toDeleteSubscriptionTarget(): this;
    /**
     * Grants permission to delete existing TimeSeriesDataPoints
     *
     * Access Level: Write
     */
    toDeleteTimeSeriesDataPoints(): this;
    /**
     * Grants permission to disassociate a role in a default service blueprint environment
     *
     * Access Level: Write
     */
    toDisassociateEnvironmentRole(): this;
    /**
     * Grants permission to disassociate governed terms to an asset
     *
     * Access Level: Write
     */
    toDisassociateGovernedTerms(): this;
    /**
     * Grants permission to get account pool details
     *
     * Access Level: Read
     */
    toGetAccountPool(): this;
    /**
     * Grants permission to retrieve an asset
     *
     * Access Level: Read
     */
    toGetAsset(): this;
    /**
     * Grants permission to get asset filter
     *
     * Access Level: Read
     */
    toGetAssetFilter(): this;
    /**
     * Grants permission to get an asset type
     *
     * Access Level: Read
     */
    toGetAssetType(): this;
    /**
     * Grants permission to get connections
     *
     * Access Level: Read
     */
    toGetConnection(): this;
    /**
     * Grants permission to get data product
     *
     * Access Level: Read
     */
    toGetDataProduct(): this;
    /**
     * Grants permission to Get a existing DataSource in Amazon DataZone using its identifier
     *
     * Access Level: Read
     */
    toGetDataSource(): this;
    /**
     * Grants permission to get DataSource run job in Amazon DataZone using it's identifier
     *
     * Access Level: Read
     */
    toGetDataSourceRun(): this;
    /**
     * Grants permission to retrieve information about a domain
     *
     * Access Level: Read
     */
    toGetDomain(): this;
    /**
     * Grants permission to use features that require access to domain execution role credentials
     *
     * Access Level: Read
     */
    toGetDomainExecutionRoleCredentials(): this;
    /**
     * Grants permission to retrieve a resource policy for a DataZone Domain
     *
     * Access Level: Read
     */
    toGetDomainSharingPolicy(): this;
    /**
     * Grants permission to get an existing domain unit
     *
     * Access Level: Read
     */
    toGetDomainUnit(): this;
    /**
     * Grants permission to get Environment details
     *
     * Access Level: Read
     */
    toGetEnvironment(): this;
    /**
     * Grants permission to get an environment action in a default service blueprint environment
     *
     * Access Level: Read
     */
    toGetEnvironmentAction(): this;
    /**
     * Grants permission to get environment action link
     *
     * Access Level: Read
     */
    toGetEnvironmentActionLink(): this;
    /**
     * Grants permission to get Environment Blueprint details
     *
     * Access Level: Read
     */
    toGetEnvironmentBlueprint(): this;
    /**
     * Grants permission to get environment blueprint configuration
     *
     * Access Level: Read
     */
    toGetEnvironmentBlueprintConfiguration(): this;
    /**
     * Grants permission to get short term credentials that assume the Environment user role
     *
     * Access Level: Read
     */
    toGetEnvironmentCredentials(): this;
    /**
     * Grants permission to get Environment Profile details
     *
     * Access Level: Read
     */
    toGetEnvironmentProfile(): this;
    /**
     * Grants permission to get a form type
     *
     * Access Level: Read
     */
    toGetFormType(): this;
    /**
     * Grants permission to get a business glossary
     *
     * Access Level: Read
     */
    toGetGlossary(): this;
    /**
     * Grants permission to get a glossary term
     *
     * Access Level: Read
     */
    toGetGlossaryTerm(): this;
    /**
     * Grants permission to retrieve an existing DataZone group profile
     *
     * Access Level: Read
     */
    toGetGroupProfile(): this;
    /**
     * Grants permission to an IAM principal to log into the DataZone Portal
     *
     * Access Level: Permissions management
     */
    toGetIamPortalLoginUrl(): this;
    /**
     * Grants permission to get job runs
     *
     * Access Level: Read
     */
    toGetJobRun(): this;
    /**
     * Grants permission to get lineage events
     *
     * Access Level: Read
     */
    toGetLineageEvent(): this;
    /**
     * Grants permission to get the lineage node
     *
     * Access Level: Read
     */
    toGetLineageNode(): this;
    /**
     * Grants permission to get listing
     *
     * Access Level: Read
     */
    toGetListing(): this;
    /**
     * Grants permission to get metadata generation run
     *
     * Access Level: Read
     */
    toGetMetadataGenerationRun(): this;
    /**
     * Grants permission to get Project details
     *
     * Access Level: Read
     */
    toGetProject(): this;
    /**
     * Grants permission to get project profile details
     *
     * Access Level: Read
     */
    toGetProjectProfile(): this;
    /**
     * Grants permission to get rule
     *
     * Access Level: Read
     */
    toGetRule(): this;
    /**
     * Grants permission to retrieve a subscription
     *
     * Access Level: Read
     */
    toGetSubscription(): this;
    /**
     * Grants permission to get subscription eligibilty
     *
     * Access Level: Read
     */
    toGetSubscriptionEligibility(): this;
    /**
     * Grants permission to retireve a subscription grant
     *
     * Access Level: Read
     */
    toGetSubscriptionGrant(): this;
    /**
     * Grants permission to reject a subscription request for a Data Asset
     *
     * Access Level: Read
     */
    toGetSubscriptionRequestDetails(): this;
    /**
     * Grants permission to retireve details of subscription target
     *
     * Access Level: Read
     */
    toGetSubscriptionTarget(): this;
    /**
     * Grants permission to get an existing TimeSeriesDataPoints in Amazon DataZone using its identifier
     *
     * Access Level: Read
     */
    toGetTimeSeriesDataPoint(): this;
    /**
     * Grants permission to get update eligibility status for project constructs
     *
     * Access Level: Read
     */
    toGetUpdateEligibility(): this;
    /**
     * Grants permission to retrieve a user profile for an existing user in the DataZone Domain
     *
     * Access Level: Read
     */
    toGetUserProfile(): this;
    /**
     * Grants permission to list Environments across all domains in an AWS Account
     *
     * Access Level: List
     */
    toListAccountEnvironments(): this;
    /**
     * Grants permission to list account pools
     *
     * Access Level: List
     */
    toListAccountPools(): this;
    /**
     * Grants permission to list accounts in an account pool
     *
     * Access Level: List
     */
    toListAccountsInAccountPool(): this;
    /**
     * Grants permission to list asset filters
     *
     * Access Level: List
     */
    toListAssetFilters(): this;
    /**
     * Grants permission to list revisions of an asset
     *
     * Access Level: List
     */
    toListAssetRevisions(): this;
    /**
     * Grants permission to list connections
     *
     * Access Level: List
     */
    toListConnections(): this;
    /**
     * Grants permission to list data product revisions
     *
     * Access Level: List
     */
    toListDataProductRevisions(): this;
    /**
     * Grants permission to list DataSource runs job's activities on Asset
     *
     * Access Level: List
     */
    toListDataSourceRunActivities(): this;
    /**
     * Grants permission to list DataSource runs job
     *
     * Access Level: List
     */
    toListDataSourceRuns(): this;
    /**
     * Grants permission to list existing DataSources
     *
     * Access Level: List
     */
    toListDataSources(): this;
    /**
     * Grants permission to list child domain units for a given parent domain unit
     *
     * Access Level: List
     */
    toListDomainUnitsForParent(): this;
    /**
     * Grants permission to retrieve all domains
     *
     * Access Level: List
     */
    toListDomains(): this;
    /**
     * Grants permission to list owners of an entity like domain unit
     *
     * Access Level: List
     */
    toListEntityOwners(): this;
    /**
     * Grants permission to list environment actions in a default service blueprint environment
     *
     * Access Level: List
     */
    toListEnvironmentActions(): this;
    /**
     * Grants permission to list environment blueprint configuration summaries
     *
     * Access Level: List
     */
    toListEnvironmentBlueprintConfigurationSummaries(): this;
    /**
     * Grants permission to list environment blueprint configurations
     *
     * Access Level: List
     */
    toListEnvironmentBlueprintConfigurations(): this;
    /**
     * Grants permission to list Domain for Environment Blueprints
     *
     * Access Level: List
     */
    toListEnvironmentBlueprints(): this;
    /**
     * Grants permission to list Domain for Environment Profiles
     *
     * Access Level: List
     */
    toListEnvironmentProfiles(): this;
    /**
     * Grants permission to show Environments in the Domain
     *
     * Access Level: List
     */
    toListEnvironments(): this;
    /**
     * Grants permission to list all the DataZone group profiles that the DataZone user profile is a member of
     *
     * Access Level: List
     */
    toListGroupsForUser(): this;
    /**
     * Grants permission to list job runs
     *
     * Access Level: List
     */
    toListJobRuns(): this;
    /**
     * Grants permission to list lineage events
     *
     * Access Level: List
     */
    toListLineageEvents(): this;
    /**
     * Grants permission to list historical versions of lineage node
     *
     * Access Level: List
     */
    toListLineageNodeHistory(): this;
    /**
     * Grants permission to list linked type items linked to an Amazon DataZone Domain
     *
     * Access Level: List
     */
    toListLinkedTypes(): this;
    /**
     * Grants permission to list metadata generation runs
     *
     * Access Level: List
     */
    toListMetadataGenerationRuns(): this;
    /**
     * Grants permission to list notifications and events for a datazone user
     *
     * Access Level: List
     */
    toListNotifications(): this;
    /**
     * Grants permission to list policy grants
     *
     * Access Level: List
     */
    toListPolicyGrants(): this;
    /**
     * Grants permission to list Project Members
     *
     * Access Level: List
     */
    toListProjectMemberships(): this;
    /**
     * Grants permission to list project profiles
     *
     * Access Level: List
     */
    toListProjectProfiles(): this;
    /**
     * Grants permission to list Projects
     *
     * Access Level: List
     */
    toListProjects(): this;
    /**
     * Grants permission to list rules
     *
     * Access Level: List
     */
    toListRules(): this;
    /**
     * Grants permission to List subscription grants for a subscribed principal
     *
     * Access Level: List
     */
    toListSubscriptionGrants(): this;
    /**
     * Grants permission to list subscription requests
     *
     * Access Level: List
     */
    toListSubscriptionRequests(): this;
    /**
     * Grants permission to list subscription targets
     *
     * Access Level: List
     */
    toListSubscriptionTargets(): this;
    /**
     * Grants permission to list subscriptions
     *
     * Access Level: List
     */
    toListSubscriptions(): this;
    /**
     * Grants permission to retrieve all tags associated with a resource
     *
     * Access Level: Read
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list existing TimeSeriesDataPoints
     *
     * Access Level: List
     */
    toListTimeSeriesDataPoints(): this;
    /**
     * Grants permission to list available Manager Secrets
     *
     * Access Level: List
     */
    toListWarehouseMetadata(): this;
    /**
     * Grants permission to post lineage events
     *
     * Access Level: Write
     */
    toPostLineageEvent(): this;
    /**
     * Grants permission to post a new TimeSeriesDataPoints
     *
     * Access Level: Write
     */
    toPostTimeSeriesDataPoints(): this;
    /**
     * Grants permission to provision domain with default project setup
     *
     * Access Level: Write
     */
    toProvisionDomain(): this;
    /**
     * Grants permission to add a resource policy for a DataZone Domain
     *
     * Access Level: Permissions management
     */
    toPutDomainSharingPolicy(): this;
    /**
     * Grants permission to put environment blueprint configuration
     *
     * Access Level: Write
     */
    toPutEnvironmentBlueprintConfiguration(): this;
    /**
     * Grants permission to refresh token
     *
     * Access Level: Write
     */
    toRefreshToken(): this;
    /**
     * Grants permission to reject prediction
     *
     * Access Level: Write
     */
    toRejectPredictions(): this;
    /**
     * Grants permission to reject a subscription request for a Data Asset
     *
     * Access Level: Write
     */
    toRejectSubscriptionRequest(): this;
    /**
     * Grants permission to remove an existing owner of an entity like domain unit
     *
     * Access Level: Write
     */
    toRemoveEntityOwner(): this;
    /**
     * Grants permission to remove a policy grant
     *
     * Access Level: Permissions management
     */
    toRemovePolicyGrant(): this;
    /**
     * Grants permission to revoke a subscription
     *
     * Access Level: Permissions management
     */
    toRevokeSubscription(): this;
    /**
     * Grants permission to search datazone entities
     *
     * Access Level: List
     */
    toSearch(): this;
    /**
     * Grants permission to search DataZone group profiles and IAM Identity Center groups
     *
     * Access Level: List
     */
    toSearchGroupProfiles(): this;
    /**
     * Grants permission to search listings
     *
     * Access Level: List
     */
    toSearchListings(): this;
    /**
     * Grants permission to search rules
     *
     * Access Level: List
     */
    toSearchRules(): this;
    /**
     * Grants permission to search types such asset types and form types in a domain
     *
     * Access Level: List
     */
    toSearchTypes(): this;
    /**
     * Grants permission to search DataZone user profiles, IAM Identity Center users, and DataZone IAM principal profiles
     *
     * Access Level: List
     */
    toSearchUserProfiles(): this;
    /**
     * Grants permission to login using SSO
     *
     * Access Level: Write
     */
    toSsoLogin(): this;
    /**
     * Grants permission to logout as SSO user
     *
     * Access Level: Write
     */
    toSsoLogout(): this;
    /**
     * Grants permission to start account bootstrap action for a domain
     *
     * Access Level: Write
     */
    toStartAccountBootstrapAction(): this;
    /**
     * Grants permission to start a DataSource run job
     *
     * Access Level: Write
     */
    toStartDataSourceRun(): this;
    /**
     * Grants permission to start metadata generation run
     *
     * Access Level: Write
     */
    toStartMetadataGenerationRun(): this;
    /**
     * Grants permission to stop metadata generation run
     *
     * Access Level: Write
     */
    toStopMetadataGenerationRun(): this;
    /**
     * Grants permission to add or update tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags associated with a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an account pool
     *
     * Access Level: Write
     */
    toUpdateAccountPool(): this;
    /**
     * Grants permission to update asset filter
     *
     * Access Level: Write
     */
    toUpdateAssetFilter(): this;
    /**
     * Grants permission to update connections
     *
     * Access Level: Write
     */
    toUpdateConnection(): this;
    /**
     * Grants permission to update existing DataSource
     *
     * Access Level: Write
     */
    toUpdateDataSource(): this;
    /**
     * Grants permission to update data source run activities
     *
     * Access Level: Write
     */
    toUpdateDataSourceRunActivities(): this;
    /**
     * Grants permission to update information for a domain
     *
     * Access Level: Write
     */
    toUpdateDomain(): this;
    /**
     * Grants permission to update an existing domain unit
     *
     * Access Level: Write
     */
    toUpdateDomainUnit(): this;
    /**
     * Grants permission to update Environment settings
     *
     * Access Level: Write
     */
    toUpdateEnvironment(): this;
    /**
     * Grants permission to update an environment action in a default service blueprint environment
     *
     * Access Level: Write
     */
    toUpdateEnvironmentAction(): this;
    /**
     * Grants permission to update Environment Blueprint settings
     *
     * Access Level: Write
     */
    toUpdateEnvironmentBlueprint(): this;
    /**
     * Grants permission to update environment configuration
     *
     * Access Level: Write
     */
    toUpdateEnvironmentConfiguration(): this;
    /**
     * Grants permission to update status of the Environment deployment
     *
     * Access Level: Write
     */
    toUpdateEnvironmentDeploymentStatus(): this;
    /**
     * Grants permission to update EnvironmentProfile configuration
     *
     * Access Level: Write
     */
    toUpdateEnvironmentProfile(): this;
    /**
     * Grants permission to update a business glossary
     *
     * Access Level: Write
     */
    toUpdateGlossary(): this;
    /**
     * Grants permission to update a glossary term
     *
     * Access Level: Write
     */
    toUpdateGlossaryTerm(): this;
    /**
     * Grants permission to update a DataZone group profile
     *
     * Access Level: Write
     */
    toUpdateGroupProfile(): this;
    /**
     * Grants permission to update a Project that enables your team to publish and subscribe to data
     *
     * Access Level: Write
     */
    toUpdateProject(): this;
    /**
     * Grants permission to update a project profile
     *
     * Access Level: Write
     */
    toUpdateProjectProfile(): this;
    /**
     * Grants permission to update rule
     *
     * Access Level: Write
     */
    toUpdateRule(): this;
    /**
     * Grants permission to update a subscription grant status for custom grants
     *
     * Access Level: Write
     */
    toUpdateSubscriptionGrantStatus(): this;
    /**
     * Grants permission to update business reason for subscription request for a Data Asset
     *
     * Access Level: Write
     */
    toUpdateSubscriptionRequest(): this;
    /**
     * Grants permission to update a subscription target
     *
     * Access Level: Write
     */
    toUpdateSubscriptionTarget(): this;
    /**
     * Grants permission to update a DataZone user profile
     *
     * Access Level: Write
     */
    toUpdateUserProfile(): this;
    /**
     * Grants permission to validate pass role
     *
     * Access Level: Write
     */
    toValidatePassRole(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type domain to the statement
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/create-domain.html
     *
     * @param domainId - Identifier for the domainId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDomain(domainId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateDomain()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - domain
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateDomain()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the domain ID passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#amazondatazone-policy-keys
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifDomainId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the project ID passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#amazondatazone-policy-keys
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifProjectId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the user ID passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#amazondatazone-policy-keys
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifUserId(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [datazone](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondatazone.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
