"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Datazone = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [datazone](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondatazone.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Datazone extends shared_1.PolicyStatement {
    /**
     * Grants permission to accept prediction
     *
     * Access Level: Write
     */
    toAcceptPredictions() {
        return this.to('AcceptPredictions');
    }
    /**
     * Grants permission to approve a subscription request for a Data Asset
     *
     * Access Level: Write
     */
    toAcceptSubscriptionRequest() {
        return this.to('AcceptSubscriptionRequest');
    }
    /**
     * Grants permission to add an owner to an entity like domain unit
     *
     * Access Level: Write
     */
    toAddEntityOwner() {
        return this.to('AddEntityOwner');
    }
    /**
     * Grants permission to add a policy grant
     *
     * Access Level: Permissions management
     */
    toAddPolicyGrant() {
        return this.to('AddPolicyGrant');
    }
    /**
     * Grants permission to associate a role in a default service blueprint environment
     *
     * Access Level: Write
     */
    toAssociateEnvironmentRole() {
        return this.to('AssociateEnvironmentRole');
    }
    /**
     * Grants permission to associate governed terms to an asset
     *
     * Access Level: Write
     */
    toAssociateGovernedTerms() {
        return this.to('AssociateGovernedTerms');
    }
    /**
     * Grants permission to remove linked type items from an Amazon DataZone Domain
     *
     * Access Level: Write
     */
    toBatchDeleteLinkedTypes() {
        return this.to('BatchDeleteLinkedTypes');
    }
    /**
     * Grants permission to put linked type items to an Amazon DataZone Domain
     *
     * Access Level: Write
     */
    toBatchPutLinkedTypes() {
        return this.to('BatchPutLinkedTypes');
    }
    /**
     * Grants permission to cancel metadata generation run
     *
     * Access Level: Write
     */
    toCancelMetadataGenerationRun() {
        return this.to('CancelMetadataGenerationRun');
    }
    /**
     * Grants permission to revoke or unsubscribe an approved subscription to Data Asset
     *
     * Access Level: Write
     */
    toCancelSubscription() {
        return this.to('CancelSubscription');
    }
    /**
     * Grants permission to create an account pool
     *
     * Access Level: Write
     */
    toCreateAccountPool() {
        return this.to('CreateAccountPool');
    }
    /**
     * Grants permission to create asset
     *
     * Access Level: Write
     */
    toCreateAsset() {
        return this.to('CreateAsset');
    }
    /**
     * Grants permission to create asset filter
     *
     * Access Level: Write
     */
    toCreateAssetFilter() {
        return this.to('CreateAssetFilter');
    }
    /**
     * Grants permission to create new revision of an asset
     *
     * Access Level: Write
     */
    toCreateAssetRevision() {
        return this.to('CreateAssetRevision');
    }
    /**
     * Grants permission to create an asset type
     *
     * Access Level: Write
     */
    toCreateAssetType() {
        return this.to('CreateAssetType');
    }
    /**
     * Grants permission to create connections
     *
     * Access Level: Write
     */
    toCreateConnection() {
        return this.to('CreateConnection');
    }
    /**
     * Grants permission to create data product
     *
     * Access Level: Write
     */
    toCreateDataProduct() {
        return this.to('CreateDataProduct');
    }
    /**
     * Grants permission to create data product revision
     *
     * Access Level: Write
     */
    toCreateDataProductRevision() {
        return this.to('CreateDataProductRevision');
    }
    /**
     * Grants permission to create a new DataSource
     *
     * Access Level: Write
     */
    toCreateDataSource() {
        return this.to('CreateDataSource');
    }
    /**
     * Grants permission to provision a domain which is a top level entity that contains other Amazon DataZone resources
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     */
    toCreateDomain() {
        return this.to('CreateDomain');
    }
    /**
     * Grants permission to create a domain unit
     *
     * Access Level: Write
     */
    toCreateDomainUnit() {
        return this.to('CreateDomainUnit');
    }
    /**
     * Grants permission to create a collection of configurated resources used to publish and subscribe to data
     *
     * Access Level: Write
     */
    toCreateEnvironment() {
        return this.to('CreateEnvironment');
    }
    /**
     * Grants permission to create an environment action in a default service blueprint environment
     *
     * Access Level: Write
     */
    toCreateEnvironmentAction() {
        return this.to('CreateEnvironmentAction');
    }
    /**
     * Grants permission to create a custom Environment Blueprint that allow user to add Environments to their Project
     *
     * Access Level: Write
     */
    toCreateEnvironmentBlueprint() {
        return this.to('CreateEnvironmentBlueprint');
    }
    /**
     * Grants permission to create a template from a Blueprint that can be used to create a Environment
     *
     * Access Level: Write
     */
    toCreateEnvironmentProfile() {
        return this.to('CreateEnvironmentProfile');
    }
    /**
     * Grants permission to create a form type or a new revision of it
     *
     * Access Level: Write
     */
    toCreateFormType() {
        return this.to('CreateFormType');
    }
    /**
     * Grants permission to create a business glossary
     *
     * Access Level: Write
     */
    toCreateGlossary() {
        return this.to('CreateGlossary');
    }
    /**
     * Grants permission to create a glossary term
     *
     * Access Level: Write
     */
    toCreateGlossaryTerm() {
        return this.to('CreateGlossaryTerm');
    }
    /**
     * Grants permission to create a DataZone group profile for an IAM Identity Center group
     *
     * Access Level: Write
     */
    toCreateGroupProfile() {
        return this.to('CreateGroupProfile');
    }
    /**
     * Grants permission to create listing change set
     *
     * Access Level: Write
     */
    toCreateListingChangeSet() {
        return this.to('CreateListingChangeSet');
    }
    /**
     * Grants permission to create a Project to enable your team to publish and subscribe to data
     *
     * Access Level: Write
     */
    toCreateProject() {
        return this.to('CreateProject');
    }
    /**
     * Grants permission to add a user to a Project
     *
     * Access Level: Write
     */
    toCreateProjectMembership() {
        return this.to('CreateProjectMembership');
    }
    /**
     * Grants permission to create a project profile
     *
     * Access Level: Write
     */
    toCreateProjectProfile() {
        return this.to('CreateProjectProfile');
    }
    /**
     * Grants permission to create rule
     *
     * Access Level: Write
     */
    toCreateRule() {
        return this.to('CreateRule');
    }
    /**
     * Grants permission to create a grant for an approved subscription on a subscription target
     *
     * Access Level: Write
     */
    toCreateSubscriptionGrant() {
        return this.to('CreateSubscriptionGrant');
    }
    /**
     * Grants permission to create a subscription request for a Data Asset
     *
     * Access Level: Write
     */
    toCreateSubscriptionRequest() {
        return this.to('CreateSubscriptionRequest');
    }
    /**
     * Grants permission to create a subscription target for a Environment in the project
     *
     * Access Level: Write
     */
    toCreateSubscriptionTarget() {
        return this.to('CreateSubscriptionTarget');
    }
    /**
     * Grants permission to create a user profile for an existing user in the customers IAM Identity Center
     *
     * Access Level: Write
     */
    toCreateUserProfile() {
        return this.to('CreateUserProfile');
    }
    /**
     * Grants permission to delete an account pool
     *
     * Access Level: Write
     */
    toDeleteAccountPool() {
        return this.to('DeleteAccountPool');
    }
    /**
     * Grants permission to delete an asset
     *
     * Access Level: Write
     */
    toDeleteAsset() {
        return this.to('DeleteAsset');
    }
    /**
     * Grants permission to delete asset filter
     *
     * Access Level: Write
     */
    toDeleteAssetFilter() {
        return this.to('DeleteAssetFilter');
    }
    /**
     * Grants permission to delete an asset type
     *
     * Access Level: Write
     */
    toDeleteAssetType() {
        return this.to('DeleteAssetType');
    }
    /**
     * Grants permission to delete connections
     *
     * Access Level: Write
     */
    toDeleteConnection() {
        return this.to('DeleteConnection');
    }
    /**
     * Grants permission to delete data product
     *
     * Access Level: Write
     */
    toDeleteDataProduct() {
        return this.to('DeleteDataProduct');
    }
    /**
     * Grants permission to update existing DataSource
     *
     * Access Level: Write
     */
    toDeleteDataSource() {
        return this.to('DeleteDataSource');
    }
    /**
     * Grants permission to delete a provisioned domain
     *
     * Access Level: Write
     */
    toDeleteDomain() {
        return this.to('DeleteDomain');
    }
    /**
     * Grants permission to delete a resource policy for a DataZone Domain
     *
     * Access Level: Permissions management
     */
    toDeleteDomainSharingPolicy() {
        return this.to('DeleteDomainSharingPolicy');
    }
    /**
     * Grants permission to delete an existing domain unit
     *
     * Access Level: Write
     */
    toDeleteDomainUnit() {
        return this.to('DeleteDomainUnit');
    }
    /**
     * Grants permission to Delete Environment
     *
     * Access Level: Write
     */
    toDeleteEnvironment() {
        return this.to('DeleteEnvironment');
    }
    /**
     * Grants permission to delete an environment action in a default service blueprint environment
     *
     * Access Level: Write
     */
    toDeleteEnvironmentAction() {
        return this.to('DeleteEnvironmentAction');
    }
    /**
     * Grants permission to delete Environment Blueprint
     *
     * Access Level: Write
     */
    toDeleteEnvironmentBlueprint() {
        return this.to('DeleteEnvironmentBlueprint');
    }
    /**
     * Grants permission to delete environment blueprint configuration
     *
     * Access Level: Write
     */
    toDeleteEnvironmentBlueprintConfiguration() {
        return this.to('DeleteEnvironmentBlueprintConfiguration');
    }
    /**
     * Grants permission to delete Environment Profile
     *
     * Access Level: Write
     */
    toDeleteEnvironmentProfile() {
        return this.to('DeleteEnvironmentProfile');
    }
    /**
     * Grants permission to delete a form type
     *
     * Access Level: Write
     */
    toDeleteFormType() {
        return this.to('DeleteFormType');
    }
    /**
     * Grants permission to delete a business glossary
     *
     * Access Level: Write
     */
    toDeleteGlossary() {
        return this.to('DeleteGlossary');
    }
    /**
     * Grants permission to delete a glossary term
     *
     * Access Level: Write
     */
    toDeleteGlossaryTerm() {
        return this.to('DeleteGlossaryTerm');
    }
    /**
     * Grants permission to delete listing
     *
     * Access Level: Write
     */
    toDeleteListing() {
        return this.to('DeleteListing');
    }
    /**
     * Grants permission to delete a Project that enables your team to publish and subscribe to data
     *
     * Access Level: Write
     */
    toDeleteProject() {
        return this.to('DeleteProject');
    }
    /**
     * Grants permission to remove a user from a project
     *
     * Access Level: Write
     */
    toDeleteProjectMembership() {
        return this.to('DeleteProjectMembership');
    }
    /**
     * Grants permission to delete a project profile
     *
     * Access Level: Write
     */
    toDeleteProjectProfile() {
        return this.to('DeleteProjectProfile');
    }
    /**
     * Grants permission to delete rule
     *
     * Access Level: Write
     */
    toDeleteRule() {
        return this.to('DeleteRule');
    }
    /**
     * Grants permission to delete a subscription grant from a subscription target
     *
     * Access Level: Write
     */
    toDeleteSubscriptionGrant() {
        return this.to('DeleteSubscriptionGrant');
    }
    /**
     * Grants permission to delete a pending subscription request for a Data Asset
     *
     * Access Level: Write
     */
    toDeleteSubscriptionRequest() {
        return this.to('DeleteSubscriptionRequest');
    }
    /**
     * Grants permission to delete a subscription target from a Environment in the project
     *
     * Access Level: Write
     */
    toDeleteSubscriptionTarget() {
        return this.to('DeleteSubscriptionTarget');
    }
    /**
     * Grants permission to delete existing TimeSeriesDataPoints
     *
     * Access Level: Write
     */
    toDeleteTimeSeriesDataPoints() {
        return this.to('DeleteTimeSeriesDataPoints');
    }
    /**
     * Grants permission to disassociate a role in a default service blueprint environment
     *
     * Access Level: Write
     */
    toDisassociateEnvironmentRole() {
        return this.to('DisassociateEnvironmentRole');
    }
    /**
     * Grants permission to disassociate governed terms to an asset
     *
     * Access Level: Write
     */
    toDisassociateGovernedTerms() {
        return this.to('DisassociateGovernedTerms');
    }
    /**
     * Grants permission to get account pool details
     *
     * Access Level: Read
     */
    toGetAccountPool() {
        return this.to('GetAccountPool');
    }
    /**
     * Grants permission to retrieve an asset
     *
     * Access Level: Read
     */
    toGetAsset() {
        return this.to('GetAsset');
    }
    /**
     * Grants permission to get asset filter
     *
     * Access Level: Read
     */
    toGetAssetFilter() {
        return this.to('GetAssetFilter');
    }
    /**
     * Grants permission to get an asset type
     *
     * Access Level: Read
     */
    toGetAssetType() {
        return this.to('GetAssetType');
    }
    /**
     * Grants permission to get connections
     *
     * Access Level: Read
     */
    toGetConnection() {
        return this.to('GetConnection');
    }
    /**
     * Grants permission to get data product
     *
     * Access Level: Read
     */
    toGetDataProduct() {
        return this.to('GetDataProduct');
    }
    /**
     * Grants permission to Get a existing DataSource in Amazon DataZone using its identifier
     *
     * Access Level: Read
     */
    toGetDataSource() {
        return this.to('GetDataSource');
    }
    /**
     * Grants permission to get DataSource run job in Amazon DataZone using it's identifier
     *
     * Access Level: Read
     */
    toGetDataSourceRun() {
        return this.to('GetDataSourceRun');
    }
    /**
     * Grants permission to retrieve information about a domain
     *
     * Access Level: Read
     */
    toGetDomain() {
        return this.to('GetDomain');
    }
    /**
     * Grants permission to use features that require access to domain execution role credentials
     *
     * Access Level: Read
     */
    toGetDomainExecutionRoleCredentials() {
        return this.to('GetDomainExecutionRoleCredentials');
    }
    /**
     * Grants permission to retrieve a resource policy for a DataZone Domain
     *
     * Access Level: Read
     */
    toGetDomainSharingPolicy() {
        return this.to('GetDomainSharingPolicy');
    }
    /**
     * Grants permission to get an existing domain unit
     *
     * Access Level: Read
     */
    toGetDomainUnit() {
        return this.to('GetDomainUnit');
    }
    /**
     * Grants permission to get Environment details
     *
     * Access Level: Read
     */
    toGetEnvironment() {
        return this.to('GetEnvironment');
    }
    /**
     * Grants permission to get an environment action in a default service blueprint environment
     *
     * Access Level: Read
     */
    toGetEnvironmentAction() {
        return this.to('GetEnvironmentAction');
    }
    /**
     * Grants permission to get environment action link
     *
     * Access Level: Read
     */
    toGetEnvironmentActionLink() {
        return this.to('GetEnvironmentActionLink');
    }
    /**
     * Grants permission to get Environment Blueprint details
     *
     * Access Level: Read
     */
    toGetEnvironmentBlueprint() {
        return this.to('GetEnvironmentBlueprint');
    }
    /**
     * Grants permission to get environment blueprint configuration
     *
     * Access Level: Read
     */
    toGetEnvironmentBlueprintConfiguration() {
        return this.to('GetEnvironmentBlueprintConfiguration');
    }
    /**
     * Grants permission to get short term credentials that assume the Environment user role
     *
     * Access Level: Read
     */
    toGetEnvironmentCredentials() {
        return this.to('GetEnvironmentCredentials');
    }
    /**
     * Grants permission to get Environment Profile details
     *
     * Access Level: Read
     */
    toGetEnvironmentProfile() {
        return this.to('GetEnvironmentProfile');
    }
    /**
     * Grants permission to get a form type
     *
     * Access Level: Read
     */
    toGetFormType() {
        return this.to('GetFormType');
    }
    /**
     * Grants permission to get a business glossary
     *
     * Access Level: Read
     */
    toGetGlossary() {
        return this.to('GetGlossary');
    }
    /**
     * Grants permission to get a glossary term
     *
     * Access Level: Read
     */
    toGetGlossaryTerm() {
        return this.to('GetGlossaryTerm');
    }
    /**
     * Grants permission to retrieve an existing DataZone group profile
     *
     * Access Level: Read
     */
    toGetGroupProfile() {
        return this.to('GetGroupProfile');
    }
    /**
     * Grants permission to an IAM principal to log into the DataZone Portal
     *
     * Access Level: Permissions management
     */
    toGetIamPortalLoginUrl() {
        return this.to('GetIamPortalLoginUrl');
    }
    /**
     * Grants permission to get job runs
     *
     * Access Level: Read
     */
    toGetJobRun() {
        return this.to('GetJobRun');
    }
    /**
     * Grants permission to get lineage events
     *
     * Access Level: Read
     */
    toGetLineageEvent() {
        return this.to('GetLineageEvent');
    }
    /**
     * Grants permission to get the lineage node
     *
     * Access Level: Read
     */
    toGetLineageNode() {
        return this.to('GetLineageNode');
    }
    /**
     * Grants permission to get listing
     *
     * Access Level: Read
     */
    toGetListing() {
        return this.to('GetListing');
    }
    /**
     * Grants permission to get metadata generation run
     *
     * Access Level: Read
     */
    toGetMetadataGenerationRun() {
        return this.to('GetMetadataGenerationRun');
    }
    /**
     * Grants permission to get Project details
     *
     * Access Level: Read
     */
    toGetProject() {
        return this.to('GetProject');
    }
    /**
     * Grants permission to get project profile details
     *
     * Access Level: Read
     */
    toGetProjectProfile() {
        return this.to('GetProjectProfile');
    }
    /**
     * Grants permission to get rule
     *
     * Access Level: Read
     */
    toGetRule() {
        return this.to('GetRule');
    }
    /**
     * Grants permission to retrieve a subscription
     *
     * Access Level: Read
     */
    toGetSubscription() {
        return this.to('GetSubscription');
    }
    /**
     * Grants permission to get subscription eligibilty
     *
     * Access Level: Read
     */
    toGetSubscriptionEligibility() {
        return this.to('GetSubscriptionEligibility');
    }
    /**
     * Grants permission to retireve a subscription grant
     *
     * Access Level: Read
     */
    toGetSubscriptionGrant() {
        return this.to('GetSubscriptionGrant');
    }
    /**
     * Grants permission to reject a subscription request for a Data Asset
     *
     * Access Level: Read
     */
    toGetSubscriptionRequestDetails() {
        return this.to('GetSubscriptionRequestDetails');
    }
    /**
     * Grants permission to retireve details of subscription target
     *
     * Access Level: Read
     */
    toGetSubscriptionTarget() {
        return this.to('GetSubscriptionTarget');
    }
    /**
     * Grants permission to get an existing TimeSeriesDataPoints in Amazon DataZone using its identifier
     *
     * Access Level: Read
     */
    toGetTimeSeriesDataPoint() {
        return this.to('GetTimeSeriesDataPoint');
    }
    /**
     * Grants permission to get update eligibility status for project constructs
     *
     * Access Level: Read
     */
    toGetUpdateEligibility() {
        return this.to('GetUpdateEligibility');
    }
    /**
     * Grants permission to retrieve a user profile for an existing user in the DataZone Domain
     *
     * Access Level: Read
     */
    toGetUserProfile() {
        return this.to('GetUserProfile');
    }
    /**
     * Grants permission to list Environments across all domains in an AWS Account
     *
     * Access Level: List
     */
    toListAccountEnvironments() {
        return this.to('ListAccountEnvironments');
    }
    /**
     * Grants permission to list account pools
     *
     * Access Level: List
     */
    toListAccountPools() {
        return this.to('ListAccountPools');
    }
    /**
     * Grants permission to list accounts in an account pool
     *
     * Access Level: List
     */
    toListAccountsInAccountPool() {
        return this.to('ListAccountsInAccountPool');
    }
    /**
     * Grants permission to list asset filters
     *
     * Access Level: List
     */
    toListAssetFilters() {
        return this.to('ListAssetFilters');
    }
    /**
     * Grants permission to list revisions of an asset
     *
     * Access Level: List
     */
    toListAssetRevisions() {
        return this.to('ListAssetRevisions');
    }
    /**
     * Grants permission to list connections
     *
     * Access Level: List
     */
    toListConnections() {
        return this.to('ListConnections');
    }
    /**
     * Grants permission to list data product revisions
     *
     * Access Level: List
     */
    toListDataProductRevisions() {
        return this.to('ListDataProductRevisions');
    }
    /**
     * Grants permission to list DataSource runs job's activities on Asset
     *
     * Access Level: List
     */
    toListDataSourceRunActivities() {
        return this.to('ListDataSourceRunActivities');
    }
    /**
     * Grants permission to list DataSource runs job
     *
     * Access Level: List
     */
    toListDataSourceRuns() {
        return this.to('ListDataSourceRuns');
    }
    /**
     * Grants permission to list existing DataSources
     *
     * Access Level: List
     */
    toListDataSources() {
        return this.to('ListDataSources');
    }
    /**
     * Grants permission to list child domain units for a given parent domain unit
     *
     * Access Level: List
     */
    toListDomainUnitsForParent() {
        return this.to('ListDomainUnitsForParent');
    }
    /**
     * Grants permission to retrieve all domains
     *
     * Access Level: List
     */
    toListDomains() {
        return this.to('ListDomains');
    }
    /**
     * Grants permission to list owners of an entity like domain unit
     *
     * Access Level: List
     */
    toListEntityOwners() {
        return this.to('ListEntityOwners');
    }
    /**
     * Grants permission to list environment actions in a default service blueprint environment
     *
     * Access Level: List
     */
    toListEnvironmentActions() {
        return this.to('ListEnvironmentActions');
    }
    /**
     * Grants permission to list environment blueprint configuration summaries
     *
     * Access Level: List
     */
    toListEnvironmentBlueprintConfigurationSummaries() {
        return this.to('ListEnvironmentBlueprintConfigurationSummaries');
    }
    /**
     * Grants permission to list environment blueprint configurations
     *
     * Access Level: List
     */
    toListEnvironmentBlueprintConfigurations() {
        return this.to('ListEnvironmentBlueprintConfigurations');
    }
    /**
     * Grants permission to list Domain for Environment Blueprints
     *
     * Access Level: List
     */
    toListEnvironmentBlueprints() {
        return this.to('ListEnvironmentBlueprints');
    }
    /**
     * Grants permission to list Domain for Environment Profiles
     *
     * Access Level: List
     */
    toListEnvironmentProfiles() {
        return this.to('ListEnvironmentProfiles');
    }
    /**
     * Grants permission to show Environments in the Domain
     *
     * Access Level: List
     */
    toListEnvironments() {
        return this.to('ListEnvironments');
    }
    /**
     * Grants permission to list all the DataZone group profiles that the DataZone user profile is a member of
     *
     * Access Level: List
     */
    toListGroupsForUser() {
        return this.to('ListGroupsForUser');
    }
    /**
     * Grants permission to list job runs
     *
     * Access Level: List
     */
    toListJobRuns() {
        return this.to('ListJobRuns');
    }
    /**
     * Grants permission to list lineage events
     *
     * Access Level: List
     */
    toListLineageEvents() {
        return this.to('ListLineageEvents');
    }
    /**
     * Grants permission to list historical versions of lineage node
     *
     * Access Level: List
     */
    toListLineageNodeHistory() {
        return this.to('ListLineageNodeHistory');
    }
    /**
     * Grants permission to list linked type items linked to an Amazon DataZone Domain
     *
     * Access Level: List
     */
    toListLinkedTypes() {
        return this.to('ListLinkedTypes');
    }
    /**
     * Grants permission to list metadata generation runs
     *
     * Access Level: List
     */
    toListMetadataGenerationRuns() {
        return this.to('ListMetadataGenerationRuns');
    }
    /**
     * Grants permission to list notifications and events for a datazone user
     *
     * Access Level: List
     */
    toListNotifications() {
        return this.to('ListNotifications');
    }
    /**
     * Grants permission to list policy grants
     *
     * Access Level: List
     */
    toListPolicyGrants() {
        return this.to('ListPolicyGrants');
    }
    /**
     * Grants permission to list Project Members
     *
     * Access Level: List
     */
    toListProjectMemberships() {
        return this.to('ListProjectMemberships');
    }
    /**
     * Grants permission to list project profiles
     *
     * Access Level: List
     */
    toListProjectProfiles() {
        return this.to('ListProjectProfiles');
    }
    /**
     * Grants permission to list Projects
     *
     * Access Level: List
     */
    toListProjects() {
        return this.to('ListProjects');
    }
    /**
     * Grants permission to list rules
     *
     * Access Level: List
     */
    toListRules() {
        return this.to('ListRules');
    }
    /**
     * Grants permission to List subscription grants for a subscribed principal
     *
     * Access Level: List
     */
    toListSubscriptionGrants() {
        return this.to('ListSubscriptionGrants');
    }
    /**
     * Grants permission to list subscription requests
     *
     * Access Level: List
     */
    toListSubscriptionRequests() {
        return this.to('ListSubscriptionRequests');
    }
    /**
     * Grants permission to list subscription targets
     *
     * Access Level: List
     */
    toListSubscriptionTargets() {
        return this.to('ListSubscriptionTargets');
    }
    /**
     * Grants permission to list subscriptions
     *
     * Access Level: List
     */
    toListSubscriptions() {
        return this.to('ListSubscriptions');
    }
    /**
     * Grants permission to retrieve all tags associated with a resource
     *
     * Access Level: Read
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list existing TimeSeriesDataPoints
     *
     * Access Level: List
     */
    toListTimeSeriesDataPoints() {
        return this.to('ListTimeSeriesDataPoints');
    }
    /**
     * Grants permission to list available Manager Secrets
     *
     * Access Level: List
     */
    toListWarehouseMetadata() {
        return this.to('ListWarehouseMetadata');
    }
    /**
     * Grants permission to post lineage events
     *
     * Access Level: Write
     */
    toPostLineageEvent() {
        return this.to('PostLineageEvent');
    }
    /**
     * Grants permission to post a new TimeSeriesDataPoints
     *
     * Access Level: Write
     */
    toPostTimeSeriesDataPoints() {
        return this.to('PostTimeSeriesDataPoints');
    }
    /**
     * Grants permission to provision domain with default project setup
     *
     * Access Level: Write
     */
    toProvisionDomain() {
        return this.to('ProvisionDomain');
    }
    /**
     * Grants permission to add a resource policy for a DataZone Domain
     *
     * Access Level: Permissions management
     */
    toPutDomainSharingPolicy() {
        return this.to('PutDomainSharingPolicy');
    }
    /**
     * Grants permission to put environment blueprint configuration
     *
     * Access Level: Write
     */
    toPutEnvironmentBlueprintConfiguration() {
        return this.to('PutEnvironmentBlueprintConfiguration');
    }
    /**
     * Grants permission to refresh token
     *
     * Access Level: Write
     */
    toRefreshToken() {
        return this.to('RefreshToken');
    }
    /**
     * Grants permission to reject prediction
     *
     * Access Level: Write
     */
    toRejectPredictions() {
        return this.to('RejectPredictions');
    }
    /**
     * Grants permission to reject a subscription request for a Data Asset
     *
     * Access Level: Write
     */
    toRejectSubscriptionRequest() {
        return this.to('RejectSubscriptionRequest');
    }
    /**
     * Grants permission to remove an existing owner of an entity like domain unit
     *
     * Access Level: Write
     */
    toRemoveEntityOwner() {
        return this.to('RemoveEntityOwner');
    }
    /**
     * Grants permission to remove a policy grant
     *
     * Access Level: Permissions management
     */
    toRemovePolicyGrant() {
        return this.to('RemovePolicyGrant');
    }
    /**
     * Grants permission to revoke a subscription
     *
     * Access Level: Permissions management
     */
    toRevokeSubscription() {
        return this.to('RevokeSubscription');
    }
    /**
     * Grants permission to search datazone entities
     *
     * Access Level: List
     */
    toSearch() {
        return this.to('Search');
    }
    /**
     * Grants permission to search DataZone group profiles and IAM Identity Center groups
     *
     * Access Level: List
     */
    toSearchGroupProfiles() {
        return this.to('SearchGroupProfiles');
    }
    /**
     * Grants permission to search listings
     *
     * Access Level: List
     */
    toSearchListings() {
        return this.to('SearchListings');
    }
    /**
     * Grants permission to search rules
     *
     * Access Level: List
     */
    toSearchRules() {
        return this.to('SearchRules');
    }
    /**
     * Grants permission to search types such asset types and form types in a domain
     *
     * Access Level: List
     */
    toSearchTypes() {
        return this.to('SearchTypes');
    }
    /**
     * Grants permission to search DataZone user profiles, IAM Identity Center users, and DataZone IAM principal profiles
     *
     * Access Level: List
     */
    toSearchUserProfiles() {
        return this.to('SearchUserProfiles');
    }
    /**
     * Grants permission to login using SSO
     *
     * Access Level: Write
     */
    toSsoLogin() {
        return this.to('SsoLogin');
    }
    /**
     * Grants permission to logout as SSO user
     *
     * Access Level: Write
     */
    toSsoLogout() {
        return this.to('SsoLogout');
    }
    /**
     * Grants permission to start account bootstrap action for a domain
     *
     * Access Level: Write
     */
    toStartAccountBootstrapAction() {
        return this.to('StartAccountBootstrapAction');
    }
    /**
     * Grants permission to start a DataSource run job
     *
     * Access Level: Write
     */
    toStartDataSourceRun() {
        return this.to('StartDataSourceRun');
    }
    /**
     * Grants permission to start metadata generation run
     *
     * Access Level: Write
     */
    toStartMetadataGenerationRun() {
        return this.to('StartMetadataGenerationRun');
    }
    /**
     * Grants permission to stop metadata generation run
     *
     * Access Level: Write
     */
    toStopMetadataGenerationRun() {
        return this.to('StopMetadataGenerationRun');
    }
    /**
     * Grants permission to add or update tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove tags associated with a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update an account pool
     *
     * Access Level: Write
     */
    toUpdateAccountPool() {
        return this.to('UpdateAccountPool');
    }
    /**
     * Grants permission to update asset filter
     *
     * Access Level: Write
     */
    toUpdateAssetFilter() {
        return this.to('UpdateAssetFilter');
    }
    /**
     * Grants permission to update connections
     *
     * Access Level: Write
     */
    toUpdateConnection() {
        return this.to('UpdateConnection');
    }
    /**
     * Grants permission to update existing DataSource
     *
     * Access Level: Write
     */
    toUpdateDataSource() {
        return this.to('UpdateDataSource');
    }
    /**
     * Grants permission to update data source run activities
     *
     * Access Level: Write
     */
    toUpdateDataSourceRunActivities() {
        return this.to('UpdateDataSourceRunActivities');
    }
    /**
     * Grants permission to update information for a domain
     *
     * Access Level: Write
     */
    toUpdateDomain() {
        return this.to('UpdateDomain');
    }
    /**
     * Grants permission to update an existing domain unit
     *
     * Access Level: Write
     */
    toUpdateDomainUnit() {
        return this.to('UpdateDomainUnit');
    }
    /**
     * Grants permission to update Environment settings
     *
     * Access Level: Write
     */
    toUpdateEnvironment() {
        return this.to('UpdateEnvironment');
    }
    /**
     * Grants permission to update an environment action in a default service blueprint environment
     *
     * Access Level: Write
     */
    toUpdateEnvironmentAction() {
        return this.to('UpdateEnvironmentAction');
    }
    /**
     * Grants permission to update Environment Blueprint settings
     *
     * Access Level: Write
     */
    toUpdateEnvironmentBlueprint() {
        return this.to('UpdateEnvironmentBlueprint');
    }
    /**
     * Grants permission to update environment configuration
     *
     * Access Level: Write
     */
    toUpdateEnvironmentConfiguration() {
        return this.to('UpdateEnvironmentConfiguration');
    }
    /**
     * Grants permission to update status of the Environment deployment
     *
     * Access Level: Write
     */
    toUpdateEnvironmentDeploymentStatus() {
        return this.to('UpdateEnvironmentDeploymentStatus');
    }
    /**
     * Grants permission to update EnvironmentProfile configuration
     *
     * Access Level: Write
     */
    toUpdateEnvironmentProfile() {
        return this.to('UpdateEnvironmentProfile');
    }
    /**
     * Grants permission to update a business glossary
     *
     * Access Level: Write
     */
    toUpdateGlossary() {
        return this.to('UpdateGlossary');
    }
    /**
     * Grants permission to update a glossary term
     *
     * Access Level: Write
     */
    toUpdateGlossaryTerm() {
        return this.to('UpdateGlossaryTerm');
    }
    /**
     * Grants permission to update a DataZone group profile
     *
     * Access Level: Write
     */
    toUpdateGroupProfile() {
        return this.to('UpdateGroupProfile');
    }
    /**
     * Grants permission to update a Project that enables your team to publish and subscribe to data
     *
     * Access Level: Write
     */
    toUpdateProject() {
        return this.to('UpdateProject');
    }
    /**
     * Grants permission to update a project profile
     *
     * Access Level: Write
     */
    toUpdateProjectProfile() {
        return this.to('UpdateProjectProfile');
    }
    /**
     * Grants permission to update rule
     *
     * Access Level: Write
     */
    toUpdateRule() {
        return this.to('UpdateRule');
    }
    /**
     * Grants permission to update a subscription grant status for custom grants
     *
     * Access Level: Write
     */
    toUpdateSubscriptionGrantStatus() {
        return this.to('UpdateSubscriptionGrantStatus');
    }
    /**
     * Grants permission to update business reason for subscription request for a Data Asset
     *
     * Access Level: Write
     */
    toUpdateSubscriptionRequest() {
        return this.to('UpdateSubscriptionRequest');
    }
    /**
     * Grants permission to update a subscription target
     *
     * Access Level: Write
     */
    toUpdateSubscriptionTarget() {
        return this.to('UpdateSubscriptionTarget');
    }
    /**
     * Grants permission to update a DataZone user profile
     *
     * Access Level: Write
     */
    toUpdateUserProfile() {
        return this.to('UpdateUserProfile');
    }
    /**
     * Grants permission to validate pass role
     *
     * Access Level: Write
     */
    toValidatePassRole() {
        return this.to('ValidatePassRole');
    }
    /**
     * Adds a resource of type domain to the statement
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/create-domain.html
     *
     * @param domainId - Identifier for the domainId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDomain(domainId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:datazone:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:domain/${domainId}`);
    }
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateDomain()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey, value, operator) {
        return this.if(`aws:RequestTag/${tagKey}`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - domain
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey, value, operator) {
        return this.if(`aws:ResourceTag/${tagKey}`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateDomain()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value, operator) {
        return this.if(`aws:TagKeys`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by the domain ID passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#amazondatazone-policy-keys
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifDomainId(value, operator) {
        return this.if(`domainId`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by the project ID passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#amazondatazone-policy-keys
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifProjectId(value, operator) {
        return this.if(`projectId`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by the user ID passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#amazondatazone-policy-keys
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifUserId(value, operator) {
        return this.if(`userId`, value, operator ?? 'StringLike');
    }
    /**
     * Statement provider for service [datazone](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondatazone.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'datazone';
        this.accessLevelList = {
            Write: [
                'AcceptPredictions',
                'AcceptSubscriptionRequest',
                'AddEntityOwner',
                'AssociateEnvironmentRole',
                'AssociateGovernedTerms',
                'BatchDeleteLinkedTypes',
                'BatchPutLinkedTypes',
                'CancelMetadataGenerationRun',
                'CancelSubscription',
                'CreateAccountPool',
                'CreateAsset',
                'CreateAssetFilter',
                'CreateAssetRevision',
                'CreateAssetType',
                'CreateConnection',
                'CreateDataProduct',
                'CreateDataProductRevision',
                'CreateDataSource',
                'CreateDomain',
                'CreateDomainUnit',
                'CreateEnvironment',
                'CreateEnvironmentAction',
                'CreateEnvironmentBlueprint',
                'CreateEnvironmentProfile',
                'CreateFormType',
                'CreateGlossary',
                'CreateGlossaryTerm',
                'CreateGroupProfile',
                'CreateListingChangeSet',
                'CreateProject',
                'CreateProjectMembership',
                'CreateProjectProfile',
                'CreateRule',
                'CreateSubscriptionGrant',
                'CreateSubscriptionRequest',
                'CreateSubscriptionTarget',
                'CreateUserProfile',
                'DeleteAccountPool',
                'DeleteAsset',
                'DeleteAssetFilter',
                'DeleteAssetType',
                'DeleteConnection',
                'DeleteDataProduct',
                'DeleteDataSource',
                'DeleteDomain',
                'DeleteDomainUnit',
                'DeleteEnvironment',
                'DeleteEnvironmentAction',
                'DeleteEnvironmentBlueprint',
                'DeleteEnvironmentBlueprintConfiguration',
                'DeleteEnvironmentProfile',
                'DeleteFormType',
                'DeleteGlossary',
                'DeleteGlossaryTerm',
                'DeleteListing',
                'DeleteProject',
                'DeleteProjectMembership',
                'DeleteProjectProfile',
                'DeleteRule',
                'DeleteSubscriptionGrant',
                'DeleteSubscriptionRequest',
                'DeleteSubscriptionTarget',
                'DeleteTimeSeriesDataPoints',
                'DisassociateEnvironmentRole',
                'DisassociateGovernedTerms',
                'PostLineageEvent',
                'PostTimeSeriesDataPoints',
                'ProvisionDomain',
                'PutEnvironmentBlueprintConfiguration',
                'RefreshToken',
                'RejectPredictions',
                'RejectSubscriptionRequest',
                'RemoveEntityOwner',
                'SsoLogin',
                'SsoLogout',
                'StartAccountBootstrapAction',
                'StartDataSourceRun',
                'StartMetadataGenerationRun',
                'StopMetadataGenerationRun',
                'UpdateAccountPool',
                'UpdateAssetFilter',
                'UpdateConnection',
                'UpdateDataSource',
                'UpdateDataSourceRunActivities',
                'UpdateDomain',
                'UpdateDomainUnit',
                'UpdateEnvironment',
                'UpdateEnvironmentAction',
                'UpdateEnvironmentBlueprint',
                'UpdateEnvironmentConfiguration',
                'UpdateEnvironmentDeploymentStatus',
                'UpdateEnvironmentProfile',
                'UpdateGlossary',
                'UpdateGlossaryTerm',
                'UpdateGroupProfile',
                'UpdateProject',
                'UpdateProjectProfile',
                'UpdateRule',
                'UpdateSubscriptionGrantStatus',
                'UpdateSubscriptionRequest',
                'UpdateSubscriptionTarget',
                'UpdateUserProfile',
                'ValidatePassRole'
            ],
            'Permissions management': [
                'AddPolicyGrant',
                'DeleteDomainSharingPolicy',
                'GetIamPortalLoginUrl',
                'PutDomainSharingPolicy',
                'RemovePolicyGrant',
                'RevokeSubscription'
            ],
            Read: [
                'GetAccountPool',
                'GetAsset',
                'GetAssetFilter',
                'GetAssetType',
                'GetConnection',
                'GetDataProduct',
                'GetDataSource',
                'GetDataSourceRun',
                'GetDomain',
                'GetDomainExecutionRoleCredentials',
                'GetDomainSharingPolicy',
                'GetDomainUnit',
                'GetEnvironment',
                'GetEnvironmentAction',
                'GetEnvironmentActionLink',
                'GetEnvironmentBlueprint',
                'GetEnvironmentBlueprintConfiguration',
                'GetEnvironmentCredentials',
                'GetEnvironmentProfile',
                'GetFormType',
                'GetGlossary',
                'GetGlossaryTerm',
                'GetGroupProfile',
                'GetJobRun',
                'GetLineageEvent',
                'GetLineageNode',
                'GetListing',
                'GetMetadataGenerationRun',
                'GetProject',
                'GetProjectProfile',
                'GetRule',
                'GetSubscription',
                'GetSubscriptionEligibility',
                'GetSubscriptionGrant',
                'GetSubscriptionRequestDetails',
                'GetSubscriptionTarget',
                'GetTimeSeriesDataPoint',
                'GetUpdateEligibility',
                'GetUserProfile',
                'ListTagsForResource'
            ],
            List: [
                'ListAccountEnvironments',
                'ListAccountPools',
                'ListAccountsInAccountPool',
                'ListAssetFilters',
                'ListAssetRevisions',
                'ListConnections',
                'ListDataProductRevisions',
                'ListDataSourceRunActivities',
                'ListDataSourceRuns',
                'ListDataSources',
                'ListDomainUnitsForParent',
                'ListDomains',
                'ListEntityOwners',
                'ListEnvironmentActions',
                'ListEnvironmentBlueprintConfigurationSummaries',
                'ListEnvironmentBlueprintConfigurations',
                'ListEnvironmentBlueprints',
                'ListEnvironmentProfiles',
                'ListEnvironments',
                'ListGroupsForUser',
                'ListJobRuns',
                'ListLineageEvents',
                'ListLineageNodeHistory',
                'ListLinkedTypes',
                'ListMetadataGenerationRuns',
                'ListNotifications',
                'ListPolicyGrants',
                'ListProjectMemberships',
                'ListProjectProfiles',
                'ListProjects',
                'ListRules',
                'ListSubscriptionGrants',
                'ListSubscriptionRequests',
                'ListSubscriptionTargets',
                'ListSubscriptions',
                'ListTimeSeriesDataPoints',
                'ListWarehouseMetadata',
                'Search',
                'SearchGroupProfiles',
                'SearchListings',
                'SearchRules',
                'SearchTypes',
                'SearchUserProfiles'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
}
exports.Datazone = Datazone;
//# sourceMappingURL=data:application/json;base64,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