import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [mediaconnect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalmediaconnect.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Mediaconnect extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to add outputs to an existing bridge
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_AddBridgeOutputs.html
     */
    toAddBridgeOutputs(): this;
    /**
     * Grants permission to add sources to an existing bridge
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_AddBridgeSources.html
     */
    toAddBridgeSources(): this;
    /**
     * Grants permission to add media streams to any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_AddFlowMediaStreams.html
     */
    toAddFlowMediaStreams(): this;
    /**
     * Grants permission to add outputs to any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_AddFlowOutputs.html
     */
    toAddFlowOutputs(): this;
    /**
     * Grants permission to add sources to any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_AddFlowSources.html
     */
    toAddFlowSources(): this;
    /**
     * Grants permission to add VPC interfaces to any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_AddFlowVpcInterfaces.html
     */
    toAddFlowVpcInterfaces(): this;
    /**
     * Grants permission to create bridges
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_CreateBridge.html
     */
    toCreateBridge(): this;
    /**
     * Grants permission to create flows
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_CreateFlow.html
     */
    toCreateFlow(): this;
    /**
     * Grants permission to create gateways
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_CreateGateway.html
     */
    toCreateGateway(): this;
    /**
     * Grants permission to delete bridges
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_DeleteBridge.html
     */
    toDeleteBridge(): this;
    /**
     * Grants permission to delete flows
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_DeleteFlow.html
     */
    toDeleteFlow(): this;
    /**
     * Grants permission to delete gateways
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_DeleteGateway.html
     */
    toDeleteGateway(): this;
    /**
     * Grants permission to deregister gateway instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_DeregisterGatewayInstance.html
     */
    toDeregisterGatewayInstance(): this;
    /**
     * Grants permission to display the details of a bridge
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_DescribeBridge.html
     */
    toDescribeBridge(): this;
    /**
     * Grants permission to display the details of a flow including the flow ARN, name, and Availability Zone, as well as details about the source, outputs, and entitlements
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_DescribeFlow.html
     */
    toDescribeFlow(): this;
    /**
     * Grants permission to view information about the flow's source transport stream and programs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_DescribeFlowSourceMetadata.html
     */
    toDescribeFlowSourceMetadata(): this;
    /**
     * Grants permission to view flow's source thumbnail
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_DescribeFlowSourceThumbnail.html
     */
    toDescribeFlowSourceThumbnail(): this;
    /**
     * Grants permission to display the details of a gateway including the gateway ARN, name, and CIDR blocks, as well as details about the networks
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_DescribeGateway.html
     */
    toDescribeGateway(): this;
    /**
     * Grants permission to display the details of a gateway instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_DescribeGatewayInstance.html
     */
    toDescribeGatewayInstance(): this;
    /**
     * Grants permission to display the details of an offering
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_DescribeOffering.html
     */
    toDescribeOffering(): this;
    /**
     * Grants permission to display the details of a reservation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_DescribeReservation.html
     */
    toDescribeReservation(): this;
    /**
     * Grants permission to discover gateway poll endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_DiscoverGatewayPollEndpoint.html
     */
    toDiscoverGatewayPollEndpoint(): this;
    /**
     * Grants permission to grant entitlements on any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_GrantFlowEntitlements.html
     */
    toGrantFlowEntitlements(): this;
    /**
     * Grants permission to display a list of bridges that are associated with this account and an optionally specified Arn
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_ListBridges.html
     */
    toListBridges(): this;
    /**
     * Grants permission to display a list of all entitlements that have been granted to the account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_ListEntitlements.html
     */
    toListEntitlements(): this;
    /**
     * Grants permission to display a list of flows that are associated with this account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_ListFlows.html
     */
    toListFlows(): this;
    /**
     * Grants permission to display a list of instances that are associated with this gateway
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_ListGatewayInstances.html
     */
    toListGatewayInstances(): this;
    /**
     * Grants permission to display a list of gateways that are associated with this account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_ListGateways.html
     */
    toListGateways(): this;
    /**
     * Grants permission to display a list of all offerings that are available to the account in the current AWS Region
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_ListOfferings.html
     */
    toListOfferings(): this;
    /**
     * Grants permission to display a list of all reservations that have been purchased by the account in the current AWS Region
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_ListReservations.html
     */
    toListReservations(): this;
    /**
     * Grants permission to display a list of all tags associated with a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to poll gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_PollGateway.html
     */
    toPollGateway(): this;
    /**
     * Grants permission to purchase an offering
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_PurchaseOffering.html
     */
    toPurchaseOffering(): this;
    /**
     * Grants permission to remove an output of an existing bridge
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_RemoveBridgeOutput.html
     */
    toRemoveBridgeOutput(): this;
    /**
     * Grants permission to remove a source of an existing bridge
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_RemoveBridgeSource.html
     */
    toRemoveBridgeSource(): this;
    /**
     * Grants permission to remove media streams from any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_RemoveFlowMediaStream.html
     */
    toRemoveFlowMediaStream(): this;
    /**
     * Grants permission to remove outputs from any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_RemoveFlowOutput.html
     */
    toRemoveFlowOutput(): this;
    /**
     * Grants permission to remove sources from any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_RemoveFlowSource.html
     */
    toRemoveFlowSource(): this;
    /**
     * Grants permission to remove VPC interfaces from any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_RemoveFlowVpcInterface.html
     */
    toRemoveFlowVpcInterface(): this;
    /**
     * Grants permission to revoke entitlements on any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_RevokeFlowEntitlement.html
     */
    toRevokeFlowEntitlement(): this;
    /**
     * Grants permission to start flows
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_StartFlow.html
     */
    toStartFlow(): this;
    /**
     * Grants permission to stop flows
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_StopFlow.html
     */
    toStopFlow(): this;
    /**
     * Grants permission to submit gateway state change
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_SubmitGatewayStateChange.html
     */
    toSubmitGatewayStateChange(): this;
    /**
     * Grants permission to associate tags with resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update bridges
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_UpdateBridge.html
     */
    toUpdateBridge(): this;
    /**
     * Grants permission to update an output of an existing bridge
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_UpdateBridgeOutput.html
     */
    toUpdateBridgeOutput(): this;
    /**
     * Grants permission to update a source of an existing bridge
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_UpdateBridgeSource.html
     */
    toUpdateBridgeSource(): this;
    /**
     * Grants permission to update the state of an existing bridge
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_UpdateBridgeState.html
     */
    toUpdateBridgeState(): this;
    /**
     * Grants permission to update flows
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_UpdateFlow.html
     */
    toUpdateFlow(): this;
    /**
     * Grants permission to update entitlements on any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_UpdateFlowEntitlement.html
     */
    toUpdateFlowEntitlement(): this;
    /**
     * Grants permission to update media streams on any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_UpdateFlowMediaStream.html
     */
    toUpdateFlowMediaStream(): this;
    /**
     * Grants permission to update outputs on any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_UpdateFlowOutput.html
     */
    toUpdateFlowOutput(): this;
    /**
     * Grants permission to update the source of any flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_UpdateFlowSource.html
     */
    toUpdateFlowSource(): this;
    /**
     * Grants permission to update the configuration of an existing Gateway Instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/api/API_UpdateGatewayInstance.html
     */
    toUpdateGatewayInstance(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type Entitlement to the statement
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/entitlements.html
     *
     * @param flowId - Identifier for the flowId.
     * @param entitlementName - Identifier for the entitlementName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEntitlement(flowId: string, entitlementName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Flow to the statement
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/flows.html
     *
     * @param flowId - Identifier for the flowId.
     * @param flowName - Identifier for the flowName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onFlow(flowId: string, flowName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Output to the statement
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/outputs.html
     *
     * @param outputId - Identifier for the outputId.
     * @param outputName - Identifier for the outputName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onOutput(outputId: string, outputName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Source to the statement
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/sources.html
     *
     * @param sourceId - Identifier for the sourceId.
     * @param sourceName - Identifier for the sourceName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSource(sourceId: string, sourceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Gateway to the statement
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/gateway.html
     *
     * @param gatewayId - Identifier for the gatewayId.
     * @param gatewayName - Identifier for the gatewayName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onGateway(gatewayId: string, gatewayName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Bridge to the statement
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/gateway-components-bridges.html
     *
     * @param flowId - Identifier for the flowId.
     * @param flowName - Identifier for the flowName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onBridge(flowId: string, flowName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type GatewayInstance to the statement
     *
     * https://docs.aws.amazon.com/mediaconnect/latest/ug/gateway-components-instances.html
     *
     * @param gatewayId - Identifier for the gatewayId.
     * @param gatewayName - Identifier for the gatewayName.
     * @param instanceId - Identifier for the instanceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onGatewayInstance(gatewayId: string, gatewayName: string, instanceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Statement provider for service [mediaconnect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalmediaconnect.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
