import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [freetier](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsfreetier.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Freetier extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to get a specific activity record
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_freetier_GetAccountActivity.html
     */
    toGetAccountActivity(): this;
    /**
     * Grants permission to get all of the information related to the state of the account plan related to Free Tier
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_freetier_GetAccountPlanState.html
     */
    toGetAccountPlanState(): this;
    /**
     * Grants permission to get free tier alert preference (email address)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/tracking-free-tier-usage.html
     */
    toGetFreeTierAlertPreference(): this;
    /**
     * Grants permission to get free tier usage limits and MTD usage status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/tracking-free-tier-usage.html
     */
    toGetFreeTierUsage(): this;
    /**
     * Grants permission to list available activities
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_freetier_ListAccountActivities.html
     */
    toListAccountActivities(): this;
    /**
     * Grants permission to set free tier alert preference (email address)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/tracking-free-tier-usage.html
     */
    toPutFreeTierAlertPreference(): this;
    /**
     * Grants permission to trigger an upgrade of account plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_freetier_UpgradeAccountPlan.html
     */
    toUpgradeAccountPlan(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [freetier](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsfreetier.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
