"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Freetier = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [freetier](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsfreetier.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Freetier extends shared_1.PolicyStatement {
    /**
     * Grants permission to get a specific activity record
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_freetier_GetAccountActivity.html
     */
    toGetAccountActivity() {
        return this.to('GetAccountActivity');
    }
    /**
     * Grants permission to get all of the information related to the state of the account plan related to Free Tier
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_freetier_GetAccountPlanState.html
     */
    toGetAccountPlanState() {
        return this.to('GetAccountPlanState');
    }
    /**
     * Grants permission to get free tier alert preference (email address)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/tracking-free-tier-usage.html
     */
    toGetFreeTierAlertPreference() {
        return this.to('GetFreeTierAlertPreference');
    }
    /**
     * Grants permission to get free tier usage limits and MTD usage status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/tracking-free-tier-usage.html
     */
    toGetFreeTierUsage() {
        return this.to('GetFreeTierUsage');
    }
    /**
     * Grants permission to list available activities
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_freetier_ListAccountActivities.html
     */
    toListAccountActivities() {
        return this.to('ListAccountActivities');
    }
    /**
     * Grants permission to set free tier alert preference (email address)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/tracking-free-tier-usage.html
     */
    toPutFreeTierAlertPreference() {
        return this.to('PutFreeTierAlertPreference');
    }
    /**
     * Grants permission to trigger an upgrade of account plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_freetier_UpgradeAccountPlan.html
     */
    toUpgradeAccountPlan() {
        return this.to('UpgradeAccountPlan');
    }
    /**
     * Statement provider for service [freetier](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsfreetier.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'freetier';
        this.accessLevelList = {
            Read: [
                'GetAccountActivity',
                'GetAccountPlanState',
                'GetFreeTierAlertPreference',
                'GetFreeTierUsage'
            ],
            List: [
                'ListAccountActivities'
            ],
            Write: [
                'PutFreeTierAlertPreference',
                'UpgradeAccountPlan'
            ]
        };
    }
}
exports.Freetier = Freetier;
//# sourceMappingURL=data:application/json;base64,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