import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [glue](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsglue.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Glue extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to Glue to continuously validate that the target Arn can receive data replicated from the source ARN
     *
     * Access Level: Write
     */
    toAuthorizeInboundIntegration(): this;
    /**
     * Grants permission to create one or more partitions
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-BatchCreatePartition
     */
    toBatchCreatePartition(): this;
    /**
     * Grants permission to delete one or more connections
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-BatchDeleteConnection
     */
    toBatchDeleteConnection(): this;
    /**
     * Grants permission to delete one or more partitions
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-BatchDeletePartition
     */
    toBatchDeletePartition(): this;
    /**
     * Grants permission to delete one or more tables
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-BatchDeleteTable
     */
    toBatchDeleteTable(): this;
    /**
     * Grants permission to delete one or more versions of a table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-DeleteTableVersion
     */
    toBatchDeleteTableVersion(): this;
    /**
     * Grants permission to retrieve one or more blueprints
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-BatchGetBlueprints
     */
    toBatchGetBlueprints(): this;
    /**
     * Grants permission to retrieve one or more crawlers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-BatchGetCrawlers
     */
    toBatchGetCrawlers(): this;
    /**
     * Grants permission to retrieve one or more Custom Entity Types
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-sensitive-data-api.html#aws-glue-api-sensitive-data-api-BatchGetCustomEntityTypes
     */
    toBatchGetCustomEntityTypes(): this;
    /**
     * Grants permission to retrieve one or more development endpoints
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-dev-endpoint.html#aws-glue-api-dev-endpoint-BatchGetDevEndpoints
     */
    toBatchGetDevEndpoints(): this;
    /**
     * Grants permission to retrieve one or more jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-BatchGetJobs
     */
    toBatchGetJobs(): this;
    /**
     * Grants permission to retrieve one or more partitions
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-BatchGetPartition
     */
    toBatchGetPartition(): this;
    /**
     * Grants permission to batch get stage files for SparkUI
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/monitor-spark-ui.html
     */
    toBatchGetStageFiles(): this;
    /**
     * Grants permission to return the configuration for the specified table optimizers
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - glue:GetTable
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-table-optimizers.html#aws-glue-api-table-optimizers-BatchGetTableOptimizer
     */
    toBatchGetTableOptimizer(): this;
    /**
     * Grants permission to retrieve one or more triggers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-BatchGetTriggers
     */
    toBatchGetTriggers(): this;
    /**
     * Grants permission to retrieve one or more workflows
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-BatchGetWorkflows
     */
    toBatchGetWorkflows(): this;
    /**
     * Grants permission to stop one or more job runs for a job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-runs-BatchStopStartJobRun
     */
    toBatchStopJobRun(): this;
    /**
     * Grants permission to update one or more partitions
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-BatchUpdatePartition
     */
    toBatchUpdatePartition(): this;
    /**
     * Grants permission to stop a running Data Quality rule recommendation run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-CancelDataQualityRuleRecommendationRun
     */
    toCancelDataQualityRuleRecommendationRun(): this;
    /**
     * Grants permission to stop a running Data Quality ruleset evaluation run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-CancelDataQualityRulesetEvaluationRun
     */
    toCancelDataQualityRulesetEvaluationRun(): this;
    /**
     * Grants permission to stop a running ML Task Run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-CancelMLTaskRun
     */
    toCancelMLTaskRun(): this;
    /**
     * Grants permission to cancel a statement in an interactive session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-interactive-sessions.html#aws-glue-interactive-sessions-CancelStatement
     */
    toCancelStatement(): this;
    /**
     * Grants permission to retrieve a check the validity of schema version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-CheckSchemaVersionValidity
     */
    toCheckSchemaVersionValidity(): this;
    /**
     * Grants permission to create a blueprint
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-CreateBlueprint
     */
    toCreateBlueprint(): this;
    /**
     * Grants permission to create a catalog
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog.html
     */
    toCreateCatalog(): this;
    /**
     * Grants permission to create a classifier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-classifiers.html#aws-glue-api-crawler-classifiers-CreateClassifier
     */
    toCreateClassifier(): this;
    /**
     * Grants permission to create settings for a column statistics task
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-column-statistics.html#aws-glue-api-crawler-column-statistics-CreateColumnStatisticsTaskSettings
     */
    toCreateColumnStatisticsTaskSettings(): this;
    /**
     * Grants permission to create a connection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-CreateConnection
     */
    toCreateConnection(): this;
    /**
     * Grants permission to create a crawler
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-CreateCrawler
     */
    toCreateCrawler(): this;
    /**
     * Grants permission to create a Custom Entity Type
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-sensitive-data-api.html#aws-glue-api-sensitive-data-api-CreateCustomEntityType
     */
    toCreateCustomEntityType(): this;
    /**
     * Grants permission to create a Data Quality ruleset
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-CreateDataQualityRuleset
     */
    toCreateDataQualityRuleset(): this;
    /**
     * Grants permission to create a database
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-databases.html#aws-glue-api-catalog-databases-CreateDatabase
     */
    toCreateDatabase(): this;
    /**
     * Grants permission to create a development endpoint
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-dev-endpoint.html#aws-glue-api-dev-endpoint-CreateDevEndpoint
     */
    toCreateDevEndpoint(): this;
    /**
     * Grants permission to connect Glue with Identity Center
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/security-trusted-identity-propagation-getting-started.html#security-trusted-identity-propagation-connecting
     */
    toCreateGlueIdentityCenterConfiguration(): this;
    /**
     * Grants permission to the source principal to create an inbound integration for data to be replicated from the source into the target
     *
     * Access Level: Write
     */
    toCreateInboundIntegration(): this;
    /**
     * Grants permission to create an integration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - kms:CreateGrant
     * - kms:DescribeKey
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-integrations.html#aws-glue-api-integrations-CreateIntegration
     */
    toCreateIntegration(): this;
    /**
     * Grants permission to create integration resource property
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-integrations.html#aws-glue-api-integrations-CreateIntegrationResourceProperty
     */
    toCreateIntegrationResourceProperty(): this;
    /**
     * Grants permission to create integration table properties
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-integrations.html#aws-glue-api-integrations-CreateIntegrationTableProperties
     */
    toCreateIntegrationTableProperties(): this;
    /**
     * Grants permission to create a job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVpcIds()
     * - .ifSubnetIds()
     * - .ifSecurityGroupIds()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-CreateJob
     */
    toCreateJob(): this;
    /**
     * Grants permission to create an ML Transform
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-CreateMLTransform
     */
    toCreateMLTransform(): this;
    /**
     * Grants permission to create a partition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-CreatePartition
     */
    toCreatePartition(): this;
    /**
     * Grants permission to create a specified partition index in an existing table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-CreatePartitionIndex
     */
    toCreatePartitionIndex(): this;
    /**
     * Grants permission to create a new schema registry
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-CreateRegistry
     */
    toCreateRegistry(): this;
    /**
     * Grants permission to create a new schema container
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-CreateSchema
     */
    toCreateSchema(): this;
    /**
     * Grants permission to create a script
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-etl-script-generation.html#aws-glue-api-etl-script-generation-CreateScript
     */
    toCreateScript(): this;
    /**
     * Grants permission to create a security configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-CreateSecurityConfiguration
     */
    toCreateSecurityConfiguration(): this;
    /**
     * Grants permission to create an interactive session
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVpcIds()
     * - .ifSubnetIds()
     * - .ifSecurityGroupIds()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-interactive-sessions.html#aws-glue-api-interactive-sessions-CreateSession
     */
    toCreateSession(): this;
    /**
     * Grants permission to create a table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-CreateTable
     */
    toCreateTable(): this;
    /**
     * Grants permission to create a new table optimizer for a specific function. Compaction is the only currently supported optimizer type
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - glue:GetTable
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-table-optimizers.html#aws-glue-api-table-optimizers-CreateTableOptimizer
     */
    toCreateTableOptimizer(): this;
    /**
     * Grants permission to create a trigger
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-CreateTrigger
     */
    toCreateTrigger(): this;
    /**
     * Grants permission to create a usage profile
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-usage-profiles.html#aws-glue-api-usage-profiles-CreateUsageProfile
     */
    toCreateUsageProfile(): this;
    /**
     * Grants permission to create a function definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-functions.html#aws-glue-api-catalog-functions-CreateUserDefinedFunction
     */
    toCreateUserDefinedFunction(): this;
    /**
     * Grants permission to create a workflow
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-CreateWorkflow
     */
    toCreateWorkflow(): this;
    /**
     * Grants permission to delete a blueprint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-DeleteBlueprint
     */
    toDeleteBlueprint(): this;
    /**
     * Grants permission to delete a catalog
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog.html
     */
    toDeleteCatalog(): this;
    /**
     * Grants permission to delete a classifier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-classifiers.html#aws-glue-api-crawler-classifiers-DeleteClassifier
     */
    toDeleteClassifier(): this;
    /**
     * Grants permission to delete the partition column statistics of a column
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-DeleteColumnStatisticsForPartition
     */
    toDeleteColumnStatisticsForPartition(): this;
    /**
     * Grants permission to delete the table statistics of columns
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-DeleteColumnStatisticsForTable
     */
    toDeleteColumnStatisticsForTable(): this;
    /**
     * Grants permission to delete settings for a column statistics task
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-column-statistics.html#aws-glue-api-crawler-column-statistics-DeleteColumnStatisticsTaskSettings
     */
    toDeleteColumnStatisticsTaskSettings(): this;
    /**
     * Grants permission to delete a connection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-DeleteConnection
     */
    toDeleteConnection(): this;
    /**
     * Grants permission to delete a crawler
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-DeleteCrawler
     */
    toDeleteCrawler(): this;
    /**
     * Grants permission to delete a Custom Entity Type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-sensitive-data-api.html#aws-glue-api-sensitive-data-api-DeleteCustomEntityType
     */
    toDeleteCustomEntityType(): this;
    /**
     * Grants permission to delete a Data Quality ruleset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-DeleteDataQualityRuleset
     */
    toDeleteDataQualityRuleset(): this;
    /**
     * Grants permission to delete a database
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-databases.html#aws-glue-api-catalog-databases-DeleteDatabase
     */
    toDeleteDatabase(): this;
    /**
     * Grants permission to delete a development endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-dev-endpoint.html#aws-glue-api-dev-endpoint-DeleteDevEndpoint
     */
    toDeleteDevEndpoint(): this;
    /**
     * Grants permission to disconnect Glue with Identity Center
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/security-trusted-identity-propagation-getting-started.html#security-trusted-identity-propagation-connecting
     */
    toDeleteGlueIdentityCenterConfiguration(): this;
    /**
     * Grants permission to delete an integration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-integrations.html#aws-glue-api-integrations-DeleteIntegration
     */
    toDeleteIntegration(): this;
    /**
     * Grants permission to delete integration table properties
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-integrations.html#aws-glue-api-integrations-DeleteIntegrationTableProperties
     */
    toDeleteIntegrationTableProperties(): this;
    /**
     * Grants permission to delete a job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-DeleteJob
     */
    toDeleteJob(): this;
    /**
     * Grants permission to delete an ML Transform
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-DeleteMLTransform
     */
    toDeleteMLTransform(): this;
    /**
     * Grants permission to delete a partition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-DeletePartition
     */
    toDeletePartition(): this;
    /**
     * Grants permission to delete a specified partition index from an existing table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-DeletePartitionIndex
     */
    toDeletePartitionIndex(): this;
    /**
     * Grants permission to delete a schema registry
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-DeleteRegistry
     */
    toDeleteRegistry(): this;
    /**
     * Grants permission to delete a resource policy
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-DeleteResourcePolicy
     */
    toDeleteResourcePolicy(): this;
    /**
     * Grants permission to delete a schema container
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-DeleteSchema
     */
    toDeleteSchema(): this;
    /**
     * Grants permission to delete a range of schema versions
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-DeleteSchemaVersions
     */
    toDeleteSchemaVersions(): this;
    /**
     * Grants permission to delete a security configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-DeleteSecurityConfiguration
     */
    toDeleteSecurityConfiguration(): this;
    /**
     * Grants permission to delete an interactive session after stopping the session if not already stopped
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-interactive-sessions.html#aws-glue-interactive-sessions-DeleteSession
     */
    toDeleteSession(): this;
    /**
     * Grants permission to delete a table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-DeleteTable
     */
    toDeleteTable(): this;
    /**
     * Grants permission to delete an optimizer and all associated metadata for a table. The optimization will no longer be performed on the table
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - glue:GetTable
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-table-optimizers.html#aws-glue-api-table-optimizers-DeleteTableOptimizer
     */
    toDeleteTableOptimizer(): this;
    /**
     * Grants permission to delete a version of a table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-DeleteTableVersion
     */
    toDeleteTableVersion(): this;
    /**
     * Grants permission to delete a trigger
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-DeleteTrigger
     */
    toDeleteTrigger(): this;
    /**
     * Grants permission to delete a usage profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-usage-profiles.html#aws-glue-api-usage-profiles-DeleteUsageProfile
     */
    toDeleteUsageProfile(): this;
    /**
     * Grants permission to delete a function definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-functions.html#aws-glue-api-catalog-functions-DeleteUserDefinedFunction
     */
    toDeleteUserDefinedFunction(): this;
    /**
     * Grants permission to delete a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-DeleteWorkflow
     */
    toDeleteWorkflow(): this;
    /**
     * Grants permission to terminate Glue Studio Notebook session
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/ug/notebook-getting-started.html#create-notebook-permissions-operations
     */
    toDeregisterDataPreview(): this;
    /**
     * Grants permission to describe connection type in glue studio
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-connections.html#connection-type-permissions-operations
     */
    toDescribeConnectionType(): this;
    /**
     * Grants permission to describe entity in glue studio
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-connections.html#connection-type-permissions-operations
     */
    toDescribeEntity(): this;
    /**
     * Grants permission to list the inbound integrations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-integrations.html#aws-glue-api-integrations-DescribeInboundIntegrations
     */
    toDescribeInboundIntegrations(): this;
    /**
     * Grants permission to describe zero-ETL integrations
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-integrations.html#aws-glue-api-integrations-DescribeIntegrations
     */
    toDescribeIntegrations(): this;
    /**
     * Grants permission to retrieve a blueprint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-GetBlueprint
     */
    toGetBlueprint(): this;
    /**
     * Grants permission to retrieve a blueprint run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-GetBlueprintRun
     */
    toGetBlueprintRun(): this;
    /**
     * Grants permission to retrieve all runs of a blueprint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-GetBlueprintRuns
     */
    toGetBlueprintRuns(): this;
    /**
     * Grants permission to retrieve a catalog
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifEnabledForRedshiftAutoDiscovery()
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog.html
     */
    toGetCatalog(): this;
    /**
     * Grants permission to retrieve the catalog import status
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-migration.html#aws-glue-api-catalog-migration-GetCatalogImportStatus
     */
    toGetCatalogImportStatus(): this;
    /**
     * Grants permission to retrieve all catalogs
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifEnabledForRedshiftAutoDiscovery()
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog.html
     */
    toGetCatalogs(): this;
    /**
     * Grants permission to retrieve a classifier
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-classifiers.html#aws-glue-api-crawler-classifiers-GetClassifier
     */
    toGetClassifier(): this;
    /**
     * Grants permission to list all classifiers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-classifiers.html#aws-glue-api-crawler-classifiers-GetClassifiers
     */
    toGetClassifiers(): this;
    /**
     * Grants permission to retrieve partition statistics of columns
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-GetColumnStatisticsForPartition
     */
    toGetColumnStatisticsForPartition(): this;
    /**
     * Grants permission to retrieve table statistics of columns
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-GetColumnStatisticsForTable
     */
    toGetColumnStatisticsForTable(): this;
    /**
     * Grants permission to retrieve Column Statistics run information for the table based on run-id
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-column-statistics.html#aws-glue-api-crawler-column-statistics-GetColumnStatisticsTaskRun
     */
    toGetColumnStatisticsTaskRun(): this;
    /**
     * Grants permission to retrieve Column Statistics run information for the table based on run-ids
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-column-statistics.html#aws-glue-api-crawler-column-statistics-GetColumnStatisticsTaskRuns
     */
    toGetColumnStatisticsTaskRuns(): this;
    /**
     * Grants permission to retrieve settings for a column statistics task
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-column-statistics.html#aws-glue-api-crawler-column-statistics-GetColumnStatisticsTaskSettings
     */
    toGetColumnStatisticsTaskSettings(): this;
    /**
     * Grants permission to get generated response for a completion request in Glue from AWS Q
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api.html#
     */
    toGetCompletion(): this;
    /**
     * Grants permission to retrieve a connection
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-GetConnection
     */
    toGetConnection(): this;
    /**
     * Grants permission to retrieve a list of connections
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-GetConnections
     */
    toGetConnections(): this;
    /**
     * Grants permission to retrieve a crawler
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-GetCrawler
     */
    toGetCrawler(): this;
    /**
     * Grants permission to retrieve metrics about crawlers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-GetCrawlerMetrics
     */
    toGetCrawlerMetrics(): this;
    /**
     * Grants permission to retrieve all crawlers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-GetCrawlers
     */
    toGetCrawlers(): this;
    /**
     * Grants permission to read a Custom Entity Type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-sensitive-data-api.html#aws-glue-api-sensitive-data-api-GetCustomEntityType
     */
    toGetCustomEntityType(): this;
    /**
     * Grants permission to generate presigned url for accessing spark live UI
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-interactive-sessions.html
     */
    toGetDashboardUrl(): this;
    /**
     * Grants permission to retrieve catalog encryption settings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-GetDataCatalogEncryptionSettings
     */
    toGetDataCatalogEncryptionSettings(): this;
    /**
     * Grants permission to get Data Preview Statement
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/ug/notebook-getting-started.html#create-notebook-permissions-operations
     */
    toGetDataPreviewStatement(): this;
    /**
     * Grants permission to retrieve the training status of the prediction model for a statistic
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-GetDataQualityModel
     */
    toGetDataQualityModel(): this;
    /**
     * Grants permission to retrieve the predictions for a statistic from the latest model
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-GetDataQualityModelResult
     */
    toGetDataQualityModelResult(): this;
    /**
     * Grants permission to retrieve a Data Quality result
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-GetDataQualityResult
     */
    toGetDataQualityResult(): this;
    /**
     * Grants permission to retrieve a Data Quality rule recommendation run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-GetDataQualityRuleRecommendationRun
     */
    toGetDataQualityRuleRecommendationRun(): this;
    /**
     * Grants permission to retrieve a Data Quality ruleset
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-GetDataQualityRuleset
     */
    toGetDataQualityRuleset(): this;
    /**
     * Grants permission to retrieve a Data Quality rule recommendation run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-GetDataQualityRulesetEvaluationRun
     */
    toGetDataQualityRulesetEvaluationRun(): this;
    /**
     * Grants permission to retrieve a database
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-databases.html#aws-glue-api-catalog-databases-GetDatabase
     */
    toGetDatabase(): this;
    /**
     * Grants permission to retrieve all databases
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-databases.html#aws-glue-api-catalog-databases-GetDatabases
     */
    toGetDatabases(): this;
    /**
     * Grants permission to transform a script into a directed acyclic graph (DAG)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-etl-script-generation.html#aws-glue-api-etl-script-generation-GetDataflowGraph
     */
    toGetDataflowGraph(): this;
    /**
     * Grants permission to retrieve a development endpoint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-dev-endpoint.html#aws-glue-api-dev-endpoint-GetDevEndpoint
     */
    toGetDevEndpoint(): this;
    /**
     * Grants permission to retrieve all development endpoints
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-dev-endpoint.html#aws-glue-api-dev-endpoint-GetDevEndpoints
     */
    toGetDevEndpoints(): this;
    /**
     * Grants permission to preview entity records in glue
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-connections.html#connection-type-permissions-operations
     */
    toGetEntityRecords(): this;
    /**
     * Grants permission to get environment details for SparkUI
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/monitor-spark-ui.html
     */
    toGetEnvironment(): this;
    /**
     * Grants permission to get executors for SparkUI
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/monitor-spark-ui.html
     */
    toGetExecutors(): this;
    /**
     * Grants permission to get executor threads for SparkUI
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/monitor-spark-ui.html
     */
    toGetExecutorsThreads(): this;
    /**
     * Transforms a directed acyclic graph (DAG) into code
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-etl-script-generation.html#aws-glue-api-etl-script-generation-GetGeneratedCode
     */
    toGetGeneratedCode(): this;
    /**
     * Grants permission to retrieve the managed Idc application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/security-trusted-identity-propagation-getting-started.html#security-trusted-identity-propagation-connecting
     */
    toGetGlueIdentityCenterConfiguration(): this;
    /**
     * Grants permission to retrieve the integration resource property
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-integrations.html#aws-glue-api-integrations-GetIntegrationResourceProperty
     */
    toGetIntegrationResourceProperty(): this;
    /**
     * Grants permission to retrieve the integration table properties
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-integrations.html#aws-glue-api-integrations-GetIntegrationTableProperties
     */
    toGetIntegrationTableProperties(): this;
    /**
     * Grants permission to retrieve a job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-GetJob
     */
    toGetJob(): this;
    /**
     * Grants permission to retrieve a job bookmark
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-job-GetJobBookmark
     */
    toGetJobBookmark(): this;
    /**
     * Grants permission to retrieve a job run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-runs-GetJobRun
     */
    toGetJobRun(): this;
    /**
     * Grants permission to retrieve all job runs of a job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-runs-GetJobRuns
     */
    toGetJobRuns(): this;
    /**
     * Grants permission to retrieve an upgrade analysis for a job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-upgrade-analysis.html#aws-glue-api-upgrade-analysis-GetJobUpgradeAnalysis
     */
    toGetJobUpgradeAnalysis(): this;
    /**
     * Grants permission to retrieve all current jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-GetJobs
     */
    toGetJobs(): this;
    /**
     * Grants permission to get log parsing status for SparkUI
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/monitor-spark-ui.html
     */
    toGetLogParsingStatus(): this;
    /**
     * Grants permission to retrieve an ML Task Run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-GetMLTaskRun
     */
    toGetMLTaskRun(): this;
    /**
     * Grants permission to retrieve all ML Task Runs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-GetMLTaskRuns
     */
    toGetMLTaskRuns(): this;
    /**
     * Grants permission to retrieve an ML Transform
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-GetMLTransform
     */
    toGetMLTransform(): this;
    /**
     * Grants permission to retrieve all ML Transforms
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-GetMLTransforms
     */
    toGetMLTransforms(): this;
    /**
     * Grants permission to create a mapping
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-etl-script-generation.html#aws-glue-api-etl-script-generation-GetMapping
     */
    toGetMapping(): this;
    /**
     * Grants permission to retrieve Glue Studio Notebooks session status
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/ug/notebook-getting-started.html#create-notebook-permissions-operations
     */
    toGetNotebookInstanceStatus(): this;
    /**
     * Grants permission to retrieve a partition
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-GetPartition
     */
    toGetPartition(): this;
    /**
     * Grants permission to retrieve partition indexes for a table
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-GetPartitionIndexes
     */
    toGetPartitionIndexes(): this;
    /**
     * Grants permission to retrieve the partitions of a table
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-GetPartitions
     */
    toGetPartitions(): this;
    /**
     * Grants permission to retrieve a mapping for a script
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-etl-script-generation.html#aws-glue-api-etl-script-generation-GetPlan
     */
    toGetPlan(): this;
    /**
     * Grants permission to get queries for SparkUI
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/monitor-spark-ui.html
     */
    toGetQueries(): this;
    /**
     * Grants permission to get a specific query for SparkUI
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/monitor-spark-ui.html
     */
    toGetQuery(): this;
    /**
     * Grants permission to get the result of a Data Preparation Recipe statement
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/ug/setting-up.html#getting-started-min-privs
     */
    toGetRecipeAction(): this;
    /**
     * Grants permission to retrieve a schema registry
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-GetRegistry
     */
    toGetRegistry(): this;
    /**
     * Grants permission to retrieve resource policies
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-GetResourcePolicies
     */
    toGetResourcePolicies(): this;
    /**
     * Grants permission to retrieve a resource policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-GetResourcePolicy
     */
    toGetResourcePolicy(): this;
    /**
     * Grants permission to retrieve a schema container
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-GetSchema
     */
    toGetSchema(): this;
    /**
     * Grants permission to retrieve a schema version based on schema definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-GetSchemaByDefinition
     */
    toGetSchemaByDefinition(): this;
    /**
     * Grants permission to retrieve a schema version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-GetSchemaVersion
     */
    toGetSchemaVersion(): this;
    /**
     * Grants permission to compare two schema versions in schema registry
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-GetSchemaVersionsDiff
     */
    toGetSchemaVersionsDiff(): this;
    /**
     * Grants permission to retrieve a security configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-GetSecurityConfiguration
     */
    toGetSecurityConfiguration(): this;
    /**
     * Grants permission to retrieve one or more security configurations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-GetSecurityConfigurations
     */
    toGetSecurityConfigurations(): this;
    /**
     * Grants permission to retrieve an interactive session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-interactive-sessions.html#aws-glue-interactive-sessions-GetSession
     */
    toGetSession(): this;
    /**
     * Grants permission to get a stage for SparkUI
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/monitor-spark-ui.html
     */
    toGetStage(): this;
    /**
     * Grants permission to get a stage attempt for SparkUI
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/monitor-spark-ui.html
     */
    toGetStageAttempt(): this;
    /**
     * Grants permission to get the task list for a stage attempt for SparkUI
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/monitor-spark-ui.html
     */
    toGetStageAttemptTaskList(): this;
    /**
     * Grants permission to get the task summary for a stage attempt for SparkUI
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/monitor-spark-ui.html
     */
    toGetStageAttemptTaskSummary(): this;
    /**
     * Grants permission to get stage files for SparkUI
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/monitor-spark-ui.html
     */
    toGetStageFiles(): this;
    /**
     * Grants permission to get stages for SparkUI
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/monitor-spark-ui.html
     */
    toGetStages(): this;
    /**
     * Grants permission to retrieve result and information about a statement in an interactive session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-interactive-sessions.html#aws-glue-interactive-sessions-GetStatement
     */
    toGetStatement(): this;
    /**
     * Grants permission to get storage details for SparkUI
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/monitor-spark-ui.html
     */
    toGetStorage(): this;
    /**
     * Grants permission to get storage unit details for SparkUI
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/monitor-spark-ui.html
     */
    toGetStorageUnit(): this;
    /**
     * Grants permission to retrieve a table
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-GetTable
     */
    toGetTable(): this;
    /**
     * Grants permission to return the configuration of all optimizers associated with a specified table
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - glue:GetTable
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-table-optimizers.html#aws-glue-api-table-optimizers-GetTableOptimizer
     */
    toGetTableOptimizer(): this;
    /**
     * Grants permission to retrieve a version of a table
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-GetTableVersion
     */
    toGetTableVersion(): this;
    /**
     * Grants permission to retrieve a list of versions of a table
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-GetTableVersions
     */
    toGetTableVersions(): this;
    /**
     * Grants permission to retrieve the tables in a database
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-GetTables
     */
    toGetTables(): this;
    /**
     * Grants permission to retrieve all tags associated with a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-tags.html#aws-glue-api-tags-UntagResource
     */
    toGetTags(): this;
    /**
     * Grants permission to retrieve a trigger
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-GetTrigger
     */
    toGetTrigger(): this;
    /**
     * Grants permission to retrieve the triggers associated with a job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-GetTriggers
     */
    toGetTriggers(): this;
    /**
     * Grants permission to retrieve a usage profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-usage-profiles.html#aws-glue-api-usage-profiles-GetUsageProfile
     */
    toGetUsageProfile(): this;
    /**
     * Grants permission to retrieve a function definition
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-functions.html#aws-glue-api-catalog-functions-GetUserDefinedFunction
     */
    toGetUserDefinedFunction(): this;
    /**
     * Grants permission to retrieve multiple function definitions
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-functions.html#aws-glue-api-catalog-functions-GetUserDefinedFunctions
     */
    toGetUserDefinedFunctions(): this;
    /**
     * Grants permission to retrieve a workflow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-GetWorkflow
     */
    toGetWorkflow(): this;
    /**
     * Grants permission to retrieve a workflow run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-GetWorkflowRun
     */
    toGetWorkflowRun(): this;
    /**
     * Grants permission to retrieve workflow run properties
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-GetWorkflowRunProperties
     */
    toGetWorkflowRunProperties(): this;
    /**
     * Grants permission to retrieve all runs of a workflow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-GetWorkflowRuns
     */
    toGetWorkflowRuns(): this;
    /**
     * Grants permission to access Glue Studio Notebooks
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/ug/notebook-getting-started.html#create-notebook-permissions-operations
     */
    toGlueNotebookAuthorize(): this;
    /**
     * Grants permission to refresh Glue Studio Notebooks credentials
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/ug/notebook-getting-started.html#create-notebook-permissions-operations
     */
    toGlueNotebookRefreshCredentials(): this;
    /**
     * Grants permission to import an Athena data catalog into AWS Glue
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-migration.html#aws-glue-api-catalog-migration-ImportCatalogToGlue
     */
    toImportCatalogToGlue(): this;
    /**
     * Grants permission to retrieve all blueprints
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-ListBlueprints
     */
    toListBlueprints(): this;
    /**
     * Grants permission to list all Column Statistics run-ids that have been executed for the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-column-statistics.html#aws-glue-api-crawler-column-statistics-ListColumnStatisticsTaskRuns
     */
    toListColumnStatisticsTaskRuns(): this;
    /**
     * Grants permission to list connection types in glue studio
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-connections.html#connection-type-permissions-operations
     */
    toListConnectionTypes(): this;
    /**
     * Grants permission to retrieve all crawlers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-ListCrawlers
     */
    toListCrawlers(): this;
    /**
     * Grants permission to retrieve crawl run history for a crawler
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-ListCrawls
     */
    toListCrawls(): this;
    /**
     * Grants permission to retrieve all Custom Entity Types
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-sensitive-data-api.html#aws-glue-api-sensitive-data-api-ListGetCustomEntityTypes
     */
    toListCustomEntityTypes(): this;
    /**
     * Grants permission to retrieve all Data Quality results
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-ListDataQualityResults
     */
    toListDataQualityResults(): this;
    /**
     * Grants permission to retrieve all Data Quality rule recommendation runs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-ListDataQualityRuleRecommendationRuns
     */
    toListDataQualityRuleRecommendationRuns(): this;
    /**
     * Grants permission to retrieve all Data Quality rule recommendation runs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-ListDataQualityRulesetEvaluationRuns
     */
    toListDataQualityRulesetEvaluationRuns(): this;
    /**
     * Grants permission to retrieve a list of Data Quality rulesets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-ListDataQualityRulesets
     */
    toListDataQualityRulesets(): this;
    /**
     * Grants permission to retrieve all development endpoints
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-dev-endpoint.html#aws-glue-api-dev-endpoint-ListDevEndpoints
     */
    toListDevEndpoints(): this;
    /**
     * Grants permission to list entities in glue studio
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-connections.html#connection-type-permissions-operations
     */
    toListEntities(): this;
    /**
     * Grants permission to list upgrade analyses for a job
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-upgrade-analysis.html#aws-glue-api-upgrade-analysis-ListJobUpgradeAnalyses
     */
    toListJobUpgradeAnalyses(): this;
    /**
     * Grants permission to retrieve all current jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-ListJobs
     */
    toListJobs(): this;
    /**
     * Grants permission to retrieve all ML Transforms
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-ListMLTransforms
     */
    toListMLTransforms(): this;
    /**
     * Grants permission to retrieve a list of schema registries
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-ListRegistries
     */
    toListRegistries(): this;
    /**
     * Grants permission to retrieve a list of schema versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-ListSchemaVersions
     */
    toListSchemaVersions(): this;
    /**
     * Grants permission to retrieve a list of schema containers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-ListSchemas
     */
    toListSchemas(): this;
    /**
     * Grants permission to retrieve a list of interactive session
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-interactive-sessions.html#aws-glue-interactive-sessions-ListSessions
     */
    toListSessions(): this;
    /**
     * Grants permission to retrieve a list of statements in an interactive session
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-interactive-sessions.html#aws-glue-interactive-sessions-ListStatements
     */
    toListStatements(): this;
    /**
     * Grants permission to list the history of previous optimizer runs for a specific table
     *
     * Access Level: List
     *
     * Dependent actions:
     * - glue:GetTable
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-table-optimizers.html#aws-glue-api-table-optimizers-ListTableOptimizerRuns
     */
    toListTableOptimizerRuns(): this;
    /**
     * Grants permission to retrieve all triggers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-ListTriggers
     */
    toListTriggers(): this;
    /**
     * Grants permission to retrieve a list of usage profiles
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-usage-profiles.html#aws-glue-api-usage-profiles-ListUsageProfiles
     */
    toListUsageProfiles(): this;
    /**
     * Grants permission to retrieve all workflows
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-ListWorkflows
     */
    toListWorkflows(): this;
    /**
     * Grants permission to modify a zero-ETL integration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-integrations.html#aws-glue-api-integrations-ModifyIntegration
     */
    toModifyIntegration(): this;
    /**
     * Grants permission to notify an event to the event-driven workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/starting-workflow-eventbridge.html
     */
    toNotifyEvent(): this;
    /**
     * Grants permission to pass glue connection name in input for APIs that require them
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-CreateConnection
     */
    toPassConnection(): this;
    /**
     * Grants permission to publish Data Quality results
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html
     */
    toPublishDataQuality(): this;
    /**
     * Grants permission to update catalog encryption settings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-PutDataCatalogEncryptionSettings
     */
    toPutDataCatalogEncryptionSettings(): this;
    /**
     * Grants permission to annotate all datapoints for a profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-PutDataQualityProfileAnnotation
     */
    toPutDataQualityProfileAnnotation(): this;
    /**
     * Grants permission to annotate datapoints over time for a specific data quality statistic
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-BatchPutDataQualityStatisticAnnotation
     */
    toPutDataQualityStatisticAnnotation(): this;
    /**
     * Grants permission to update a resource policy
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-security.html#aws-glue-api-jobs-security-PutResourcePolicy
     */
    toPutResourcePolicy(): this;
    /**
     * Grants permission to add metadata to schema version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-PutSchemaVersionMetadata
     */
    toPutSchemaVersionMetadata(): this;
    /**
     * Grants permission to update workflow run properties
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-PutWorkflowRunProperties
     */
    toPutWorkflowRunProperties(): this;
    /**
     * Grants permission to fetch metadata for a schema version
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-QuerySchemaVersionMetadata
     */
    toQuerySchemaVersionMetadata(): this;
    /**
     * Grants permission to refresh the oauth2 tokens for connection during job execution
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-connections.html#connection-type-permissions-operations
     */
    toRefreshOAuth2Tokens(): this;
    /**
     * Grants permission to create a new schema version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-RegisterSchemaVersion
     */
    toRegisterSchemaVersion(): this;
    /**
     * Grants permission to remove metadata from schema version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-RemoveSchemaVersionMetadata
     */
    toRemoveSchemaVersionMetadata(): this;
    /**
     * Grants permission to request log parsing for SparkUI
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/monitor-spark-ui.html
     */
    toRequestLogParsing(): this;
    /**
     * Grants permission to reset a job bookmark
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-runs-ResetJobBookmark
     */
    toResetJobBookmark(): this;
    /**
     * Grants permission to resume a workflow run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-ResumeWorkflowRun
     */
    toResumeWorkflowRun(): this;
    /**
     * Grants permission to run Data Preview Statement
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/ug/notebook-getting-started.html#create-notebook-permissions-operations
     */
    toRunDataPreviewStatement(): this;
    /**
     * Grants permission to run a code or statement in an interactive session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-interactive-sessions.html#aws-glue-interactive-sessions-RunStatement
     */
    toRunStatement(): this;
    /**
     * Grants permission to retrieve the tables in the catalog
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-SearchTables
     */
    toSearchTables(): this;
    /**
     * Grants permission to provide feedback about a glue completion experience in AWS Q
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api.html#
     */
    toSendFeedback(): this;
    /**
     * Grants permission to execute a Data Preparation Recipe statement in data preview
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/ug/setting-up.html#getting-started-min-privs
     */
    toSendRecipeAction(): this;
    /**
     * Grants permission to start running a blueprint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-StartBlueprintRun
     */
    toStartBlueprintRun(): this;
    /**
     * Grants permission to start a run for generating Column Statistics for the table
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - glue:GetSecurityConfiguration
     * - glue:GetTable
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-column-statistics.html#aws-glue-api-crawler-column-statistics-StartColumnStatisticsTaskRun
     */
    toStartColumnStatisticsTaskRun(): this;
    /**
     * Grants permission to start a column statistics task run schedule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-column-statistics.html#aws-glue-api-crawler-column-statistics-StartColumnStatisticsTaskRunSchedule
     */
    toStartColumnStatisticsTaskRunSchedule(): this;
    /**
     * Grants permission to create a completion request in Glue for AWS Q experience
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api.html#
     */
    toStartCompletion(): this;
    /**
     * Grants permission to start a crawler
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-StartCrawler
     */
    toStartCrawler(): this;
    /**
     * Grants permission to change the schedule state of a crawler to SCHEDULED
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-scheduler.html#aws-glue-api-crawler-scheduler-StartCrawlerSchedule
     */
    toStartCrawlerSchedule(): this;
    /**
     * Grants permission to start a Data Quality rule recommendation run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-StartDataQualityRuleRecommendationRun
     */
    toStartDataQualityRuleRecommendationRun(): this;
    /**
     * Grants permission to start a Data Quality rule recommendation run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-StartDataQualityRulesetEvaluationRun
     */
    toStartDataQualityRulesetEvaluationRun(): this;
    /**
     * Grants permission to start an Export Labels ML Task Run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-StartExportLabelsTaskRun
     */
    toStartExportLabelsTaskRun(): this;
    /**
     * Grants permission to start an Import Labels ML Task Run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-StartImportLabelsTaskRun
     */
    toStartImportLabelsTaskRun(): this;
    /**
     * Grants permission to start running a job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-runs-StartJobRun
     */
    toStartJobRun(): this;
    /**
     * Grants permission to start running upgrade analysis for a job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-upgrade-analysis.html#aws-glue-api-upgrade-analysis-StartJobUpgradeAnalysis
     */
    toStartJobUpgradeAnalysis(): this;
    /**
     * Grants permission to start an Evaluation ML Task Run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-StartMLEvaluationTaskRun
     */
    toStartMLEvaluationTaskRun(): this;
    /**
     * Grants permission to start a Labeling Set Generation ML Task Run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-StartMLLabelingSetGenerationTaskRun
     */
    toStartMLLabelingSetGenerationTaskRun(): this;
    /**
     * Grants permission to start Glue Studio Notebooks
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/ug/notebook-getting-started.html#create-notebook-permissions-operations
     */
    toStartNotebook(): this;
    /**
     * Grants permission to start a trigger
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-StartTrigger
     */
    toStartTrigger(): this;
    /**
     * Grants permission to start running a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-StartWorkflowRun
     */
    toStartWorkflowRun(): this;
    /**
     * Grants permission to stop execution for Column Statistics run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-column-statistics.html#aws-glue-api-crawler-column-statistics-StopColumnStatisticsTaskRun
     */
    toStopColumnStatisticsTaskRun(): this;
    /**
     * Grants permission to stop a column statistics task run schedule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-column-statistics.html#aws-glue-api-crawler-column-statistics-StopColumnStatisticsTaskRunSchedule
     */
    toStopColumnStatisticsTaskRunSchedule(): this;
    /**
     * Grants permission to stop a running crawler
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-StopCrawler
     */
    toStopCrawler(): this;
    /**
     * Grants permission to set the schedule state of a crawler to NOT_SCHEDULED
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-scheduler.html#aws-glue-api-crawler-scheduler-StopCrawlerSchedule
     */
    toStopCrawlerSchedule(): this;
    /**
     * Grants permission to stop an on-going upgrade analysis for a job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-upgrade-analysis.html#aws-glue-api-upgrade-analysis-StopJobUpgradeAnalysis
     */
    toStopJobUpgradeAnalysis(): this;
    /**
     * Grants permission to stop an interactive session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-interactive-sessions.html#aws-glue-interactive-sessions-StopSession
     */
    toStopSession(): this;
    /**
     * Grants permission to stop a trigger
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-StopTrigger
     */
    toStopTrigger(): this;
    /**
     * Grants permission to stop a workflow run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-StopWorkflowRun
     */
    toStopWorkflowRun(): this;
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-tags.html#aws-glue-api-tags-TagResource
     */
    toTagResource(): this;
    /**
     * Grants permission to terminate Glue Studio Notebooks
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/ug/notebook-getting-started.html#create-notebook-permissions-operations
     */
    toTerminateNotebook(): this;
    /**
     * Grants permission to test connection in Glue Studio
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/dg/console-test-connections.html
     */
    toTestConnection(): this;
    /**
     * Grants permission to remove tags associated with a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-tags.html#aws-glue-api-tags-UntagResource
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a blueprint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-UpdateBlueprint
     */
    toUpdateBlueprint(): this;
    /**
     * Grants permission to update a catalog
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog.html
     */
    toUpdateCatalog(): this;
    /**
     * Grants permission to update a classifier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-classifiers.html#aws-glue-api-crawler-classifiers-UpdateClassifier
     */
    toUpdateClassifier(): this;
    /**
     * Grants permission to update partition statistics of columns
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-UpdateColumnStatisticsForPartition
     */
    toUpdateColumnStatisticsForPartition(): this;
    /**
     * Grants permission to update table statistics of columns
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-UpdateColumnStatisticsForTable
     */
    toUpdateColumnStatisticsForTable(): this;
    /**
     * Grants permission to update settings for a column statistics task
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-column-statistics.html#aws-glue-api-crawler-column-statistics-UpdateColumnStatisticsTaskSettings
     */
    toUpdateColumnStatisticsTaskSettings(): this;
    /**
     * Grants permission to update a connection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-UpdateConnection
     */
    toUpdateConnection(): this;
    /**
     * Grants permission to update a crawler
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-UpdateCrawler
     */
    toUpdateCrawler(): this;
    /**
     * Grants permission to update the schedule of a crawler
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-scheduler.html#aws-glue-api-crawler-scheduler-UpdateCrawlerSchedule
     */
    toUpdateCrawlerSchedule(): this;
    /**
     * Grants permission to update a Data Quality ruleset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-data-quality-api.html#aws-glue-api-data-quality-api-UpdateDataQualityRuleset
     */
    toUpdateDataQualityRuleset(): this;
    /**
     * Grants permission to update a database
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-databases.html#aws-glue-api-catalog-databases-UpdateDatabase
     */
    toUpdateDatabase(): this;
    /**
     * Grants permission to update a development endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-dev-endpoint.html#aws-glue-api-dev-endpoint-UpdateDevEndpoint
     */
    toUpdateDevEndpoint(): this;
    /**
     * Grants permission to update the managed Idc application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/security-trusted-identity-propagation-getting-started.html#security-trusted-identity-propagation-connecting
     */
    toUpdateGlueIdentityCenterConfiguration(): this;
    /**
     * Grants permission to update the integration resource property
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-integrations.html#aws-glue-api-integrations-UpdateIntegrationResourceProperty
     */
    toUpdateIntegrationResourceProperty(): this;
    /**
     * Grants permission to update the integration table properties
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-integrations.html#aws-glue-api-integrations-UpdateIntegrationTableProperties
     */
    toUpdateIntegrationTableProperties(): this;
    /**
     * Grants permission to update a job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifVpcIds()
     * - .ifSubnetIds()
     * - .ifSecurityGroupIds()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-UpdateJob
     */
    toUpdateJob(): this;
    /**
     * Grants permission to update a job from source control provider
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-UpdateJobFromSourceControl
     */
    toUpdateJobFromSourceControl(): this;
    /**
     * Grants permission to update an ML Transform
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html#aws-glue-api-machine-learning-api-UpdateMLTransform
     */
    toUpdateMLTransform(): this;
    /**
     * Grants permission to update a partition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-partitions.html#aws-glue-api-catalog-partitions-UpdatePartition
     */
    toUpdatePartition(): this;
    /**
     * Grants permission to update a schema registry
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-UpdateRegistry
     */
    toUpdateRegistry(): this;
    /**
     * Grants permission to update a schema container
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-schema-registry-api.html#aws-glue-api-schema-registry-api-UpdateSchema
     */
    toUpdateSchema(): this;
    /**
     * Grants permission to update source control provider from a job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html#aws-glue-api-jobs-job-UpdateSourceControlFromJob
     */
    toUpdateSourceControlFromJob(): this;
    /**
     * Grants permission to update a table
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-UpdateTable
     */
    toUpdateTable(): this;
    /**
     * Grants permission to update the configuration for an existing table optimizer
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - glue:GetTable
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-table-optimizers.html#aws-glue-api-table-optimizers-UpdateTableOptimizer
     */
    toUpdateTableOptimizer(): this;
    /**
     * Grants permission to update a trigger
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-trigger.html#aws-glue-api-jobs-trigger-UpdateTrigger
     */
    toUpdateTrigger(): this;
    /**
     * Grants permission to update a usage profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-usage-profiles.html#aws-glue-api-usage-profiles-UpdateUsageProfile
     */
    toUpdateUsageProfile(): this;
    /**
     * Grants permission to update a function definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLakeFormationPermissions()
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-functions.html#aws-glue-api-catalog-functions-UpdateUserDefinedFunction
     */
    toUpdateUserDefinedFunction(): this;
    /**
     * Grants permission to update a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-workflow.html#aws-glue-api-workflow-UpdateWorkflow
     */
    toUpdateWorkflow(): this;
    /**
     * Grants permission to upgrade a job to the latest version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-upgrade-analysis.html#aws-glue-api-upgrade-analysis-UpgradeJob
     */
    toUpgradeJob(): this;
    /**
     * Grants permission to use Glue Studio and access its internal APIs
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/glue/latest/ug/setting-up.html#getting-started-min-privs
     */
    toUseGlueStudio(): this;
    /**
     * Grants permission to use an ML Transform from within a Glue ETL Script
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-machine-learning-api.html
     */
    toUseMLTransforms(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type rootcatalog to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onRootcatalog(account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type catalog to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param catalogName - Identifier for the catalogName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCatalog(catalogName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type database to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param databaseName - Identifier for the databaseName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDatabase(databaseName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type table to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param databaseName - Identifier for the databaseName.
     * @param tableName - Identifier for the tableName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onTable(databaseName: string, tableName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type tableversion to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param databaseName - Identifier for the databaseName.
     * @param tableName - Identifier for the tableName.
     * @param tableVersionName - Identifier for the tableVersionName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onTableversion(databaseName: string, tableName: string, tableVersionName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type connection to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param connectionName - Identifier for the connectionName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConnection(connectionName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type userdefinedfunction to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param databaseName - Identifier for the databaseName.
     * @param userDefinedFunctionName - Identifier for the userDefinedFunctionName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onUserdefinedfunction(databaseName: string, userDefinedFunctionName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type devendpoint to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param devEndpointName - Identifier for the devEndpointName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDevendpoint(devEndpointName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type job to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param jobName - Identifier for the jobName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onJob(jobName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type trigger to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param triggerName - Identifier for the triggerName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTrigger(triggerName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type crawler to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param crawlerName - Identifier for the crawlerName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCrawler(crawlerName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type workflow to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param workflowName - Identifier for the workflowName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWorkflow(workflowName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type blueprint to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param blueprintName - Identifier for the blueprintName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onBlueprint(blueprintName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type mlTransform to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param transformId - Identifier for the transformId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMlTransform(transformId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type registry to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param registryName - Identifier for the registryName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRegistry(registryName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type schema to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param schemaName - Identifier for the schemaName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSchema(schemaName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type session to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param sessionId - Identifier for the sessionId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSession(sessionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type usageProfile to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param usageProfileId - Identifier for the usageProfileId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onUsageProfile(usageProfileId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type dataQualityRuleset to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param rulesetName - Identifier for the rulesetName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDataQualityRuleset(rulesetName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type customEntityType to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param customEntityTypeId - Identifier for the customEntityTypeId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCustomEntityType(customEntityTypeId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type completion to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param completionId - Identifier for the completionId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCompletion(completionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type integration to the statement
     *
     * https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html
     *
     * @param integrationId - Identifier for the integrationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onIntegration(integrationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the presence of tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateBlueprint()
     * - .toCreateConnection()
     * - .toCreateCrawler()
     * - .toCreateCustomEntityType()
     * - .toCreateDataQualityRuleset()
     * - .toCreateDevEndpoint()
     * - .toCreateIntegration()
     * - .toCreateJob()
     * - .toCreateMLTransform()
     * - .toCreateRegistry()
     * - .toCreateSchema()
     * - .toCreateSession()
     * - .toCreateTrigger()
     * - .toCreateUsageProfile()
     * - .toCreateWorkflow()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toDeleteIntegration()
     * - .toDescribeIntegrations()
     * - .toModifyIntegration()
     *
     * Applies to resource types:
     * - connection
     * - devendpoint
     * - job
     * - trigger
     * - crawler
     * - workflow
     * - blueprint
     * - mlTransform
     * - registry
     * - schema
     * - session
     * - usageProfile
     * - dataQualityRuleset
     * - customEntityType
     * - integration
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the presence of tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateBlueprint()
     * - .toCreateConnection()
     * - .toCreateCrawler()
     * - .toCreateCustomEntityType()
     * - .toCreateDataQualityRuleset()
     * - .toCreateDevEndpoint()
     * - .toCreateIntegration()
     * - .toCreateJob()
     * - .toCreateMLTransform()
     * - .toCreateRegistry()
     * - .toCreateSchema()
     * - .toCreateSession()
     * - .toCreateTrigger()
     * - .toCreateUsageProfile()
     * - .toCreateWorkflow()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the service from which the credentials of the request is issued
     *
     * https://docs.aws.amazon.com/glue/latest/dg/using-identity-based-policies.html#glue-identity-based-policy-condition-keys
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCredentialIssuingService(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the presence of the key configured for role's identity-based policy
     *
     * https://docs.aws.amazon.com/glue/latest/dg/using-identity-based-policies.html#glue-identity-based-policy-condition-keys
     *
     * Applies to actions:
     * - .toGetCatalog()
     * - .toGetCatalogs()
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifEnabledForRedshiftAutoDiscovery(value?: boolean): this;
    /**
     * Filters access by whether Lake Formation permission checks will be performed for a given caller and the Glue resource
     *
     * https://docs.aws.amazon.com/glue/latest/dg/using-identity-based-policies.html#glue-identity-based-policy-condition-keys
     *
     * Applies to actions:
     * - .toBatchCreatePartition()
     * - .toBatchDeleteConnection()
     * - .toBatchDeletePartition()
     * - .toBatchDeleteTable()
     * - .toBatchDeleteTableVersion()
     * - .toBatchGetPartition()
     * - .toBatchUpdatePartition()
     * - .toCreateCatalog()
     * - .toCreateConnection()
     * - .toCreateDatabase()
     * - .toCreatePartition()
     * - .toCreatePartitionIndex()
     * - .toCreateTable()
     * - .toCreateUserDefinedFunction()
     * - .toDeleteCatalog()
     * - .toDeleteColumnStatisticsForPartition()
     * - .toDeleteColumnStatisticsForTable()
     * - .toDeleteConnection()
     * - .toDeleteDatabase()
     * - .toDeletePartition()
     * - .toDeletePartitionIndex()
     * - .toDeleteTable()
     * - .toDeleteTableVersion()
     * - .toDeleteUserDefinedFunction()
     * - .toGetCatalog()
     * - .toGetCatalogImportStatus()
     * - .toGetCatalogs()
     * - .toGetColumnStatisticsForPartition()
     * - .toGetColumnStatisticsForTable()
     * - .toGetConnection()
     * - .toGetConnections()
     * - .toGetDatabase()
     * - .toGetDatabases()
     * - .toGetPartition()
     * - .toGetPartitionIndexes()
     * - .toGetPartitions()
     * - .toGetTable()
     * - .toGetTableVersion()
     * - .toGetTableVersions()
     * - .toGetTables()
     * - .toGetUserDefinedFunction()
     * - .toGetUserDefinedFunctions()
     * - .toImportCatalogToGlue()
     * - .toSearchTables()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateCatalog()
     * - .toUpdateColumnStatisticsForPartition()
     * - .toUpdateColumnStatisticsForTable()
     * - .toUpdateConnection()
     * - .toUpdateDatabase()
     * - .toUpdatePartition()
     * - .toUpdateTable()
     * - .toUpdateUserDefinedFunction()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifLakeFormationPermissions(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the service from which the credentials of the request is obtained by assuming the customer role
     *
     * https://docs.aws.amazon.com/glue/latest/dg/using-identity-based-policies.html#glue-identity-based-policy-condition-keys
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRoleAssumedBy(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of security groups configured for the Glue job
     *
     * https://docs.aws.amazon.com/glue/latest/dg/using-identity-based-policies.html#glue-identity-based-policy-condition-keys
     *
     * Applies to actions:
     * - .toCreateJob()
     * - .toCreateSession()
     * - .toUpdateJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSecurityGroupIds(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of subnets configured for the Glue job
     *
     * https://docs.aws.amazon.com/glue/latest/dg/using-identity-based-policies.html#glue-identity-based-policy-condition-keys
     *
     * Applies to actions:
     * - .toCreateJob()
     * - .toCreateSession()
     * - .toUpdateJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSubnetIds(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of the VPC configured for the Glue job
     *
     * https://docs.aws.amazon.com/glue/latest/dg/using-identity-based-policies.html#glue-identity-based-policy-condition-keys
     *
     * Applies to actions:
     * - .toCreateJob()
     * - .toCreateSession()
     * - .toUpdateJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpcIds(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [glue](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsglue.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
