"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Groundtruthlabeling = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [groundtruthlabeling](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazongroundtruthlabeling.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Groundtruthlabeling extends shared_1.PolicyStatement {
    /**
     * Grants permission to associate a patch file with the manifest file to update the manifest file
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toAssociatePatchToManifestJob() {
        return this.to('AssociatePatchToManifestJob');
    }
    /**
     * Grants permission to create a GT+ Batch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toCreateBatch() {
        return this.to('CreateBatch');
    }
    /**
     * Grants permission to create intake form
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toCreateIntakeForm() {
        return this.to('CreateIntakeForm');
    }
    /**
     * Grants permission to create a GT+ Project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toCreateProject() {
        return this.to('CreateProject');
    }
    /**
     * Grants permission to create a GT+ Workflow Definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toCreateWorkflowDefinition() {
        return this.to('CreateWorkflowDefinition');
    }
    /**
     * Grants permission to get status of GroundTruthLabeling Jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toDescribeConsoleJob() {
        return this.to('DescribeConsoleJob');
    }
    /**
     * Grants permission to generate LiDAR Preview Task
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toGenerateLIDARPreviewTaskConfigJob() {
        return this.to('GenerateLIDARPreviewTaskConfigJob');
    }
    /**
     * Grants permission to get a GT+ Batch
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toGetBatch() {
        return this.to('GetBatch');
    }
    /**
     * Grants permission to get a intake forms
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toGetIntakeFormStatus() {
        return this.to('GetIntakeFormStatus');
    }
    /**
     * Grants permission to list a GT+ Batchs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toListBatches() {
        return this.to('ListBatches');
    }
    /**
     * Grants permission to list dataset objects in a manifest file
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toListDatasetObjects() {
        return this.to('ListDatasetObjects');
    }
    /**
     * Grants permission to list a GT+ Projects
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toListProjects() {
        return this.to('ListProjects');
    }
    /**
     * Grants permission to filter records from a manifest file using S3 select. Get sample entries based on random sampling
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-data-filtering
     */
    toRunFilterOrSampleDatasetJob() {
        return this.to('RunFilterOrSampleDatasetJob');
    }
    /**
     * Grants permission to list a S3 prefix and create manifest files from objects in that location
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toRunGenerateManifestByCrawlingJob() {
        return this.to('RunGenerateManifestByCrawlingJob');
    }
    /**
     * Grants permission to generate metrics from objects in manifest
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toRunGenerateManifestMetricsJob() {
        return this.to('RunGenerateManifestMetricsJob');
    }
    /**
     * Grants permission to update a GT+ Batch
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toUpdateBatch() {
        return this.to('UpdateBatch');
    }
    /**
     * Statement provider for service [groundtruthlabeling](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazongroundtruthlabeling.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'groundtruthlabeling';
        this.accessLevelList = {
            Write: [
                'AssociatePatchToManifestJob',
                'CreateBatch',
                'CreateIntakeForm',
                'CreateProject',
                'CreateWorkflowDefinition',
                'GenerateLIDARPreviewTaskConfigJob',
                'RunFilterOrSampleDatasetJob',
                'RunGenerateManifestByCrawlingJob',
                'RunGenerateManifestMetricsJob',
                'UpdateBatch'
            ],
            Read: [
                'DescribeConsoleJob',
                'GetBatch',
                'GetIntakeFormStatus',
                'ListBatches',
                'ListDatasetObjects',
                'ListProjects'
            ]
        };
    }
}
exports.Groundtruthlabeling = Groundtruthlabeling;
//# sourceMappingURL=data:application/json;base64,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