import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [sso-oauth](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiamidentitycenteroidcservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class SsoOauth extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create and return OAuth 2.0 access tokens and refresh tokens for authorized client applications. These tokens might contain defined scopes that specify permissions such as `read:profile` or `write:data`
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kms:Decrypt
     *
     * https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/API_CreateTokenWithIAM.html
     */
    toCreateTokenWithIAM(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type Application to the statement
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/get-started-enable-identity-center.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param applicationId - Identifier for the applicationId.
     * @param accountId - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onApplication(instanceId: string, applicationId: string, accountId?: string, partition?: string): this;
    /**
     * Statement provider for service [sso-oauth](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiamidentitycenteroidcservice.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
