"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Importexport = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [importexport](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsimportexportdiskservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Importexport extends shared_1.PolicyStatement {
    /**
     * This action cancels a specified job. Only the job owner can cancel it. The action fails if the job has already started or is complete.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebCancelJob.html
     */
    toCancelJob() {
        return this.to('CancelJob');
    }
    /**
     * This action initiates the process of scheduling an upload or download of your data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebCreateJob.html
     */
    toCreateJob() {
        return this.to('CreateJob');
    }
    /**
     * This action generates a pre-paid shipping label that you will use to ship your device to AWS for processing.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebGetShippingLabel.html
     */
    toGetShippingLabel() {
        return this.to('GetShippingLabel');
    }
    /**
     * This action returns information about a job, including where the job is in the processing pipeline, the status of the results, and the signature value associated with the job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebGetStatus.html
     */
    toGetStatus() {
        return this.to('GetStatus');
    }
    /**
     * This action returns the jobs associated with the requester.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebListJobs.html
     */
    toListJobs() {
        return this.to('ListJobs');
    }
    /**
     * You use this action to change the parameters specified in the original manifest file by supplying a new manifest file.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSImportExport/latest/DG/WebUpdateJob.html
     */
    toUpdateJob() {
        return this.to('UpdateJob');
    }
    /**
     * Statement provider for service [importexport](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsimportexportdiskservice.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'importexport';
        this.accessLevelList = {
            Write: [
                'CancelJob',
                'CreateJob',
                'UpdateJob'
            ],
            Read: [
                'GetShippingLabel',
                'GetStatus'
            ],
            List: [
                'ListJobs'
            ]
        };
    }
}
exports.Importexport = Importexport;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW1wb3J0ZXhwb3J0ZGlza3NlcnZpY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbXBvcnRleHBvcnRkaXNrc2VydmljZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFDQSx5Q0FBK0M7QUFHL0M7Ozs7R0FJRztBQUNILE1BQWEsWUFBYSxTQUFRLHdCQUFlO0lBRy9DOzs7Ozs7T0FNRztJQUNJLFdBQVc7UUFDaEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQzlCLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxXQUFXO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUM5QixDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxXQUFXO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUM5QixDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksVUFBVTtRQUNmLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUM3QixDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksV0FBVztRQUNoQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsV0FBVyxDQUFDLENBQUM7SUFDOUIsQ0FBQztJQWlCRDs7O09BR0c7SUFDSCxZQUFZLEtBQWdDO1FBQzFDLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQztRQXhGUixrQkFBYSxHQUFHLGNBQWMsQ0FBQztRQW9FNUIsb0JBQWUsR0FBb0I7WUFDM0MsS0FBSyxFQUFFO2dCQUNMLFdBQVc7Z0JBQ1gsV0FBVztnQkFDWCxXQUFXO2FBQ1o7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osa0JBQWtCO2dCQUNsQixXQUFXO2FBQ1o7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osVUFBVTthQUNYO1NBQ0YsQ0FBQztJQVFGLENBQUM7Q0FDRjtBQTNGRCxvQ0EyRkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBY2Nlc3NMZXZlbExpc3QgfSBmcm9tICcuLi8uLi9zaGFyZWQvYWNjZXNzLWxldmVsJztcbmltcG9ydCB7IFBvbGljeVN0YXRlbWVudCB9IGZyb20gJy4uLy4uL3NoYXJlZCc7XG5pbXBvcnQgeyBhd3NfaWFtIGFzIGlhbSB9IGZyb20gXCJhd3MtY2RrLWxpYlwiO1xuXG4vKipcbiAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbaW1wb3J0ZXhwb3J0XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2VydmljZS1hdXRob3JpemF0aW9uL2xhdGVzdC9yZWZlcmVuY2UvbGlzdF9hd3NpbXBvcnRleHBvcnRkaXNrc2VydmljZS5odG1sKS5cbiAqXG4gKiBAcGFyYW0gc2lkIFtTSURdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfc2lkLmh0bWwpIG9mIHRoZSBzdGF0ZW1lbnRcbiAqL1xuZXhwb3J0IGNsYXNzIEltcG9ydGV4cG9ydCBleHRlbmRzIFBvbGljeVN0YXRlbWVudCB7XG4gIHB1YmxpYyBzZXJ2aWNlUHJlZml4ID0gJ2ltcG9ydGV4cG9ydCc7XG5cbiAgLyoqXG4gICAqIFRoaXMgYWN0aW9uIGNhbmNlbHMgYSBzcGVjaWZpZWQgam9iLiBPbmx5IHRoZSBqb2Igb3duZXIgY2FuIGNhbmNlbCBpdC4gVGhlIGFjdGlvbiBmYWlscyBpZiB0aGUgam9iIGhhcyBhbHJlYWR5IHN0YXJ0ZWQgb3IgaXMgY29tcGxldGUuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0ltcG9ydEV4cG9ydC9sYXRlc3QvREcvV2ViQ2FuY2VsSm9iLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NhbmNlbEpvYigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ2FuY2VsSm9iJyk7XG4gIH1cblxuICAvKipcbiAgICogVGhpcyBhY3Rpb24gaW5pdGlhdGVzIHRoZSBwcm9jZXNzIG9mIHNjaGVkdWxpbmcgYW4gdXBsb2FkIG9yIGRvd25sb2FkIG9mIHlvdXIgZGF0YS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTSW1wb3J0RXhwb3J0L2xhdGVzdC9ERy9XZWJDcmVhdGVKb2IuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlSm9iKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVKb2InKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGlzIGFjdGlvbiBnZW5lcmF0ZXMgYSBwcmUtcGFpZCBzaGlwcGluZyBsYWJlbCB0aGF0IHlvdSB3aWxsIHVzZSB0byBzaGlwIHlvdXIgZGV2aWNlIHRvIEFXUyBmb3IgcHJvY2Vzc2luZy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NJbXBvcnRFeHBvcnQvbGF0ZXN0L0RHL1dlYkdldFNoaXBwaW5nTGFiZWwuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0U2hpcHBpbmdMYWJlbCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0U2hpcHBpbmdMYWJlbCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoaXMgYWN0aW9uIHJldHVybnMgaW5mb3JtYXRpb24gYWJvdXQgYSBqb2IsIGluY2x1ZGluZyB3aGVyZSB0aGUgam9iIGlzIGluIHRoZSBwcm9jZXNzaW5nIHBpcGVsaW5lLCB0aGUgc3RhdHVzIG9mIHRoZSByZXN1bHRzLCBhbmQgdGhlIHNpZ25hdHVyZSB2YWx1ZSBhc3NvY2lhdGVkIHdpdGggdGhlIGpvYi5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NJbXBvcnRFeHBvcnQvbGF0ZXN0L0RHL1dlYkdldFN0YXR1cy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRTdGF0dXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFN0YXR1cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoaXMgYWN0aW9uIHJldHVybnMgdGhlIGpvYnMgYXNzb2NpYXRlZCB3aXRoIHRoZSByZXF1ZXN0ZXIuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTSW1wb3J0RXhwb3J0L2xhdGVzdC9ERy9XZWJMaXN0Sm9icy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0Sm9icygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdEpvYnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBZb3UgdXNlIHRoaXMgYWN0aW9uIHRvIGNoYW5nZSB0aGUgcGFyYW1ldGVycyBzcGVjaWZpZWQgaW4gdGhlIG9yaWdpbmFsIG1hbmlmZXN0IGZpbGUgYnkgc3VwcGx5aW5nIGEgbmV3IG1hbmlmZXN0IGZpbGUuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0ltcG9ydEV4cG9ydC9sYXRlc3QvREcvV2ViVXBkYXRlSm9iLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZUpvYigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlSm9iJyk7XG4gIH1cblxuICBwcm90ZWN0ZWQgYWNjZXNzTGV2ZWxMaXN0OiBBY2Nlc3NMZXZlbExpc3QgPSB7XG4gICAgV3JpdGU6IFtcbiAgICAgICdDYW5jZWxKb2InLFxuICAgICAgJ0NyZWF0ZUpvYicsXG4gICAgICAnVXBkYXRlSm9iJ1xuICAgIF0sXG4gICAgUmVhZDogW1xuICAgICAgJ0dldFNoaXBwaW5nTGFiZWwnLFxuICAgICAgJ0dldFN0YXR1cydcbiAgICBdLFxuICAgIExpc3Q6IFtcbiAgICAgICdMaXN0Sm9icydcbiAgICBdXG4gIH07XG5cbiAgLyoqXG4gICAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbaW1wb3J0ZXhwb3J0XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2VydmljZS1hdXRob3JpemF0aW9uL2xhdGVzdC9yZWZlcmVuY2UvbGlzdF9hd3NpbXBvcnRleHBvcnRkaXNrc2VydmljZS5odG1sKS5cbiAgICpcbiAgICovXG4gIGNvbnN0cnVjdG9yKHByb3BzPzogaWFtLlBvbGljeVN0YXRlbWVudFByb3BzKSB7XG4gICAgc3VwZXIocHJvcHMpO1xuICB9XG59XG4iXX0=