"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotDeviceTester = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [iot-device-tester](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotdevicetester.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class IotDeviceTester extends shared_1.PolicyStatement {
    /**
     * Grants permission to IoT Device Tester to check if a given set of product, test suite and device tester version are compatible
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    toCheckVersion() {
        return this.to('CheckVersion');
    }
    /**
     * Grants permission to IoT Device Tester to download compatible test suite versions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    toDownloadTestSuite() {
        return this.to('DownloadTestSuite');
    }
    /**
     * Grants permission to IoT Device Tester to get information on latest version of device tester available
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    toLatestIdt() {
        return this.to('LatestIdt');
    }
    /**
     * Grants permission to IoT Device Tester to send usage metrics on your behalf
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    toSendMetrics() {
        return this.to('SendMetrics');
    }
    /**
     * Grants permission to IoT Device Tester to get list of supported products and test suite versions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    toSupportedVersion() {
        return this.to('SupportedVersion');
    }
    /**
     * Statement provider for service [iot-device-tester](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotdevicetester.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'iot-device-tester';
        this.accessLevelList = {
            Read: [
                'CheckVersion',
                'DownloadTestSuite',
                'LatestIdt',
                'SupportedVersion'
            ],
            Write: [
                'SendMetrics'
            ]
        };
    }
}
exports.IotDeviceTester = IotDeviceTester;
//# sourceMappingURL=data:application/json;base64,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