"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IqPermission = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [iq-permission](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiqpermissions.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class IqPermission extends shared_1.PolicyStatement {
    /**
     * Grants permission to approve a permission request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toApproveAccessGrant() {
        return this.to('ApproveAccessGrant');
    }
    /**
     * Grants permission to approve a permission request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toApprovePermissionRequest() {
        return this.to('ApprovePermissionRequest');
    }
    /**
     * Grants permission to obtain a set of temporary security credentials for experts which they can use to access buyers' AWS resources
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toAssumePermissionRole() {
        return this.to('AssumePermissionRole');
    }
    /**
     * Grants permission to create a permission request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreatePermissionRequest() {
        return this.to('CreatePermissionRequest');
    }
    /**
     * Grants permission to get a permission request
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetPermissionRequest() {
        return this.to('GetPermissionRequest');
    }
    /**
     * Grants permission to list permission requests
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListPermissionRequests() {
        return this.to('ListPermissionRequests');
    }
    /**
     * Grants permission to reject a permission request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toRejectPermissionRequest() {
        return this.to('RejectPermissionRequest');
    }
    /**
     * Grants permission to revoke a permission request which was previously approved
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toRevokePermissionRequest() {
        return this.to('RevokePermissionRequest');
    }
    /**
     * Grants permission to withdraw a permission request that has not been approved or declined
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toWithdrawPermissionRequest() {
        return this.to('WithdrawPermissionRequest');
    }
    /**
     * Adds a resource of type permission to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param permissionRequestId - Identifier for the permissionRequestId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onPermission(permissionRequestId, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:iq-permission:${region ?? this.defaultRegion}::permission/${permissionRequestId}`);
    }
    /**
     * Statement provider for service [iq-permission](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiqpermissions.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'iq-permission';
        this.accessLevelList = {
            Write: [
                'ApproveAccessGrant',
                'ApprovePermissionRequest',
                'AssumePermissionRole',
                'CreatePermissionRequest',
                'RejectPermissionRequest',
                'RevokePermissionRequest',
                'WithdrawPermissionRequest'
            ],
            Read: [
                'GetPermissionRequest',
                'ListPermissionRequests'
            ]
        };
    }
}
exports.IqPermission = IqPermission;
//# sourceMappingURL=data:application/json;base64,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