"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeoPlaces = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [geo-places](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocationserviceplaces.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class GeoPlaces extends shared_1.PolicyStatement {
    /**
     * Grants permission to autocomplete text input with potential places and addresses as the user types
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_geoplaces_Autocomplete.html
     */
    toAutocomplete() {
        return this.to('Autocomplete');
    }
    /**
     * Grants permission to geocode a textual address or place into geographic coordinates
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_geoplaces_Geocode.html
     */
    toGeocode() {
        return this.to('Geocode');
    }
    /**
     * Grants permission to query a place by it's unqiue place ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_geoplaces_GetPlace.html
     */
    toGetPlace() {
        return this.to('GetPlace');
    }
    /**
     * Grants permission to convert geographic coordinates into a human-readable address or place
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_geoplaces_ReverseGeocode.html
     */
    toReverseGeocode() {
        return this.to('ReverseGeocode');
    }
    /**
     * Grants permission to retrieve places near a position which match to a set of user defined restrictions such as category or food type offered by the place
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_geoplaces_SearchNearby.html
     */
    toSearchNearby() {
        return this.to('SearchNearby');
    }
    /**
     * Grants permission to query for places using a single free-form text input
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_geoplaces_SearchText.html
     */
    toSearchText() {
        return this.to('SearchText');
    }
    /**
     * Grants permission to suggest potential places based on the user's input
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_geoplaces_Suggest.html
     */
    toSuggest() {
        return this.to('Suggest');
    }
    /**
     * Adds a resource of type provider to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/Welcome.html
     *
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onProvider(region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:geo-places:${region ?? this.defaultRegion}::provider/default`);
    }
    /**
     * Statement provider for service [geo-places](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocationserviceplaces.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'geo-places';
        this.accessLevelList = {
            Read: [
                'Autocomplete',
                'Geocode',
                'GetPlace',
                'ReverseGeocode',
                'SearchNearby',
                'SearchText',
                'Suggest'
            ]
        };
    }
}
exports.GeoPlaces = GeoPlaces;
//# sourceMappingURL=data:application/json;base64,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