"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeoRoutes = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [geo-routes](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocationserviceroutes.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class GeoRoutes extends shared_1.PolicyStatement {
    /**
     * Grants permission to determine destinations or service areas reachable within a specified time
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CalculateIsolines.html
     */
    toCalculateIsolines() {
        return this.to('CalculateIsolines');
    }
    /**
     * Grants permission to calculate routing matrice which providing travel time and distances between sets of origins and destinations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CalculateRouteMatrix.html
     */
    toCalculateRouteMatrix() {
        return this.to('CalculateRouteMatrix');
    }
    /**
     * Grants permission to calculates routes between two or more locations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CalculateRoutes.html
     */
    toCalculateRoutes() {
        return this.to('CalculateRoutes');
    }
    /**
     * Grants permission to calculate the most efficient sequence for visiting multiple waypoints or locations along a route
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_OptimizeWaypoints.html
     */
    toOptimizeWaypoints() {
        return this.to('OptimizeWaypoints');
    }
    /**
     * Grants permission to enhances the accuracy of geographic positioning by aligning GPS coordinates to the nearest road segments on a digital map
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_SnapToRoads.html
     */
    toSnapToRoads() {
        return this.to('SnapToRoads');
    }
    /**
     * Adds a resource of type provider to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/Welcome.html
     *
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onProvider(region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:geo-routes:${region ?? this.defaultRegion}::provider/default`);
    }
    /**
     * Statement provider for service [geo-routes](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocationserviceroutes.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'geo-routes';
        this.accessLevelList = {
            Read: [
                'CalculateIsolines',
                'CalculateRouteMatrix',
                'CalculateRoutes',
                'OptimizeWaypoints',
                'SnapToRoads'
            ]
        };
    }
}
exports.GeoRoutes = GeoRoutes;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9jYXRpb25zZXJ2aWNlcm91dGVzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibG9jYXRpb25zZXJ2aWNlcm91dGVzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLHlDQUErQztBQUcvQzs7OztHQUlHO0FBQ0gsTUFBYSxTQUFVLFNBQVEsd0JBQWU7SUFHNUM7Ozs7OztPQU1HO0lBQ0ksbUJBQW1CO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxzQkFBc0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDekMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGlCQUFpQjtRQUN0QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksbUJBQW1CO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxhQUFhO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoQyxDQUFDO0lBWUQ7Ozs7Ozs7T0FPRztJQUNJLFVBQVUsQ0FBQyxNQUFlLEVBQUUsU0FBa0I7UUFDbkQsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLElBQUksQ0FBQyxnQkFBaUIsZUFBZ0IsTUFBTSxJQUFJLElBQUksQ0FBQyxhQUFjLG9CQUFvQixDQUFDLENBQUM7SUFDL0gsQ0FBQztJQUVEOzs7T0FHRztJQUNILFlBQVksS0FBZ0M7UUFDMUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBcEZSLGtCQUFhLEdBQUcsWUFBWSxDQUFDO1FBeUQxQixvQkFBZSxHQUFvQjtZQUMzQyxJQUFJLEVBQUU7Z0JBQ0osbUJBQW1CO2dCQUNuQixzQkFBc0I7Z0JBQ3RCLGlCQUFpQjtnQkFDakIsbUJBQW1CO2dCQUNuQixhQUFhO2FBQ2Q7U0FDRixDQUFDO0lBb0JGLENBQUM7Q0FDRjtBQXZGRCw4QkF1RkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBY2Nlc3NMZXZlbExpc3QgfSBmcm9tICcuLi8uLi9zaGFyZWQvYWNjZXNzLWxldmVsJztcbmltcG9ydCB7IFBvbGljeVN0YXRlbWVudCB9IGZyb20gJy4uLy4uL3NoYXJlZCc7XG5pbXBvcnQgeyBhd3NfaWFtIGFzIGlhbSB9IGZyb20gXCJhd3MtY2RrLWxpYlwiO1xuXG4vKipcbiAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbZ2VvLXJvdXRlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlcnZpY2UtYXV0aG9yaXphdGlvbi9sYXRlc3QvcmVmZXJlbmNlL2xpc3RfYW1hem9ubG9jYXRpb25zZXJ2aWNlcm91dGVzLmh0bWwpLlxuICpcbiAqIEBwYXJhbSBzaWQgW1NJRF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19zaWQuaHRtbCkgb2YgdGhlIHN0YXRlbWVudFxuICovXG5leHBvcnQgY2xhc3MgR2VvUm91dGVzIGV4dGVuZHMgUG9saWN5U3RhdGVtZW50IHtcbiAgcHVibGljIHNlcnZpY2VQcmVmaXggPSAnZ2VvLXJvdXRlcyc7XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRldGVybWluZSBkZXN0aW5hdGlvbnMgb3Igc2VydmljZSBhcmVhcyByZWFjaGFibGUgd2l0aGluIGEgc3BlY2lmaWVkIHRpbWVcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb2NhdGlvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9DYWxjdWxhdGVJc29saW5lcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DYWxjdWxhdGVJc29saW5lcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ2FsY3VsYXRlSXNvbGluZXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjYWxjdWxhdGUgcm91dGluZyBtYXRyaWNlIHdoaWNoIHByb3ZpZGluZyB0cmF2ZWwgdGltZSBhbmQgZGlzdGFuY2VzIGJldHdlZW4gc2V0cyBvZiBvcmlnaW5zIGFuZCBkZXN0aW5hdGlvbnNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb2NhdGlvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9DYWxjdWxhdGVSb3V0ZU1hdHJpeC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DYWxjdWxhdGVSb3V0ZU1hdHJpeCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ2FsY3VsYXRlUm91dGVNYXRyaXgnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjYWxjdWxhdGVzIHJvdXRlcyBiZXR3ZWVuIHR3byBvciBtb3JlIGxvY2F0aW9uc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvY2F0aW9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0NhbGN1bGF0ZVJvdXRlcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DYWxjdWxhdGVSb3V0ZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NhbGN1bGF0ZVJvdXRlcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNhbGN1bGF0ZSB0aGUgbW9zdCBlZmZpY2llbnQgc2VxdWVuY2UgZm9yIHZpc2l0aW5nIG11bHRpcGxlIHdheXBvaW50cyBvciBsb2NhdGlvbnMgYWxvbmcgYSByb3V0ZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvY2F0aW9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX09wdGltaXplV2F5cG9pbnRzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b09wdGltaXplV2F5cG9pbnRzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdPcHRpbWl6ZVdheXBvaW50cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGVuaGFuY2VzIHRoZSBhY2N1cmFjeSBvZiBnZW9ncmFwaGljIHBvc2l0aW9uaW5nIGJ5IGFsaWduaW5nIEdQUyBjb29yZGluYXRlcyB0byB0aGUgbmVhcmVzdCByb2FkIHNlZ21lbnRzIG9uIGEgZGlnaXRhbCBtYXBcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb2NhdGlvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9TbmFwVG9Sb2Fkcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9TbmFwVG9Sb2FkcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnU25hcFRvUm9hZHMnKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBhY2Nlc3NMZXZlbExpc3Q6IEFjY2Vzc0xldmVsTGlzdCA9IHtcbiAgICBSZWFkOiBbXG4gICAgICAnQ2FsY3VsYXRlSXNvbGluZXMnLFxuICAgICAgJ0NhbGN1bGF0ZVJvdXRlTWF0cml4JyxcbiAgICAgICdDYWxjdWxhdGVSb3V0ZXMnLFxuICAgICAgJ09wdGltaXplV2F5cG9pbnRzJyxcbiAgICAgICdTbmFwVG9Sb2FkcydcbiAgICBdXG4gIH07XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIHByb3ZpZGVyIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvY2F0aW9uL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9XZWxjb21lLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGAqYCwgdW5sZXNzIHVzaW5nIHRoZSBDREssIHdoZXJlIHRoZSBkZWZhdWx0IGlzIHRoZSBjdXJyZW50IFN0YWNrJ3MgcmVnaW9uLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYCwgdW5sZXNzIHVzaW5nIHRoZSBDREssIHdoZXJlIHRoZSBkZWZhdWx0IGlzIHRoZSBjdXJyZW50IFN0YWNrJ3MgcGFydGl0aW9uLlxuICAgKi9cbiAgcHVibGljIG9uUHJvdmlkZXIocmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5vbihgYXJuOiR7IHBhcnRpdGlvbiA/PyB0aGlzLmRlZmF1bHRQYXJ0aXRpb24gfTpnZW8tcm91dGVzOiR7IHJlZ2lvbiA/PyB0aGlzLmRlZmF1bHRSZWdpb24gfTo6cHJvdmlkZXIvZGVmYXVsdGApO1xuICB9XG5cbiAgLyoqXG4gICAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbZ2VvLXJvdXRlc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlcnZpY2UtYXV0aG9yaXphdGlvbi9sYXRlc3QvcmVmZXJlbmNlL2xpc3RfYW1hem9ubG9jYXRpb25zZXJ2aWNlcm91dGVzLmh0bWwpLlxuICAgKlxuICAgKi9cbiAgY29uc3RydWN0b3IocHJvcHM/OiBpYW0uUG9saWN5U3RhdGVtZW50UHJvcHMpIHtcbiAgICBzdXBlcihwcm9wcyk7XG4gIH1cbn1cbiJdfQ==