"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Machinelearning = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [machinelearning](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmachinelearning.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Machinelearning extends shared_1.PolicyStatement {
    /**
     * Adds one or more tags to an object, up to a limit of 10. Each tag consists of a key and an optional value
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_AddTags.html
     */
    toAddTags() {
        return this.to('AddTags');
    }
    /**
     * Generates predictions for a group of observations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateBatchPrediction.html
     */
    toCreateBatchPrediction() {
        return this.to('CreateBatchPrediction');
    }
    /**
     * Creates a DataSource object from an Amazon RDS
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateDataSourceFromRDS.html
     */
    toCreateDataSourceFromRDS() {
        return this.to('CreateDataSourceFromRDS');
    }
    /**
     * Creates a DataSource from a database hosted on an Amazon Redshift cluster
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateDataSourceFromRedshift.html
     */
    toCreateDataSourceFromRedshift() {
        return this.to('CreateDataSourceFromRedshift');
    }
    /**
     * Creates a DataSource object from S3
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateDataSourceFromS3.html
     */
    toCreateDataSourceFromS3() {
        return this.to('CreateDataSourceFromS3');
    }
    /**
     * Creates a new Evaluation of an MLModel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateEvaluation.html
     */
    toCreateEvaluation() {
        return this.to('CreateEvaluation');
    }
    /**
     * Creates a new MLModel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateMLModel.html
     */
    toCreateMLModel() {
        return this.to('CreateMLModel');
    }
    /**
     * Creates a real-time endpoint for the MLModel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateRealtimeEndpoint.html
     */
    toCreateRealtimeEndpoint() {
        return this.to('CreateRealtimeEndpoint');
    }
    /**
     * Assigns the DELETED status to a BatchPrediction, rendering it unusable
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteBatchPrediction.html
     */
    toDeleteBatchPrediction() {
        return this.to('DeleteBatchPrediction');
    }
    /**
     * Assigns the DELETED status to a DataSource, rendering it unusable
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteDataSource.html
     */
    toDeleteDataSource() {
        return this.to('DeleteDataSource');
    }
    /**
     * Assigns the DELETED status to an Evaluation, rendering it unusable
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteEvaluation.html
     */
    toDeleteEvaluation() {
        return this.to('DeleteEvaluation');
    }
    /**
     * Assigns the DELETED status to an MLModel, rendering it unusable
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteMLModel.html
     */
    toDeleteMLModel() {
        return this.to('DeleteMLModel');
    }
    /**
     * Deletes a real time endpoint of an MLModel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteRealtimeEndpoint.html
     */
    toDeleteRealtimeEndpoint() {
        return this.to('DeleteRealtimeEndpoint');
    }
    /**
     * Deletes the specified tags associated with an ML object. After this operation is complete, you can't recover deleted tags
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteTags.html
     */
    toDeleteTags() {
        return this.to('DeleteTags');
    }
    /**
     * Returns a list of BatchPrediction operations that match the search criteria in the request
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DescribeBatchPredictions.html
     */
    toDescribeBatchPredictions() {
        return this.to('DescribeBatchPredictions');
    }
    /**
     * Returns a list of DataSource that match the search criteria in the request
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DescribeDataSources.html
     */
    toDescribeDataSources() {
        return this.to('DescribeDataSources');
    }
    /**
     * Returns a list of DescribeEvaluations that match the search criteria in the request
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DescribeEvaluations.html
     */
    toDescribeEvaluations() {
        return this.to('DescribeEvaluations');
    }
    /**
     * Returns a list of MLModel that match the search criteria in the request
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DescribeMLModels.html
     */
    toDescribeMLModels() {
        return this.to('DescribeMLModels');
    }
    /**
     * Describes one or more of the tags for your Amazon ML object
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DescribeTags.html
     */
    toDescribeTags() {
        return this.to('DescribeTags');
    }
    /**
     * Returns a BatchPrediction that includes detailed metadata, status, and data file information
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_GetBatchPrediction.html
     */
    toGetBatchPrediction() {
        return this.to('GetBatchPrediction');
    }
    /**
     * Returns a DataSource that includes metadata and data file information, as well as the current status of the DataSource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_GetDataSource.html
     */
    toGetDataSource() {
        return this.to('GetDataSource');
    }
    /**
     * Returns an Evaluation that includes metadata as well as the current status of the Evaluation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_GetEvaluation.html
     */
    toGetEvaluation() {
        return this.to('GetEvaluation');
    }
    /**
     * Returns an MLModel that includes detailed metadata, and data source information as well as the current status of the MLModel
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_GetMLModel.html
     */
    toGetMLModel() {
        return this.to('GetMLModel');
    }
    /**
     * Generates a prediction for the observation using the specified ML Model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_Predict.html
     */
    toPredict() {
        return this.to('Predict');
    }
    /**
     * Updates the BatchPredictionName of a BatchPrediction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_UpdateBatchPrediction.html
     */
    toUpdateBatchPrediction() {
        return this.to('UpdateBatchPrediction');
    }
    /**
     * Updates the DataSourceName of a DataSource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_UpdateDataSource.html
     */
    toUpdateDataSource() {
        return this.to('UpdateDataSource');
    }
    /**
     * Updates the EvaluationName of an Evaluation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_UpdateEvaluation.html
     */
    toUpdateEvaluation() {
        return this.to('UpdateEvaluation');
    }
    /**
     * Updates the MLModelName and the ScoreThreshold of an MLModel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_UpdateMLModel.html
     */
    toUpdateMLModel() {
        return this.to('UpdateMLModel');
    }
    /**
     * Adds a resource of type batchprediction to the statement
     *
     * https://docs.aws.amazon.com/machine-learning/latest/dg/amazon-machine-learning-key-concepts.html#batch-predictions
     *
     * @param batchPredictionId - Identifier for the batchPredictionId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onBatchprediction(batchPredictionId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:machinelearning:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:batchprediction/${batchPredictionId}`);
    }
    /**
     * Adds a resource of type datasource to the statement
     *
     * https://docs.aws.amazon.com/machine-learning/latest/dg/amazon-machine-learning-key-concepts.html#datasources
     *
     * @param datasourceId - Identifier for the datasourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDatasource(datasourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:machinelearning:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:datasource/${datasourceId}`);
    }
    /**
     * Adds a resource of type evaluation to the statement
     *
     * https://docs.aws.amazon.com/machine-learning/latest/dg/amazon-machine-learning-key-concepts.html#evaluations
     *
     * @param evaluationId - Identifier for the evaluationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEvaluation(evaluationId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:machinelearning:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:evaluation/${evaluationId}`);
    }
    /**
     * Adds a resource of type mlmodel to the statement
     *
     * https://docs.aws.amazon.com/machine-learning/latest/dg/amazon-machine-learning-key-concepts.html#ml-models
     *
     * @param mlModelId - Identifier for the mlModelId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onMlmodel(mlModelId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:machinelearning:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:mlmodel/${mlModelId}`);
    }
    /**
     * Statement provider for service [machinelearning](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmachinelearning.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'machinelearning';
        this.accessLevelList = {
            Tagging: [
                'AddTags',
                'DeleteTags'
            ],
            Write: [
                'CreateBatchPrediction',
                'CreateDataSourceFromRDS',
                'CreateDataSourceFromRedshift',
                'CreateDataSourceFromS3',
                'CreateEvaluation',
                'CreateMLModel',
                'CreateRealtimeEndpoint',
                'DeleteBatchPrediction',
                'DeleteDataSource',
                'DeleteEvaluation',
                'DeleteMLModel',
                'DeleteRealtimeEndpoint',
                'Predict',
                'UpdateBatchPrediction',
                'UpdateDataSource',
                'UpdateEvaluation',
                'UpdateMLModel'
            ],
            List: [
                'DescribeBatchPredictions',
                'DescribeDataSources',
                'DescribeEvaluations',
                'DescribeMLModels',
                'DescribeTags'
            ],
            Read: [
                'GetBatchPrediction',
                'GetDataSource',
                'GetEvaluation',
                'GetMLModel'
            ]
        };
    }
}
exports.Machinelearning = Machinelearning;
//# sourceMappingURL=data:application/json;base64,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