import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [managedblockchain-query](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmanagedblockchainquery.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class ManagedblockchainQuery extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to batch calls for GetTokenBalance API
     *
     * Access Level: Read
     */
    toBatchGetTokenBalance(): this;
    /**
     * Grants permission to fetch information about a contract on the blockchain
     *
     * Access Level: Read
     */
    toGetAssetContract(): this;
    /**
     * Grants permission to retrieve balance of a token for an address on the blockchain
     *
     * Access Level: Read
     */
    toGetTokenBalance(): this;
    /**
     * Grants permission to retrieve a transaction on the blockchain
     *
     * Access Level: Read
     */
    toGetTransaction(): this;
    /**
     * Grants permission to fetch multiple contracts on the blockchain
     *
     * Access Level: List
     */
    toListAssetContracts(): this;
    /**
     * Grants permission to retrieve events on the blockchain with additional filters
     *
     * Access Level: List
     */
    toListFilteredTransactionEvents(): this;
    /**
     * Grants permission to retrieve multiple balances on the blockchain
     *
     * Access Level: List
     */
    toListTokenBalances(): this;
    /**
     * Grants permission to retrieve events in a transaction on the blockchain
     *
     * Access Level: List
     */
    toListTransactionEvents(): this;
    /**
     * Grants permission to retrieve a multiple transactions on a blockchain
     *
     * Access Level: List
     */
    toListTransactions(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [managedblockchain-query](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmanagedblockchainquery.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
