import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [aps](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmanagedserviceforprometheus.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Aps extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create alerts
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference-CreateAlertManagerAlerts.html
     */
    toCreateAlertManagerAlerts(): this;
    /**
     * Grants permission to create an alert manager definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_CreateAlertManagerDefinition.html
     */
    toCreateAlertManagerDefinition(): this;
    /**
     * Grants permission to create a logging configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_CreateLoggingConfiguration.html
     */
    toCreateLoggingConfiguration(): this;
    /**
     * Grants permission to create a query logging configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_CreateQueryLoggingConfiguration.html
     */
    toCreateQueryLoggingConfiguration(): this;
    /**
     * Grants permission to create a rule groups namespace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_CreateRuleGroupsNamespace.html
     */
    toCreateRuleGroupsNamespace(): this;
    /**
     * Grants permission to create a scraper
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - aps:TagResource
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSubnets
     * - eks:DescribeCluster
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_CreateScraper.html
     */
    toCreateScraper(): this;
    /**
     * Grants permission to create a workspace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_CreateWorkspace.html
     */
    toCreateWorkspace(): this;
    /**
     * Grants permission to delete an alert manager definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_DeleteAlertManagerDefinition.html
     */
    toDeleteAlertManagerDefinition(): this;
    /**
     * Grants permission to delete a silence
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference-DeleteAlertManagerSilence.html
     */
    toDeleteAlertManagerSilence(): this;
    /**
     * Grants permission to delete a logging configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_DeleteLoggingConfiguration.html
     */
    toDeleteLoggingConfiguration(): this;
    /**
     * Grants permission to delete a query logging configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_DeleteQueryLoggingConfiguration.html
     */
    toDeleteQueryLoggingConfiguration(): this;
    /**
     * Grants permission to delete workspace resource policy
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_DeleteResourcePolicy.html
     */
    toDeleteResourcePolicy(): this;
    /**
     * Grants permission to delete a rule groups namespace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_DeleteRuleGroupsNamespace.html
     */
    toDeleteRuleGroupsNamespace(): this;
    /**
     * Grants permission to delete a scraper
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_DeleteScraper.html
     */
    toDeleteScraper(): this;
    /**
     * Grants permission to delete a workspace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_DeleteWorkspace.html
     */
    toDeleteWorkspace(): this;
    /**
     * Grants permission to describe an alert manager definition
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_DescribeAlertManagerDefinition.html
     */
    toDescribeAlertManagerDefinition(): this;
    /**
     * Grants permission to describe a logging configuration
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_DescribeLoggingConfiguration.html
     */
    toDescribeLoggingConfiguration(): this;
    /**
     * Grants permission to describe a query logging configuration
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_DescribeQueryLoggingConfiguration.html
     */
    toDescribeQueryLoggingConfiguration(): this;
    /**
     * Grants permission to describe workspace resource policy
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_DescribeResourcePolicy.html
     */
    toDescribeResourcePolicy(): this;
    /**
     * Grants permission to describe a rule groups namespace
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_DescribeRuleGroupsNamespace.html
     */
    toDescribeRuleGroupsNamespace(): this;
    /**
     * Grants permission to describe a scraper
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_DescribeScraper.html
     */
    toDescribeScraper(): this;
    /**
     * Grants permission to describe a workspace
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_DescribeWorkspace.html
     */
    toDescribeWorkspace(): this;
    /**
     * Grants permission to describe workspace configuration
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_DescribeWorkspaceConfiguration.html
     */
    toDescribeWorkspaceConfiguration(): this;
    /**
     * Grants permission to get a silence
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference-GetAlertManagerSilence.html
     */
    toGetAlertManagerSilence(): this;
    /**
     * Grants permission to get current status of an alertmanager
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference-GetAlertManagerStatus.html
     */
    toGetAlertManagerStatus(): this;
    /**
     * Grants permission to get default scraper configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_GetDefaultScraperConfiguration.html
     */
    toGetDefaultScraperConfiguration(): this;
    /**
     * Grants permission to retrieve AMP workspace labels
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference-GetLabels.html
     */
    toGetLabels(): this;
    /**
     * Grants permission to retrieve the metadata for AMP workspace metrics
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference-GetMetricMetadata.html
     */
    toGetMetricMetadata(): this;
    /**
     * Grants permission to retrieve AMP workspace time series data
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference-GetSeries.html
     */
    toGetSeries(): this;
    /**
     * Grants permission to list groups
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference-ListAlertManagerAlertGroups.html
     */
    toListAlertManagerAlertGroups(): this;
    /**
     * Grants permission to list alerts
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference-ListAlertManagerAlerts.html
     */
    toListAlertManagerAlerts(): this;
    /**
     * Grants permission to list receivers
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference-ListAlertManagerReceivers.html
     */
    toListAlertManagerReceivers(): this;
    /**
     * Grants permission to list silences
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference-ListAlertManagerSilences.html
     */
    toListAlertManagerSilences(): this;
    /**
     * Grants permission to list active alerts
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference-ListAlerts.html
     */
    toListAlerts(): this;
    /**
     * Grants permission to list rule groups namespaces
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_ListRuleGroupsNamespaces.html
     */
    toListRuleGroupsNamespaces(): this;
    /**
     * Grants permission to list alerting and recording rules
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference-ListRules.html
     */
    toListRules(): this;
    /**
     * Grants permission to list scrapers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_ListScrapers.html
     */
    toListScrapers(): this;
    /**
     * Grants permission to list tags on an AMP resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list workspaces
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_ListWorkspaces.html
     */
    toListWorkspaces(): this;
    /**
     * Grants permission to update an alert manager definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_PutAlertManagerDefinition.html
     */
    toPutAlertManagerDefinition(): this;
    /**
     * Grants permission to create or update a silence
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference-PutAlertManagerSilences.html
     */
    toPutAlertManagerSilences(): this;
    /**
     * Grants permission to create and update workspace resource policy
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_PutResourcePolicy.html
     */
    toPutResourcePolicy(): this;
    /**
     * Grants permission to update a rule groups namespace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_PutRuleGroupsNamespace.html
     */
    toPutRuleGroupsNamespace(): this;
    /**
     * Grants permission to run a query on AMP workspace metrics
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference-QueryMetrics.html
     */
    toQueryMetrics(): this;
    /**
     * Grants permission to perform a remote write operation to initiate the streaming of metrics to AMP workspace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference-RemoteWrite.html
     */
    toRemoteWrite(): this;
    /**
     * Grants permission to tag an AMP resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag an AMP resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a logging configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_UpdateLoggingConfiguration.html
     */
    toUpdateLoggingConfiguration(): this;
    /**
     * Grants permission to update a query logging configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_UpdateQueryLoggingConfiguration.html
     */
    toUpdateQueryLoggingConfiguration(): this;
    /**
     * Grants permission to update a scraper
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - aps:CreateScraper
     * - aps:TagResource
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_UpdateScraper.html
     */
    toUpdateScraper(): this;
    /**
     * Grants permission to modify the alias of existing AMP workspace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_UpdateWorkspaceAlias.html
     */
    toUpdateWorkspaceAlias(): this;
    /**
     * Grants permission to update workspace configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/APIReference/API_UpdateWorkspaceConfiguration.html
     */
    toUpdateWorkspaceConfiguration(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type workspace to the statement
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/security-iam.html
     *
     * @param workspaceId - Identifier for the workspaceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     */
    onWorkspace(workspaceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type rulegroupsnamespace to the statement
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/security-iam.html
     *
     * @param workspaceId - Identifier for the workspaceId.
     * @param namespace - Identifier for the namespace.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     */
    onRulegroupsnamespace(workspaceId: string, namespace: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type scraper to the statement
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/security-iam.html
     *
     * @param scraperId - Identifier for the scraperId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     */
    onScraper(scraperId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type cluster to the statement
     *
     * https://docs.aws.amazon.com/eks/latest/userguide/clusters.html
     *
     * @param clusterName - Identifier for the clusterName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCluster(clusterName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access based on the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateRuleGroupsNamespace()
     * - .toCreateScraper()
     * - .toCreateWorkspace()
     * - .toListTagsForResource()
     * - .toTagResource()
     *
     * Applies to resource types:
     * - workspace
     * - rulegroupsnamespace
     * - scraper
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access based on the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toCreateAlertManagerAlerts()
     * - .toCreateAlertManagerDefinition()
     * - .toCreateLoggingConfiguration()
     * - .toCreateQueryLoggingConfiguration()
     * - .toCreateScraper()
     * - .toDeleteAlertManagerDefinition()
     * - .toDeleteAlertManagerSilence()
     * - .toDeleteLoggingConfiguration()
     * - .toDeleteQueryLoggingConfiguration()
     * - .toDeleteResourcePolicy()
     * - .toDeleteRuleGroupsNamespace()
     * - .toDeleteScraper()
     * - .toDeleteWorkspace()
     * - .toDescribeAlertManagerDefinition()
     * - .toDescribeLoggingConfiguration()
     * - .toDescribeQueryLoggingConfiguration()
     * - .toDescribeResourcePolicy()
     * - .toDescribeRuleGroupsNamespace()
     * - .toDescribeScraper()
     * - .toDescribeWorkspace()
     * - .toDescribeWorkspaceConfiguration()
     * - .toGetAlertManagerSilence()
     * - .toGetAlertManagerStatus()
     * - .toGetLabels()
     * - .toGetMetricMetadata()
     * - .toGetSeries()
     * - .toListAlertManagerAlertGroups()
     * - .toListAlertManagerAlerts()
     * - .toListAlertManagerReceivers()
     * - .toListAlertManagerSilences()
     * - .toListAlerts()
     * - .toListRuleGroupsNamespaces()
     * - .toListRules()
     * - .toPutAlertManagerDefinition()
     * - .toPutAlertManagerSilences()
     * - .toPutResourcePolicy()
     * - .toPutRuleGroupsNamespace()
     * - .toQueryMetrics()
     * - .toRemoteWrite()
     * - .toUpdateLoggingConfiguration()
     * - .toUpdateQueryLoggingConfiguration()
     * - .toUpdateScraper()
     * - .toUpdateWorkspaceAlias()
     * - .toUpdateWorkspaceConfiguration()
     *
     * Applies to resource types:
     * - workspace
     * - rulegroupsnamespace
     * - scraper
     * - cluster
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access based on the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateRuleGroupsNamespace()
     * - .toCreateScraper()
     * - .toCreateWorkspace()
     * - .toListTagsForResource()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * Applies to resource types:
     * - workspace
     * - rulegroupsnamespace
     * - scraper
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [aps](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmanagedserviceforprometheus.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
