"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplaceEntitlementService = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [aws-marketplace-entitlement-service](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplaceentitlementservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplaceEntitlementService extends shared_1.PolicyStatement {
    /**
     * Grants permission to retrieve entitlement values for a given product. The results can be filtered based on customer identifier or product dimensions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplaceentitlement/latest/APIReference/API_GetEntitlements.html
     */
    toGetEntitlements() {
        return this.to('GetEntitlements');
    }
    /**
     * Statement provider for service [aws-marketplace-entitlement-service](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplaceentitlementservice.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'aws-marketplace';
        this.accessLevelList = {
            Read: [
                'GetEntitlements'
            ]
        };
    }
}
exports.AwsMarketplaceEntitlementService = AwsMarketplaceEntitlementService;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWFya2V0cGxhY2VlbnRpdGxlbWVudHNlcnZpY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJtYXJrZXRwbGFjZWVudGl0bGVtZW50c2VydmljZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFDQSx5Q0FBK0M7QUFHL0M7Ozs7R0FJRztBQUNILE1BQWEsZ0NBQWlDLFNBQVEsd0JBQWU7SUFHbkU7Ozs7OztPQU1HO0lBQ0ksaUJBQWlCO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBQ3BDLENBQUM7SUFRRDs7O09BR0c7SUFDSCxZQUFZLEtBQWdDO1FBQzFDLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQztRQXhCUixrQkFBYSxHQUFHLGlCQUFpQixDQUFDO1FBYS9CLG9CQUFlLEdBQW9CO1lBQzNDLElBQUksRUFBRTtnQkFDSixpQkFBaUI7YUFDbEI7U0FDRixDQUFDO0lBUUYsQ0FBQztDQUNGO0FBM0JELDRFQTJCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFjY2Vzc0xldmVsTGlzdCB9IGZyb20gJy4uLy4uL3NoYXJlZC9hY2Nlc3MtbGV2ZWwnO1xuaW1wb3J0IHsgUG9saWN5U3RhdGVtZW50IH0gZnJvbSAnLi4vLi4vc2hhcmVkJztcbmltcG9ydCB7IGF3c19pYW0gYXMgaWFtIH0gZnJvbSBcImF3cy1jZGstbGliXCI7XG5cbi8qKlxuICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFthd3MtbWFya2V0cGxhY2UtZW50aXRsZW1lbnQtc2VydmljZV0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlcnZpY2UtYXV0aG9yaXphdGlvbi9sYXRlc3QvcmVmZXJlbmNlL2xpc3RfYXdzbWFya2V0cGxhY2VlbnRpdGxlbWVudHNlcnZpY2UuaHRtbCkuXG4gKlxuICogQHBhcmFtIHNpZCBbU0lEXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2VsZW1lbnRzX3NpZC5odG1sKSBvZiB0aGUgc3RhdGVtZW50XG4gKi9cbmV4cG9ydCBjbGFzcyBBd3NNYXJrZXRwbGFjZUVudGl0bGVtZW50U2VydmljZSBleHRlbmRzIFBvbGljeVN0YXRlbWVudCB7XG4gIHB1YmxpYyBzZXJ2aWNlUHJlZml4ID0gJ2F3cy1tYXJrZXRwbGFjZSc7XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHJldHJpZXZlIGVudGl0bGVtZW50IHZhbHVlcyBmb3IgYSBnaXZlbiBwcm9kdWN0LiBUaGUgcmVzdWx0cyBjYW4gYmUgZmlsdGVyZWQgYmFzZWQgb24gY3VzdG9tZXIgaWRlbnRpZmllciBvciBwcm9kdWN0IGRpbWVuc2lvbnNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9tYXJrZXRwbGFjZWVudGl0bGVtZW50L2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldEVudGl0bGVtZW50cy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRFbnRpdGxlbWVudHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldEVudGl0bGVtZW50cycpO1xuICB9XG5cbiAgcHJvdGVjdGVkIGFjY2Vzc0xldmVsTGlzdDogQWNjZXNzTGV2ZWxMaXN0ID0ge1xuICAgIFJlYWQ6IFtcbiAgICAgICdHZXRFbnRpdGxlbWVudHMnXG4gICAgXVxuICB9O1xuXG4gIC8qKlxuICAgKiBTdGF0ZW1lbnQgcHJvdmlkZXIgZm9yIHNlcnZpY2UgW2F3cy1tYXJrZXRwbGFjZS1lbnRpdGxlbWVudC1zZXJ2aWNlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2VydmljZS1hdXRob3JpemF0aW9uL2xhdGVzdC9yZWZlcmVuY2UvbGlzdF9hd3NtYXJrZXRwbGFjZWVudGl0bGVtZW50c2VydmljZS5odG1sKS5cbiAgICpcbiAgICovXG4gIGNvbnN0cnVjdG9yKHByb3BzPzogaWFtLlBvbGljeVN0YXRlbWVudFByb3BzKSB7XG4gICAgc3VwZXIocHJvcHMpO1xuICB9XG59XG4iXX0=