"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplaceMeteringService = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [aws-marketplace-metering-service](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemeteringservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplaceMeteringService extends shared_1.PolicyStatement {
    /**
     * Grants permission to post metering records for a set of customers for SaaS applications
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/APIReference/API_BatchMeterUsage.html
     */
    toBatchMeterUsage() {
        return this.to('BatchMeterUsage');
    }
    /**
     * Grants permission to emit metering records
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/APIReference/API_MeterUsage.html
     */
    toMeterUsage() {
        return this.to('MeterUsage');
    }
    /**
     * Grants permission to to verify that the customer running your paid software is subscribed to your product on AWS Marketplace, enabling you to guard against unauthorized use. Meters software use per ECS task, per hour, with usage prorated to the second
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/APIReference/API_RegisterUsage.html
     */
    toRegisterUsage() {
        return this.to('RegisterUsage');
    }
    /**
     * Grants permission to resolve a registration token to obtain a CustomerIdentifier and product code
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/APIReference/API_ResolveCustomer.html
     */
    toResolveCustomer() {
        return this.to('ResolveCustomer');
    }
    /**
     * Statement provider for service [aws-marketplace-metering-service](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemeteringservice.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'aws-marketplace';
        this.accessLevelList = {
            Write: [
                'BatchMeterUsage',
                'MeterUsage',
                'RegisterUsage',
                'ResolveCustomer'
            ]
        };
    }
}
exports.AwsMarketplaceMeteringService = AwsMarketplaceMeteringService;
//# sourceMappingURL=data:application/json;base64,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