"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplaceReporting = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [aws-marketplace-reporting](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacereporting.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplaceReporting extends shared_1.PolicyStatement {
    /**
     * Grants permission to view a dashboard that shows a buyer's AWS Marketplace purchase data
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/APIReference/API_marketplace-reporting_GetBuyerDashboard.html
     */
    toGetBuyerDashboard() {
        return this.to('GetBuyerDashboard');
    }
    /**
     * Adds a resource of type Dashboard to the statement
     *
     * https://docs.aws.amazon.com/marketplace/latest/APIReference/API_marketplace-reporting_GetBuyerDashboard.html#API_marketplace-reporting_GetBuyerDashboard_RequestBody
     *
     * @param catalog - Identifier for the catalog.
     * @param factTable - Identifier for the factTable.
     * @param dashboardName - Identifier for the dashboardName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDashboard(catalog, factTable, dashboardName, account, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:aws-marketplace::${account ?? this.defaultAccount}:${catalog}/ReportingData/${factTable}/Dashboard/${dashboardName}`);
    }
    /**
     * Statement provider for service [aws-marketplace-reporting](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacereporting.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'aws-marketplace';
        this.accessLevelList = {
            Read: [
                'GetBuyerDashboard'
            ]
        };
    }
}
exports.AwsMarketplaceReporting = AwsMarketplaceReporting;
//# sourceMappingURL=data:application/json;base64,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