import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [memorydb](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmemorydb.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Memorydb extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permissions to apply service updates
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_BatchUpdateCluster.html
     */
    toBatchUpdateCluster(): this;
    /**
     * Allows an IAM user or role to connect as a specified MemoryDB user to a node in a cluster
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/devguide/auth-iam.html
     */
    toConnect(): this;
    /**
     * Grants permissions to make a copy of an existing snapshot
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - memorydb:TagResource
     * - s3:DeleteObject
     * - s3:GetBucketAcl
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_CopySnapshot.html
     */
    toCopySnapshot(): this;
    /**
     * Grants permissions to create a new access control list
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - memorydb:TagResource
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_CreateAcl.html
     */
    toCreateAcl(): this;
    /**
     * Grants permissions to create a cluster
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifTLSEnabled()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     * - memorydb:TagResource
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_CreateCluster.html
     */
    toCreateCluster(): this;
    /**
     * Grants permissions to create a Multi-Region cluster
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifTLSEnabled()
     *
     * Dependent actions:
     * - memorydb:TagResource
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_CreateMultiRegionCluster.html
     */
    toCreateMultiRegionCluster(): this;
    /**
     * Grants permissions to create a new parameter group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - memorydb:TagResource
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_CreateParameterGroup.html
     */
    toCreateParameterGroup(): this;
    /**
     * Grants permissions to create a backup of a cluster at the current point in time
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - memorydb:TagResource
     * - s3:DeleteObject
     * - s3:GetBucketAcl
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_CreateSnapshot.html
     */
    toCreateSnapshot(): this;
    /**
     * Grants permissions to create a new subnet group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - memorydb:TagResource
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_CreateSubnetGroup.html
     */
    toCreateSubnetGroup(): this;
    /**
     * Grants permissions to create a new user
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifUserAuthenticationMode()
     *
     * Dependent actions:
     * - memorydb:TagResource
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_CreateUser.html
     */
    toCreateUser(): this;
    /**
     * Grants permissions to delete an access control list
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DeleteAcl.html
     */
    toDeleteAcl(): this;
    /**
     * Grants permissions to delete a previously provisioned cluster
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DeleteCluster.html
     */
    toDeleteCluster(): this;
    /**
     * Grants permissions to delete a Multi-Region cluster
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DeleteMultiRegionCluster.html
     */
    toDeleteMultiRegionCluster(): this;
    /**
     * Grants permissions to delete a parameter group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DeleteParameterGroup.html
     */
    toDeleteParameterGroup(): this;
    /**
     * Grants permissions to delete a snapshot
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DeleteSnapshot.html
     */
    toDeleteSnapshot(): this;
    /**
     * Grants permissions to delete a subnet group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DeleteSubnetGroup.html
     */
    toDeleteSubnetGroup(): this;
    /**
     * Grants permissions to delete a user
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DeleteUser.html
     */
    toDeleteUser(): this;
    /**
     * Grants permissions to retrieve information about access control lists
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeAcls.html
     */
    toDescribeAcls(): this;
    /**
     * Grants permissions to retrieve information about all provisioned clusters if no cluster identifier is specified, or about a specific cluster if a cluster identifier is supplied
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeClusters.html
     */
    toDescribeClusters(): this;
    /**
     * Grants permissions to list of the available engines and their versions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeEngineVersions.html
     */
    toDescribeEngineVersions(): this;
    /**
     * Grants permissions to retrieve events related to clusters, subnet groups, and parameter groups
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeEvents.html
     */
    toDescribeEvents(): this;
    /**
     * Grants permissions to retrieve information about all Multi-Region clusters if no cluster identifier is specified, or about a specific Multi-Region cluster if a cluster identifier is supplied
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeMultiRegionClusters.html
     */
    toDescribeMultiRegionClusters(): this;
    /**
     * Grants permissions to retrieve information about Multi-Region parameter groups
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeMultiRegionParameterGroups.html
     */
    toDescribeMultiRegionParameterGroups(): this;
    /**
     * Grants permissions to retrieve a detailed parameter list for a particular Multi-Region parameter group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeMultiRegionParameters.html
     */
    toDescribeMultiRegionParameters(): this;
    /**
     * Grants permissions to retrieve information about parameter groups
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeParameterGroups.html
     */
    toDescribeParameterGroups(): this;
    /**
     * Grants permissions to retrieve a detailed parameter list for a particular parameter group
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeParameters.html
     */
    toDescribeParameters(): this;
    /**
     * Grants permissions to retrieve reserved nodes
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeReservedNodes.html
     */
    toDescribeReservedNodes(): this;
    /**
     * Grants permissions to retrieve reserved nodes offerings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeReservedNodesOfferings.html
     */
    toDescribeReservedNodesOfferings(): this;
    /**
     * Grants permissions to retrieve details of the service updates
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeServiceUpdates.html
     */
    toDescribeServiceUpdates(): this;
    /**
     * Grants permissions to retrieve information about cluster snapshots
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeSnapshots.html
     */
    toDescribeSnapshots(): this;
    /**
     * Grants permissions to retrieve a list of subnet group
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeSubnetGroups.html
     */
    toDescribeSubnetGroups(): this;
    /**
     * Grants permissions to retrieve information about users
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_DescribeUsers.html
     */
    toDescribeUsers(): this;
    /**
     * Grants permissions to test automatic failover on a specified shard in a cluster
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_FailoverShard.html
     */
    toFailoverShard(): this;
    /**
     * Grants permissions to list available Multi-Region cluster updates
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_ListAllowedMultiRegionClusterUpdates.html
     */
    toListAllowedMultiRegionClusterUpdates(): this;
    /**
     * Grants permissions to list available node type updates
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_ListAllowedNodeTypeUpdates.html
     */
    toListAllowedNodeTypeUpdates(): this;
    /**
     * Grants permissions to list cost allocation tags
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_ListTags.html
     */
    toListTags(): this;
    /**
     * Grants permission to pause replication for a Multi-Region cluster
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/fis/latest/userguide/fis-actions-reference.html#memorydb-actions-reference
     */
    toPauseMultiRegionClusterReplication(): this;
    /**
     * Grants permissions to purchase a new reserved node
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - memorydb:TagResource
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_PurchaseReservedNodesOffering.html
     */
    toPurchaseReservedNodesOffering(): this;
    /**
     * Grants permissions to modify the parameters of a parameter group to the engine or system default value
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_ResetParameterGroup.html
     */
    toResetParameterGroup(): this;
    /**
     * Grants permissions to add up to 10 cost allocation tags to the named resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permissions to remove the tags identified by the TagKeys list from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permissions to update an access control list
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_UpdateAcl.html
     */
    toUpdateAcl(): this;
    /**
     * Grants permissions to update the settings for a cluster
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_UpdateCluster.html
     */
    toUpdateCluster(): this;
    /**
     * Grants permissions to update the settings for a Multi-Region cluster
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DeleteNetworkInterface
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_UpdateMultiRegionCluster.html
     */
    toUpdateMultiRegionCluster(): this;
    /**
     * Grants permissions to update parameters in a parameter group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_UpdateParameterGroup.html
     */
    toUpdateParameterGroup(): this;
    /**
     * Grants permissions to update a subnet group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_UpdateSubnetGroup.html
     */
    toUpdateSubnetGroup(): this;
    /**
     * Grants permissions to update a user
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifUserAuthenticationMode()
     *
     * https://docs.aws.amazon.com/memorydb/latest/APIReference/API_UpdateUser.html
     */
    toUpdateUser(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type multiregionparametergroup to the statement
     *
     * https://docs.aws.amazon.com/memorydb/latest/devguide/WhatIs.Components.html
     *
     * @param multiRegionParameterGroupName - Identifier for the multiRegionParameterGroupName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onMultiregionparametergroup(multiRegionParameterGroupName: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type parametergroup to the statement
     *
     * https://docs.aws.amazon.com/memorydb/latest/devguide/WhatIs.Components.html
     *
     * @param parameterGroupName - Identifier for the parameterGroupName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onParametergroup(parameterGroupName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type subnetgroup to the statement
     *
     * https://docs.aws.amazon.com/memorydb/latest/devguide/WhatIs.Components.html
     *
     * @param subnetGroupName - Identifier for the subnetGroupName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSubnetgroup(subnetGroupName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type multiregioncluster to the statement
     *
     * https://docs.aws.amazon.com/memorydb/latest/devguide/WhatIs.Components.html
     *
     * @param clusterName - Identifier for the clusterName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifTLSEnabled()
     */
    onMultiregioncluster(clusterName: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type cluster to the statement
     *
     * https://docs.aws.amazon.com/memorydb/latest/devguide/WhatIs.Components.html
     *
     * @param clusterName - Identifier for the clusterName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCluster(clusterName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type snapshot to the statement
     *
     * https://docs.aws.amazon.com/memorydb/latest/devguide/WhatIs.Components.html
     *
     * @param snapshotName - Identifier for the snapshotName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSnapshot(snapshotName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type user to the statement
     *
     * https://docs.aws.amazon.com/memorydb/latest/devguide/WhatIs.Components.html
     *
     * @param userName - Identifier for the userName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onUser(userName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type acl to the statement
     *
     * https://docs.aws.amazon.com/memorydb/latest/devguide/WhatIs.Components.html
     *
     * @param aclName - Identifier for the aclName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAcl(aclName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type reservednode to the statement
     *
     * https://docs.aws.amazon.com/memorydb/latest/devguide/WhatIs.Components.html
     *
     * @param reservationID - Identifier for the reservationID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onReservednode(reservationID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters actions based on the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCopySnapshot()
     * - .toCreateAcl()
     * - .toCreateCluster()
     * - .toCreateMultiRegionCluster()
     * - .toCreateParameterGroup()
     * - .toCreateSnapshot()
     * - .toCreateSubnetGroup()
     * - .toCreateUser()
     * - .toPurchaseReservedNodesOffering()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters actions based on the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toBatchUpdateCluster()
     * - .toConnect()
     * - .toCopySnapshot()
     * - .toCreateAcl()
     * - .toCreateCluster()
     * - .toCreateMultiRegionCluster()
     * - .toCreateSnapshot()
     * - .toDeleteAcl()
     * - .toDeleteCluster()
     * - .toDeleteMultiRegionCluster()
     * - .toDeleteParameterGroup()
     * - .toDeleteSnapshot()
     * - .toDeleteSubnetGroup()
     * - .toDeleteUser()
     * - .toDescribeAcls()
     * - .toDescribeClusters()
     * - .toDescribeMultiRegionClusters()
     * - .toDescribeParameterGroups()
     * - .toDescribeParameters()
     * - .toDescribeReservedNodes()
     * - .toDescribeSnapshots()
     * - .toDescribeSubnetGroups()
     * - .toDescribeUsers()
     * - .toFailoverShard()
     * - .toListAllowedMultiRegionClusterUpdates()
     * - .toListAllowedNodeTypeUpdates()
     * - .toListTags()
     * - .toPauseMultiRegionClusterReplication()
     * - .toPurchaseReservedNodesOffering()
     * - .toResetParameterGroup()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateAcl()
     * - .toUpdateCluster()
     * - .toUpdateMultiRegionCluster()
     * - .toUpdateParameterGroup()
     * - .toUpdateSubnetGroup()
     * - .toUpdateUser()
     *
     * Applies to resource types:
     * - parametergroup
     * - subnetgroup
     * - multiregioncluster
     * - cluster
     * - snapshot
     * - user
     * - acl
     * - reservednode
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters actions based on the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCopySnapshot()
     * - .toCreateAcl()
     * - .toCreateCluster()
     * - .toCreateMultiRegionCluster()
     * - .toCreateParameterGroup()
     * - .toCreateSnapshot()
     * - .toCreateSubnetGroup()
     * - .toCreateUser()
     * - .toPurchaseReservedNodesOffering()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the TLSEnabled parameter present in the request or defaults to true value if parameter is not present
     *
     * https://docs.aws.amazon.com/memorydb/latest/devguide/IAM.ConditionKeys.html#IAM.SpecifyingConditions
     *
     * Applies to actions:
     * - .toCreateCluster()
     * - .toCreateMultiRegionCluster()
     *
     * Applies to resource types:
     * - multiregioncluster
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifTLSEnabled(value?: boolean): this;
    /**
     * Filters access by the UserAuthenticationMode.Type parameter in the request
     *
     * https://docs.aws.amazon.com/memorydb/latest/devguide/IAM.ConditionKeys.html#IAM.SpecifyingConditions
     *
     * Applies to actions:
     * - .toCreateUser()
     * - .toUpdateUser()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifUserAuthenticationMode(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [memorydb](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmemorydb.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
