"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MigrationhubStrategy = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [migrationhub-strategy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmigrationhubstrategyrecommendations.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class MigrationhubStrategy extends shared_1.PolicyStatement {
    /**
     * Grants permission to get details of each anti pattern that collector should look at in a customer's environment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetAntiPattern.html
     */
    toGetAntiPattern() {
        return this.to('GetAntiPattern');
    }
    /**
     * Grants permission to get details of an application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetApplicationComponentDetails.html
     */
    toGetApplicationComponentDetails() {
        return this.to('GetApplicationComponentDetails');
    }
    /**
     * Grants permission to get a list of all recommended strategies and tools for an application running in a server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetApplicationComponentStrategies.html
     */
    toGetApplicationComponentStrategies() {
        return this.to('GetApplicationComponentStrategies');
    }
    /**
     * Grants permission to retrieve status of an on-going assessment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetAssessment.html
     */
    toGetAssessment() {
        return this.to('GetAssessment');
    }
    /**
     * Grants permission to get details of a specific import task
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetImportFileTask.html
     */
    toGetImportFileTask() {
        return this.to('GetImportFileTask');
    }
    /**
     * Grants permission to retrieve the latest assessment id
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetLatestAssessmentId.html
     */
    toGetLatestAssessmentId() {
        return this.to('GetLatestAssessmentId');
    }
    /**
     * Grants permission to the collector to receive information from the service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetMessage.html
     */
    toGetMessage() {
        return this.to('GetMessage');
    }
    /**
     * Grants permission to retrieve customer migration/Modernization preferences
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetPortfolioPreferences.html
     */
    toGetPortfolioPreferences() {
        return this.to('GetPortfolioPreferences');
    }
    /**
     * Grants permission to retrieve overall summary (number-of servers to rehost etc as well as overall number of anti patterns)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetPortfolioSummary.html
     */
    toGetPortfolioSummary() {
        return this.to('GetPortfolioSummary');
    }
    /**
     * Grants permission to retrieve detailed information about a recommendation report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetRecommendationReportDetails.html
     */
    toGetRecommendationReportDetails() {
        return this.to('GetRecommendationReportDetails');
    }
    /**
     * Grants permission to get info about a specific server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetServerDetails.html
     */
    toGetServerDetails() {
        return this.to('GetServerDetails');
    }
    /**
     * Grants permission to get recommended strategies and tools for a specific server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetServerStrategies.html
     */
    toGetServerStrategies() {
        return this.to('GetServerStrategies');
    }
    /**
     * Grants permission to get a list of all analyzable servers in a customer's vcenter environment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListAnalyzableServers.html
     */
    toListAnalyzableServers() {
        return this.to('ListAnalyzableServers');
    }
    /**
     * Grants permission to get a list of all anti patterns that collector should look for in a customer's environment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListAntiPatterns.html
     */
    toListAntiPatterns() {
        return this.to('ListAntiPatterns');
    }
    /**
     * Grants permission to get a list of all applications running on servers on customer's servers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListApplicationComponents.html
     */
    toListApplicationComponents() {
        return this.to('ListApplicationComponents');
    }
    /**
     * Grants permission to get a list of all collectors installed by the customer
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListCollectors.html
     */
    toListCollectors() {
        return this.to('ListCollectors');
    }
    /**
     * Grants permission to get list of all imports performed by the customer
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListImportFileTask.html
     */
    toListImportFileTask() {
        return this.to('ListImportFileTask');
    }
    /**
     * Grants permission to get a list of binaries that collector should assess
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListJarArtifacts.html
     */
    toListJarArtifacts() {
        return this.to('ListJarArtifacts');
    }
    /**
     * Grants permission to get a list of all servers in a customer's environment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListServers.html
     */
    toListServers() {
        return this.to('ListServers');
    }
    /**
     * Grants permission to the collector to send logs to the service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_PutLogData.html
     */
    toPutLogData() {
        return this.to('PutLogData');
    }
    /**
     * Grants permission to the collector to send metrics to the service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_PutMetricData.html
     */
    toPutMetricData() {
        return this.to('PutMetricData');
    }
    /**
     * Grants permission to save customer's Migration/Modernization preferences
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_PutPortfolioPreferences.html
     */
    toPutPortfolioPreferences() {
        return this.to('PutPortfolioPreferences');
    }
    /**
     * Grants permission to register the collector to receive an ID and to start receiving messages from the service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_RegisterCollector.html
     */
    toRegisterCollector() {
        return this.to('RegisterCollector');
    }
    /**
     * Grants permission to the collector to send information to the service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_SendMessage.html
     */
    toSendMessage() {
        return this.to('SendMessage');
    }
    /**
     * Grants permission to start assessment in a customer's environment (collect data from all servers and provide recommendations)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_StartAssessment.html
     */
    toStartAssessment() {
        return this.to('StartAssessment');
    }
    /**
     * Grants permission to start importing data from a file provided by customer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_StartImportFileTask.html
     */
    toStartImportFileTask() {
        return this.to('StartImportFileTask');
    }
    /**
     * Grants permission to start generating a recommendation report
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_StartRecommendationReportGeneration.html
     */
    toStartRecommendationReportGeneration() {
        return this.to('StartRecommendationReportGeneration');
    }
    /**
     * Grants permission to stop an on-going assessment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_StopAssessment.html
     */
    toStopAssessment() {
        return this.to('StopAssessment');
    }
    /**
     * Grants permission to update details for an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_UpdateApplicationComponentConfig.html
     */
    toUpdateApplicationComponentConfig() {
        return this.to('UpdateApplicationComponentConfig');
    }
    /**
     * Grants permission to the collector to send configuration information to the service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_UpdateCollectorConfiguration.html
     */
    toUpdateCollectorConfiguration() {
        return this.to('UpdateCollectorConfiguration');
    }
    /**
     * Grants permission to update info on a server along with the recommended strategy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_UpdateServerConfig.html
     */
    toUpdateServerConfig() {
        return this.to('UpdateServerConfig');
    }
    /**
     * Statement provider for service [migrationhub-strategy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmigrationhubstrategyrecommendations.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'migrationhub-strategy';
        this.accessLevelList = {
            Read: [
                'GetAntiPattern',
                'GetApplicationComponentDetails',
                'GetApplicationComponentStrategies',
                'GetAssessment',
                'GetImportFileTask',
                'GetLatestAssessmentId',
                'GetMessage',
                'GetPortfolioPreferences',
                'GetPortfolioSummary',
                'GetRecommendationReportDetails',
                'GetServerDetails',
                'GetServerStrategies'
            ],
            List: [
                'ListAnalyzableServers',
                'ListAntiPatterns',
                'ListApplicationComponents',
                'ListCollectors',
                'ListImportFileTask',
                'ListJarArtifacts',
                'ListServers'
            ],
            Write: [
                'PutLogData',
                'PutMetricData',
                'PutPortfolioPreferences',
                'RegisterCollector',
                'SendMessage',
                'StartAssessment',
                'StartImportFileTask',
                'StartRecommendationReportGeneration',
                'StopAssessment',
                'UpdateApplicationComponentConfig',
                'UpdateCollectorConfiguration',
                'UpdateServerConfig'
            ]
        };
    }
}
exports.MigrationhubStrategy = MigrationhubStrategy;
//# sourceMappingURL=data:application/json;base64,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