import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [mpa](https://docs.aws.amazon.com/service-authorization/latest/reference/list_multi-partyapproval.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Mpa extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to cancel an approval session
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifRequestedOperation()
     * - .ifProtectedResourceAccount()
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_CancelSession.html
     */
    toCancelSession(): this;
    /**
     * Grants permission to create an approval team
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_CreateApprovalTeam.html
     */
    toCreateApprovalTeam(): this;
    /**
     * Grants permission to create an identity source
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_CreateIdentitySource.html
     */
    toCreateIdentitySource(): this;
    /**
     * Grants permission to delete an identity source
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_DeleteIdentitySource.html
     */
    toDeleteIdentitySource(): this;
    /**
     * Grants permission to delete an inactive approval team
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_DeleteInactiveApprovalTeamVersion.html
     */
    toDeleteInactiveApprovalTeamVersion(): this;
    /**
     * Grants permission to delete a resource policy
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_DeleteResourcePolicy.html
     */
    toDeleteResourcePolicy(): this;
    /**
     * Grants permission to retrieve details for an approval team
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_GetApprovalTeam.html
     */
    toGetApprovalTeam(): this;
    /**
     * Grants permission to retrieve details for an identity source
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_GetIdentitySource.html
     */
    toGetIdentitySource(): this;
    /**
     * Grants permission to retrieve details for a policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_GetPolicyVersion.html
     */
    toGetPolicyVersion(): this;
    /**
     * Grants permission to retrieve details for a specific resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_GetResourcePolicy.html
     */
    toGetResourcePolicy(): this;
    /**
     * Grants permission to retrieve details for an approval session
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifRequestedOperation()
     * - .ifProtectedResourceAccount()
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_GetSession.html
     */
    toGetSession(): this;
    /**
     * Grants permission to list approval teams
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_ListApprovalTeams.html
     */
    toListApprovalTeams(): this;
    /**
     * Grants permission to list identity sources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_ListIdentitySources.html
     */
    toListIdentitySources(): this;
    /**
     * Grants permission to list policies
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_ListPolicies.html
     */
    toListPolicies(): this;
    /**
     * Grants permission to list the versions for policies
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_ListPolicyVersions.html
     */
    toListPolicyVersions(): this;
    /**
     * Grants permission to list policies for a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_ListResourcePolicies.html
     */
    toListResourcePolicies(): this;
    /**
     * Grants permission to list approval sessions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_ListSessions.html
     */
    toListSessions(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to create or update policies for a resource
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_PutResourcePolicy.html
     */
    toPutResourcePolicy(): this;
    /**
     * Grants permission to start the deletion process for an active approval team
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_StartActiveApprovalTeamDeletion.html
     */
    toStartActiveApprovalTeamDeletion(): this;
    /**
     * Grants permission to start an approval session
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifRequestedOperation()
     * - .ifProtectedResourceAccount()
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_StartSessionInternal.html
     */
    toStartSession(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update approval team
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/mpa/latest/APIReference/API_UpdateApprovalTeam.html
     */
    toUpdateApprovalTeam(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type approval-team to the statement
     *
     * https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html
     *
     * @param approvalTeamId - Identifier for the approvalTeamId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApprovalTeam(approvalTeamId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type identity-source to the statement
     *
     * https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html
     *
     * @param identitySourceId - Identifier for the identitySourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onIdentitySource(identitySourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type session to the statement
     *
     * https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html
     *
     * @param sessionId - Identifier for the sessionId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSession(sessionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by a tag key and value pair that is allowed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateApprovalTeam()
     * - .toCreateIdentitySource()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a tag key and value pair of a resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toCancelSession()
     * - .toCreateApprovalTeam()
     * - .toCreateIdentitySource()
     * - .toDeleteIdentitySource()
     * - .toDeleteInactiveApprovalTeamVersion()
     * - .toGetApprovalTeam()
     * - .toGetIdentitySource()
     * - .toGetSession()
     * - .toStartActiveApprovalTeamDeletion()
     * - .toStartSession()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateApprovalTeam()
     *
     * Applies to resource types:
     * - approval-team
     * - identity-source
     * - session
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a list of tag keys that are allowed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateApprovalTeam()
     * - .toCreateIdentitySource()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the account that owns the resource that is the target of the operation that requires approval
     *
     * https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html
     *
     * Applies to actions:
     * - .toCancelSession()
     * - .toGetSession()
     * - .toStartSession()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifProtectedResourceAccount(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a requested operation that requires team approval before it can be executed
     *
     * https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html
     *
     * Applies to actions:
     * - .toCancelSession()
     * - .toGetSession()
     * - .toStartSession()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRequestedOperation(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [mpa](https://docs.aws.amazon.com/service-authorization/latest/reference/list_multi-partyapproval.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
