import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [panorama](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspanorama.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Panorama extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create an AWS Panorama Application Instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_CreateApplicationInstance.html
     */
    toCreateApplicationInstance(): this;
    /**
     * Grants permission to create a job for an AWS Panorama Appliance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_CreateJobForDevices.html
     */
    toCreateJobForDevices(): this;
    /**
     * Grants permission to create an AWS Panorama Node
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_CreateNodeFromTemplateJob.html
     */
    toCreateNodeFromTemplateJob(): this;
    /**
     * Grants permission to create an AWS Panorama Package
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_CreatePackage.html
     */
    toCreatePackage(): this;
    /**
     * Grants permission to create an AWS Panorama Package
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_CreatePackageImportJob.html
     */
    toCreatePackageImportJob(): this;
    /**
     * Grants permission to deregister an AWS Panorama Appliance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DeleteDevice.html
     */
    toDeleteDevice(): this;
    /**
     * Grants permission to delete an AWS Panorama Package
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DeletePackage.html
     */
    toDeletePackage(): this;
    /**
     * Grants permission to deregister an AWS Panorama package version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DeregisterPackageVersion.html
     */
    toDeregisterPackageVersion(): this;
    /**
     * Grants permission to view details about an AWS Panorama application instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DescribeApplicationInstance.html
     */
    toDescribeApplicationInstance(): this;
    /**
     * Grants permission to view details about an AWS Panorama application instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DescribeApplicationInstanceDetails.html
     */
    toDescribeApplicationInstanceDetails(): this;
    /**
     * Grants permission to view details about an AWS Panorama Appliance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DescribeDevice.html
     */
    toDescribeDevice(): this;
    /**
     * Grants permission to view job details for an AWS Panorama Appliance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DescribeDeviceJob.html
     */
    toDescribeDeviceJob(): this;
    /**
     * Grants permission to view details about an AWS Panorama application node
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DescribeNode.html
     */
    toDescribeNode(): this;
    /**
     * Grants permission to view details about AWS Panorama application node
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DescribeNodeFromTemplateJob.html
     */
    toDescribeNodeFromTemplateJob(): this;
    /**
     * Grants permission to view details about an AWS Panorama package
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DescribePackage.html
     */
    toDescribePackage(): this;
    /**
     * Grants permission to view details about an AWS Panorama package
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DescribePackageImportJob.html
     */
    toDescribePackageImportJob(): this;
    /**
     * Grants permission to view details about an AWS Panorama package version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DescribePackageVersion.html
     */
    toDescribePackageVersion(): this;
    /**
     * Grants permission to view details about a software version for the AWS Panorama Appliance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspanorama.html
     */
    toDescribeSoftware(): this;
    /**
     * Grants permission to generate a WebSocket endpoint for communication with AWS Panorama
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspanorama.html
     */
    toGetWebSocketURL(): this;
    /**
     * Grants permission to retrieve a list of application instance dependencies in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ListApplicationInstanceDependencies.html
     */
    toListApplicationInstanceDependencies(): this;
    /**
     * Grants permission to retrieve a list of node instances of application instances in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ListApplicationInstanceNodeInstances.html
     */
    toListApplicationInstanceNodeInstances(): this;
    /**
     * Grants permission to retrieve a list of application instances in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ListApplicationInstances.html
     */
    toListApplicationInstances(): this;
    /**
     * Grants permission to retrieve a list of appliances in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ListDevices.html
     */
    toListDevices(): this;
    /**
     * Grants permission to retrieve a list of jobs for an AWS Panorama Appliance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ListDevicesJobs.html
     */
    toListDevicesJobs(): this;
    /**
     * Grants permission to retrieve a list of Nodes for an AWS Panorama Appliance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ListNodeFromTemplateJobs.html
     */
    toListNodeFromTemplateJobs(): this;
    /**
     * Grants permission to retrieve a list of nodes in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ListNodes.html
     */
    toListNodes(): this;
    /**
     * Grants permission to retrieve a list of packages in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ListPackageImportJobs.html
     */
    toListPackageImportJobs(): this;
    /**
     * Grants permission to retrieve a list of packages in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ListPackages.html
     */
    toListPackages(): this;
    /**
     * Grants permission to retrieve a list of tags for a resource in AWS Panorama
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to register an AWS Panorama Appliance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ProvisionDevice.html
     */
    toProvisionDevice(): this;
    /**
     * Grants permission to register an AWS Panorama package version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_RegisterPackageVersion.html
     */
    toRegisterPackageVersion(): this;
    /**
     * Grants permission to remove an AWS Panorama application instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_RemoveApplicationInstance.html
     */
    toRemoveApplicationInstance(): this;
    /**
     * Grants permission to signal camera nodes in an application instance to pause or resume
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_SignalApplicationInstanceNodeInstances.html
     */
    toSignalApplicationInstanceNodeInstances(): this;
    /**
     * Grants permission to add tags to a resource in AWS Panorama
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a resource in AWS Panorama
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to modify basic settings for an AWS Panorama Appliance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_UpdateDeviceMetadata.html
     */
    toUpdateDeviceMetadata(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type device to the statement
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/gettingstarted-concepts.html#gettingstarted-concepts-appliance
     *
     * @param deviceId - Identifier for the deviceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDevice(deviceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type package to the statement
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/gettingstarted-concepts.html#gettingstarted-concepts-node
     *
     * @param packageId - Identifier for the packageId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPackage(packageId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type applicationInstance to the statement
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/gettingstarted-concepts.html#gettingstarted-concepts-application
     *
     * @param applicationInstanceId - Identifier for the applicationInstanceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApplicationInstance(applicationInstanceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateApplicationInstance()
     * - .toCreatePackage()
     * - .toProvisionDevice()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - device
     * - package
     * - applicationInstance
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateApplicationInstance()
     * - .toCreatePackage()
     * - .toProvisionDevice()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [panorama](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspanorama.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
