import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [qbusiness](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonqbusiness.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Qbusiness extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to configure vended log delivery for Amazon Q Business application resource
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    toAllowVendedLogDeliveryForResource(): this;
    /**
     * Grants permission to associate resource based policy statement to the application
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - qbusiness:PutResourcePolicy
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_AssociatePermission.html
     */
    toAssociatePermission(): this;
    /**
     * Grants permission to batch delete document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_BatchDeleteDocument.html
     */
    toBatchDeleteDocument(): this;
    /**
     * Grants permission to batch put document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_BatchPutDocument.html
     */
    toBatchPutDocument(): this;
    /**
     * Grants permission to cancel a subscription
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_CancelSubscription.html
     */
    toCancelSubscription(): this;
    /**
     * Grants permission to chat using an application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_Chat.html
     */
    toChat(): this;
    /**
     * Grants permission to chat synchronously using an application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ChatSync.html
     */
    toChatSync(): this;
    /**
     * Grants permission to check if a user has access to a document
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_CheckDocumentAccess.html
     */
    toCheckDocumentAccess(): this;
    /**
     * Grants permission to create a unique URL for anonymous Amazon Q Business web experience
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_CreateAnonymousWebExperienceUrl.html
     */
    toCreateAnonymousWebExperienceUrl(): this;
    /**
     * Grants permission to create an application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_CreateApplication.html
     */
    toCreateApplication(): this;
    /**
     * Grants permission to create a chat response configuration to the application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_CreateChatResponseConfiguration.html
     */
    toCreateChatResponseConfiguration(): this;
    /**
     * Grants permission to create DataAccessor to the application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - qbusiness:CreateDataAccessorWithTti
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_CreateDataAccessor.html
     */
    toCreateDataAccessor(): this;
    /**
     * Grants permission to create AWS IAM Identity center Trusted Token Issuer based DataAccessor to the application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_CreateDataAccessor.html
     */
    toCreateDataAccessorWithTti(): this;
    /**
     * Grants permission to create a data source for a given application and index
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_CreateDataSource.html
     */
    toCreateDataSource(): this;
    /**
     * Grants permission to create an index for a given application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_CreateIndex.html
     */
    toCreateIndex(): this;
    /**
     * Grants permission to create a new integration for a Q Business application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_CreateIntegration.html
     */
    toCreateIntegration(): this;
    /**
     * Grants permission to create a plugin for a given application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_CreatePlugin.html
     */
    toCreatePlugin(): this;
    /**
     * Grants permission to create a retriever for a given application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_CreateRetriever.html
     */
    toCreateRetriever(): this;
    /**
     * Grants permission to create a subscription
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifIdentitystoreUserId()
     * - .ifIdentitystoreGroupId()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_CreateSubscription.html
     */
    toCreateSubscription(): this;
    /**
     * Grants permission to create a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_CreateUser.html
     */
    toCreateUser(): this;
    /**
     * Grants permission to create a web experience for a given application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_CreateWebExperience.html
     */
    toCreateWebExperience(): this;
    /**
     * Grants permission to delete an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DeleteApplication.html
     */
    toDeleteApplication(): this;
    /**
     * Grants permission to delete an attachment in the current chat context
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DeleteAttachment.html
     */
    toDeleteAttachment(): this;
    /**
     * Grants permission to delete chat controls configuration for an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DeleteChatControlsConfiguration.html
     */
    toDeleteChatControlsConfiguration(): this;
    /**
     * Grants permission to delete a chat response configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DeleteChatResponseConfiguration.html
     */
    toDeleteChatResponseConfiguration(): this;
    /**
     * Grants permission to delete a conversation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DeleteConversation.html
     */
    toDeleteConversation(): this;
    /**
     * Grants permission to delete DataAccessor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DeleteDataAccessor.html
     */
    toDeleteDataAccessor(): this;
    /**
     * Grants permission to delete a DataSource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DeleteDataSource.html
     */
    toDeleteDataSource(): this;
    /**
     * Grants permission to delete a group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DeleteGroup.html
     */
    toDeleteGroup(): this;
    /**
     * Grants permission to delete an index
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DeleteIndex.html
     */
    toDeleteIndex(): this;
    /**
     * Grants permission to delete an integration for a Q Business application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DeleteIntegration.html
     */
    toDeleteIntegration(): this;
    /**
     * Grants permission to delete a plugin
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DeletePlugin.html
     */
    toDeletePlugin(): this;
    /**
     * Grants permission to delete a retriever
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DeleteRetriever.html
     */
    toDeleteRetriever(): this;
    /**
     * Grants permission to delete a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DeleteUser.html
     */
    toDeleteUser(): this;
    /**
     * Grants permission to delete a web-experience
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DeleteWebExperience.html
     */
    toDeleteWebExperience(): this;
    /**
     * Grants permission to disable the ACL crawl while creating the Amazon Q Business data source resource
     *
     * Access Level: Write
     */
    toDisableAclOnDataSource(): this;
    /**
     * Grants permission to disassociate resource based policy statement to the application
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - qbusiness:PutResourcePolicy
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DisassociatePermission.html
     */
    toDisassociatePermission(): this;
    /**
     * Grants permission to get an application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_GetApplication.html
     */
    toGetApplication(): this;
    /**
     * Grants permission to get chat controls configuration for an application
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_GetChatControlsConfiguration.html
     */
    toGetChatControlsConfiguration(): this;
    /**
     * Grants permission to get a chat response configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_GetChatResponseConfiguration.html
     */
    toGetChatResponseConfiguration(): this;
    /**
     * Grants permission to get DataAccessor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_GetDataAccessor.html
     */
    toGetDataAccessor(): this;
    /**
     * Grants permission to get a data source
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_GetDataSource.html
     */
    toGetDataSource(): this;
    /**
     * Grants permission to get a document content
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_GetDocumentContent.html
     */
    toGetDocumentContent(): this;
    /**
     * Grants permission to get a group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_GetGroup.html
     */
    toGetGroup(): this;
    /**
     * Grants permission to get an index
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_GetIndex.html
     */
    toGetIndex(): this;
    /**
     * Grants permission to get an integration for a Q Business application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_GetIntegration.html
     */
    toGetIntegration(): this;
    /**
     * Grants permission to get the media associated to a system message
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_GetMedia.html
     */
    toGetMedia(): this;
    /**
     * Grants permission to get a plugin
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_GetPlugin.html
     */
    toGetPlugin(): this;
    /**
     * Grants permission to get resource based policy of the application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_GetPolicy.html
     */
    toGetPolicy(): this;
    /**
     * Grants permission to get a retriever
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_GetRetriever.html
     */
    toGetRetriever(): this;
    /**
     * Grants permission to get a user
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_GetUser.html
     */
    toGetUser(): this;
    /**
     * Grants permission to get a web-experience
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_GetWebExperience.html
     */
    toGetWebExperience(): this;
    /**
     * Grants permission to list the applications
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ListApplications.html
     */
    toListApplications(): this;
    /**
     * Grants permission to list attachments in the current chat context
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ListAttachments.html
     */
    toListAttachments(): this;
    /**
     * Grants permission to list chat response configurations for an application
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ListChatResponseConfigurations.html
     */
    toListChatResponseConfigurations(): this;
    /**
     * Grants permission to list all conversations for an application
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ListConversations.html
     */
    toListConversations(): this;
    /**
     * Grants permission to list DataAccessors for the application
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ListDataAccessors.html
     */
    toListDataAccessors(): this;
    /**
     * Grants permission to get Data Source sync job history
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ListDataSourceSyncJobs.html
     */
    toListDataSourceSyncJobs(): this;
    /**
     * Grants permission to list the data sources of an application and an index
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ListDataSources.html
     */
    toListDataSources(): this;
    /**
     * Grants permission to list all documents
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ListDocuments.html
     */
    toListDocuments(): this;
    /**
     * Grants permission to list groups
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ListGroups.html
     */
    toListGroups(): this;
    /**
     * Grants permission to list the indices of an application
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ListIndices.html
     */
    toListIndices(): this;
    /**
     * Grants permission to list all integrations for a Q Business application
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ListIntegrations.html
     */
    toListIntegrations(): this;
    /**
     * Grants permission to list all messages
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ListMessages.html
     */
    toListMessages(): this;
    /**
     * Grants permission to list the plugins actions of a plugin within application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ListPluginActions.html
     */
    toListPluginActions(): this;
    /**
     * Grants permission to list all the actions for a plugin type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ListPluginTypeActions.html
     */
    toListPluginTypeActions(): this;
    /**
     * Grants permission to list all the plugin type metadata
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ListPluginTypeMetadata.html
     */
    toListPluginTypeMetadata(): this;
    /**
     * Grants permission to list the plugins of an application
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ListPlugins.html
     */
    toListPlugins(): this;
    /**
     * Grants permission to list the retrievers of an application
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ListRetrievers.html
     */
    toListRetrievers(): this;
    /**
     * Grants permission to list subscriptions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ListSubscriptions.html
     */
    toListSubscriptions(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list the web experiences of an application
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ListWebExperiences.html
     */
    toListWebExperiences(): this;
    /**
     * Grants permission to put feedback about a conversation message
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_PutFeedback.html
     */
    toPutFeedback(): this;
    /**
     * Grants permission to put a group of users
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_PutGroup.html
     */
    toPutGroup(): this;
    /**
     * Grants permission to put resource based policy statement to the application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_AssociatePermission.html
     */
    toPutResourcePolicy(): this;
    /**
     * Grants permission to search relevant content from the Amazon Q Business Application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_SearchRelevantContent.html
     */
    toSearchRelevantContent(): this;
    /**
     * Grants permission to start Data Source sync job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_StartDataSourceSyncJob.html
     */
    toStartDataSourceSyncJob(): this;
    /**
     * Grants permission to start deployment for an integration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_StartDeployment.html
     */
    toStartDeployment(): this;
    /**
     * Grants permission to stop Data Source sync job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_StopDataSourceSyncJob.html
     */
    toStopDataSourceSyncJob(): this;
    /**
     * Grants permission to tag a resource with given key value pairs
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove the tag with the given key from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an Application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdateApplication.html
     */
    toUpdateApplication(): this;
    /**
     * Grants permission to update chat controls configuration for an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdateChatControlsConfiguration.html
     */
    toUpdateChatControlsConfiguration(): this;
    /**
     * Grants permission to update a chat response configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdateChatResponseConfiguration.html
     */
    toUpdateChatResponseConfiguration(): this;
    /**
     * Grants permission to update DataAccessor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdateDataAccessor.html
     */
    toUpdateDataAccessor(): this;
    /**
     * Grants permission to update a DataSource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdateDataSource.html
     */
    toUpdateDataSource(): this;
    /**
     * Grants permission to update an index
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdateIndex.html
     */
    toUpdateIndex(): this;
    /**
     * Grants permission to update an integration for a Q Business application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdateIntegration.html
     */
    toUpdateIntegration(): this;
    /**
     * Grants permission to update a plugin
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdatePlugin.html
     */
    toUpdatePlugin(): this;
    /**
     * Grants permission to update a Retriever
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdateRetriever.html
     */
    toUpdateRetriever(): this;
    /**
     * Grants permission to update a subscription
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdateSubscription.html
     */
    toUpdateSubscription(): this;
    /**
     * Grants permission to update a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdateUser.html
     */
    toUpdateUser(): this;
    /**
     * Grants permission to update a WebExperience
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdateWebExperience.html
     */
    toUpdateWebExperience(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type application to the statement
     *
     * https://docs.aws.amazon.com/amazonq/latest/business-use-dg/create-application.html
     *
     * @param applicationId - Identifier for the applicationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApplication(applicationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type integration to the statement
     *
     * https://docs.aws.amazon.com/amazonq/latest/business-use-dg/create-integration.html
     *
     * @param applicationId - Identifier for the applicationId.
     * @param integrationId - Identifier for the integrationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onIntegration(applicationId: string, integrationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type retriever to the statement
     *
     * https://docs.aws.amazon.com/amazonq/latest/business-use-dg/select-retriever.html
     *
     * @param applicationId - Identifier for the applicationId.
     * @param retrieverId - Identifier for the retrieverId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRetriever(applicationId: string, retrieverId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type index to the statement
     *
     * https://docs.aws.amazon.com/amazonq/latest/business-use-dg/select-retriever.html
     *
     * @param applicationId - Identifier for the applicationId.
     * @param indexId - Identifier for the indexId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onIndex(applicationId: string, indexId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type data-source to the statement
     *
     * https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connect-data.html
     *
     * @param applicationId - Identifier for the applicationId.
     * @param indexId - Identifier for the indexId.
     * @param dataSourceId - Identifier for the dataSourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDataSource(applicationId: string, indexId: string, dataSourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type plugin to the statement
     *
     * https://docs.aws.amazon.com/amazonq/latest/business-use-dg/plugins.html
     *
     * @param applicationId - Identifier for the applicationId.
     * @param pluginId - Identifier for the pluginId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPlugin(applicationId: string, pluginId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type web-experience to the statement
     *
     * https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html
     *
     * @param applicationId - Identifier for the applicationId.
     * @param webExperienceId - Identifier for the webExperienceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWebExperience(applicationId: string, webExperienceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type subscription to the statement
     *
     * https://docs.aws.amazon.com/amazonq/latest/business-use-dg/subscriptions.html
     *
     * @param applicationId - Identifier for the applicationId.
     * @param subscriptionId - Identifier for the subscriptionId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSubscription(applicationId: string, subscriptionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type data-accessor to the statement
     *
     * https://docs.aws.amazon.com/amazonq/latest/business-use-dg/data-accessors.html
     *
     * @param applicationId - Identifier for the applicationId.
     * @param dataAccessorId - Identifier for the dataAccessorId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDataAccessor(applicationId: string, dataAccessorId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type chat-response-configuration to the statement
     *
     * https://docs.aws.amazon.com/amazonq/latest/business-use-dg/response-customization.html
     *
     * @param applicationId - Identifier for the applicationId.
     * @param chatResponseConfigurationId - Identifier for the chatResponseConfigurationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onChatResponseConfiguration(applicationId: string, chatResponseConfigurationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateApplication()
     * - .toCreateChatResponseConfiguration()
     * - .toCreateDataAccessor()
     * - .toCreateDataSource()
     * - .toCreateIndex()
     * - .toCreateIntegration()
     * - .toCreatePlugin()
     * - .toCreateRetriever()
     * - .toCreateWebExperience()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toAllowVendedLogDeliveryForResource()
     *
     * Applies to resource types:
     * - application
     * - integration
     * - retriever
     * - index
     * - data-source
     * - plugin
     * - web-experience
     * - data-accessor
     * - chat-response-configuration
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateApplication()
     * - .toCreateChatResponseConfiguration()
     * - .toCreateDataAccessor()
     * - .toCreateDataSource()
     * - .toCreateIndex()
     * - .toCreateIntegration()
     * - .toCreatePlugin()
     * - .toCreateRetriever()
     * - .toCreateWebExperience()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by IAM Identity Center Group ID
     *
     * https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/security_iam_service-with-iam.html
     *
     * Applies to actions:
     * - .toCreateSubscription()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifIdentitystoreGroupId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by IAM Identity Center User ID
     *
     * https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/security_iam_service-with-iam.html
     *
     * Applies to actions:
     * - .toCreateSubscription()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifIdentitystoreUserId(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [qbusiness](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonqbusiness.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
