import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [qapps](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonqbusinessqapps.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Qapps extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to associate a library item review in the Q Business application environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserIsAppOwner()
     * - .ifAppIsPublished()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_AssociateLibraryItemReview.html
     */
    toAssociateLibraryItemReview(): this;
    /**
     * Grants permission to associate Q App with a user in the Q Business application environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserIsAppOwner()
     * - .ifAppIsPublished()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_AssociateQAppWithUser.html
     */
    toAssociateQAppWithUser(): this;
    /**
     * Grants permission to create the categories of a library in the Q Business application environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_BatchCreateCategory.html
     */
    toBatchCreateCategory(): this;
    /**
     * Grants permission to delete the categories of a library in the Q Business application environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_BatchDeleteCategory.html
     */
    toBatchDeleteCategory(): this;
    /**
     * Grants permission to update the categories of a library in the Q Business application environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_BatchUpdateCategory.html
     */
    toBatchUpdateCategory(): this;
    /**
     * Grants permission to copy Q App in the Q Business application environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserIsAppOwner()
     * - .ifAppIsPublished()
     *
     * https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/purpose-built-qapps.html
     */
    toCopyQApp(): this;
    /**
     * Grants permission to create a library item in the Q Business application environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserIsAppOwner()
     * - .ifAppIsPublished()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_CreateLibraryItem.html
     */
    toCreateLibraryItem(): this;
    /**
     * Grants permission to create a library item review in the Q Business application environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserIsAppOwner()
     * - .ifAppIsPublished()
     *
     * https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/purpose-built-qapps.html
     */
    toCreateLibraryItemReview(): this;
    /**
     * Grants permission to create Q App in the Q Business application environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_CreateQApp.html
     */
    toCreateQApp(): this;
    /**
     * Grants permission to subscribe to a Q App event bus topic in the Q Business application environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/purpose-built-qapps.html
     */
    toCreateSubscriptionToken(): this;
    /**
     * Grants permission to delete a library item in the Q Business application environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserIsAppOwner()
     * - .ifAppIsPublished()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_DeleteLibraryItem.html
     */
    toDeleteLibraryItem(): this;
    /**
     * Grants permission to delete Q App in the Q Business application environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserIsAppOwner()
     * - .ifAppIsPublished()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_DeleteQApp.html
     */
    toDeleteQApp(): this;
    /**
     * Grants permission to get Q App sharing permissions in the Q Business application environment
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserIsAppOwner()
     * - .ifAppIsPublished()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_DescribeQAppPermissions.html
     */
    toDescribeQAppPermissions(): this;
    /**
     * Grants permission to disassociate a library item review in the Q Business application environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserIsAppOwner()
     * - .ifAppIsPublished()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_DisassociateLibraryItemReview.html
     */
    toDisassociateLibraryItemReview(): this;
    /**
     * Grants permission to disassociate Q App with a user in the Q Business application environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserIsAppOwner()
     * - .ifAppIsPublished()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_DisassociateQAppFromUser.html
     */
    toDisassociateQAppFromUser(): this;
    /**
     * Grants permission to export Q App session data in the Q Business application environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/purpose-built-qapps.html
     */
    toExportQAppSessionData(): this;
    /**
     * Grants permission to get a library item in the Q Business application environment
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserIsAppOwner()
     * - .ifAppIsPublished()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_GetLibraryItem.html
     */
    toGetLibraryItem(): this;
    /**
     * Grants permission to get Q App in the Q Business application environment
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserIsAppOwner()
     * - .ifAppIsPublished()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_GetQApp.html
     */
    toGetQApp(): this;
    /**
     * Grants permission to get Q App session in the Q Business application environment
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifUserIsAppOwner()
     * - .ifAppIsPublished()
     * - .ifUserIsSessionModerator()
     * - .ifSessionIsShared()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_GetQAppSession.html
     */
    toGetQAppSession(): this;
    /**
     * Grants permission to get Q App session metadata in the Q Business application environment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/purpose-built-qapps.html
     */
    toGetQAppSessionMetadata(): this;
    /**
     * Grants permission to import a document to Q App or Q App Session in the Q Business application environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserIsAppOwner()
     * - .ifAppIsPublished()
     * - .ifUserIsSessionModerator()
     * - .ifSessionIsShared()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_ImportDocument.html
     */
    toImportDocument(): this;
    /**
     * Grants permission to list categories in the Q Business application environment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_ListCategories.html
     */
    toListCategories(): this;
    /**
     * Grants permission to list library items in the Q Business application environment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_ListLibraryItems.html
     */
    toListLibraryItems(): this;
    /**
     * Grants permission to get Q App session data in the Q Business application environment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/purpose-built-qapps.html
     */
    toListQAppSessionData(): this;
    /**
     * Grants permission to list Q Apps in the Q Business application environment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_ListQApps.html
     */
    toListQApps(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to predict problem statement from conversation log in the Q Business application environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/purpose-built-qapps.html
     */
    toPredictProblemStatementFromConversation(): this;
    /**
     * Grants permission to predict Q App from conversation log or problem statement in the Q Business application environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_PredictQApp.html
     */
    toPredictQApp(): this;
    /**
     * Grants permission to predict Q App metadata from problem statement in the Q Business application environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/purpose-built-qapps.html
     */
    toPredictQAppFromProblemStatement(): this;
    /**
     * Grants permission to start Q App session in the Q Business application environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserIsAppOwner()
     * - .ifAppIsPublished()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_StartQAppSession.html
     */
    toStartQAppSession(): this;
    /**
     * Grants permission to stop Q App session in the Q Business application environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserIsAppOwner()
     * - .ifAppIsPublished()
     * - .ifUserIsSessionModerator()
     * - .ifSessionIsShared()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_StopQAppSession.html
     */
    toStopQAppSession(): this;
    /**
     * Grants permission to tag a resource with given key value pairs
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove the tag with the given key from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a library item in the Q Business application environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserIsAppOwner()
     * - .ifAppIsPublished()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_UpdateLibraryItem.html
     */
    toUpdateLibraryItem(): this;
    /**
     * Grants permission to update the metadata of a library item in the Q Business application environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAppIsPublished()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_UpdateLibraryItemMetadata.html
     */
    toUpdateLibraryItemMetadata(): this;
    /**
     * Grants permission to update Q App in the Q Business application environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserIsAppOwner()
     * - .ifAppIsPublished()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_UpdateQApp.html
     */
    toUpdateQApp(): this;
    /**
     * Grants permission to update Q App sharing permissions in the Q Business application environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserIsAppOwner()
     * - .ifAppIsPublished()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_UpdateQAppPermissions.html
     */
    toUpdateQAppPermissions(): this;
    /**
     * Grants permission to update Q App session in the Q Business application environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserIsAppOwner()
     * - .ifAppIsPublished()
     * - .ifUserIsSessionModerator()
     * - .ifSessionIsShared()
     *
     * https://docs.aws.amazon.com/amazonq/latest/api-reference/API_qapps_UpdateQAppSession.html
     */
    toUpdateQAppSession(): this;
    /**
     * Grants permission to update Q App session metadata in the Q Business application environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/purpose-built-qapps.html
     */
    toUpdateQAppSessionMetadata(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type application to the statement
     *
     * https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/create-app.html
     *
     * @param applicationId - Identifier for the applicationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onApplication(applicationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type qapp to the statement
     *
     * https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/purpose-built-qapps.html
     *
     * @param applicationId - Identifier for the applicationId.
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onQapp(applicationId: string, appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type qapp-session to the statement
     *
     * https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/purpose-built-qapps.html
     *
     * @param applicationId - Identifier for the applicationId.
     * @param appId - Identifier for the appId.
     * @param sessionId - Identifier for the sessionId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onQappSession(applicationId: string, appId: string, sessionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateQApp()
     * - .toStartQAppSession()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - qapp
     * - qapp-session
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateQApp()
     * - .toStartQAppSession()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by whether Q App is published
     *
     * https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/security-iam.html
     *
     * Applies to actions:
     * - .toAssociateLibraryItemReview()
     * - .toAssociateQAppWithUser()
     * - .toCopyQApp()
     * - .toCreateLibraryItem()
     * - .toCreateLibraryItemReview()
     * - .toDeleteLibraryItem()
     * - .toDeleteQApp()
     * - .toDescribeQAppPermissions()
     * - .toDisassociateLibraryItemReview()
     * - .toDisassociateQAppFromUser()
     * - .toGetLibraryItem()
     * - .toGetQApp()
     * - .toGetQAppSession()
     * - .toImportDocument()
     * - .toStartQAppSession()
     * - .toStopQAppSession()
     * - .toUpdateLibraryItem()
     * - .toUpdateLibraryItemMetadata()
     * - .toUpdateQApp()
     * - .toUpdateQAppPermissions()
     * - .toUpdateQAppSession()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAppIsPublished(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by whether Q App Session is shared
     *
     * https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/security-iam.html
     *
     * Applies to actions:
     * - .toGetQAppSession()
     * - .toImportDocument()
     * - .toStopQAppSession()
     * - .toUpdateQAppSession()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSessionIsShared(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by whether requester is Q App owner
     *
     * https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/security-iam.html
     *
     * Applies to actions:
     * - .toAssociateLibraryItemReview()
     * - .toAssociateQAppWithUser()
     * - .toCopyQApp()
     * - .toCreateLibraryItem()
     * - .toCreateLibraryItemReview()
     * - .toDeleteLibraryItem()
     * - .toDeleteQApp()
     * - .toDescribeQAppPermissions()
     * - .toDisassociateLibraryItemReview()
     * - .toDisassociateQAppFromUser()
     * - .toGetLibraryItem()
     * - .toGetQApp()
     * - .toGetQAppSession()
     * - .toImportDocument()
     * - .toStartQAppSession()
     * - .toStopQAppSession()
     * - .toUpdateLibraryItem()
     * - .toUpdateQApp()
     * - .toUpdateQAppPermissions()
     * - .toUpdateQAppSession()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifUserIsAppOwner(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by whether requester is Q App Session moderator
     *
     * https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/security-iam.html
     *
     * Applies to actions:
     * - .toGetQAppSession()
     * - .toImportDocument()
     * - .toStopQAppSession()
     * - .toUpdateQAppSession()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifUserIsSessionModerator(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [qapps](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonqbusinessqapps.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
