import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [wisdom](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonqinconnect.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Wisdom extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to activate a message template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ActivateMessageTemplate.html
     */
    toActivateMessageTemplate(): this;
    /**
     * Grants permission to configure vended log delivery for an assistant
     *
     * Access Level: Permissions management
     */
    toAllowVendedLogDeliveryForResource(): this;
    /**
     * Grants permission to create an ai agent
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateAIAgent.html
     */
    toCreateAIAgent(): this;
    /**
     * Grants permission to create an ai agent version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateAIAgentVersion.html
     */
    toCreateAIAgentVersion(): this;
    /**
     * Grants permission to create an ai guardrail
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateAIGuardrail.html
     */
    toCreateAIGuardrail(): this;
    /**
     * Grants permission to create an ai guardrail version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateAIGuardrailVersion.html
     */
    toCreateAIGuardrailVersion(): this;
    /**
     * Grants permission to create an ai prompt
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateAIPrompt.html
     */
    toCreateAIPrompt(): this;
    /**
     * Grants permission to create an ai prompt version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateAIPromptVersion.html
     */
    toCreateAIPromptVersion(): this;
    /**
     * Grants permission to create an assistant
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateAssistant.html
     */
    toCreateAssistant(): this;
    /**
     * Grants permission to create an association between an assistant and another resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateAssistantAssociation.html
     */
    toCreateAssistantAssociation(): this;
    /**
     * Grants permission to create content
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateContent.html
     */
    toCreateContent(): this;
    /**
     * Grants permission to create a content association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateContentAssociation.html
     */
    toCreateContentAssociation(): this;
    /**
     * Grants permission to create a knowledge base
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateKnowledgeBase.html
     */
    toCreateKnowledgeBase(): this;
    /**
     * Grants permission to create a message template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateMessageTemplate.html
     */
    toCreateMessageTemplate(): this;
    /**
     * Grants permission to create an attachment to a message template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateMessageTemplateAttachment.html
     */
    toCreateMessageTemplateAttachment(): this;
    /**
     * Grants permission to create a version of a message template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateMessageTemplateVersion.html
     */
    toCreateMessageTemplateVersion(): this;
    /**
     * Grants permission to create quick response
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateQuickResponse.html
     */
    toCreateQuickResponse(): this;
    /**
     * Grants permission to create a session
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateSession.html
     */
    toCreateSession(): this;
    /**
     * Grants permission to deactivate a message template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeactivateMessageTemplate.html
     */
    toDeactivateMessageTemplate(): this;
    /**
     * Grants permission to delete an ai agent
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteAIAgent.html
     */
    toDeleteAIAgent(): this;
    /**
     * Grants permission to delete an ai agent version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteAIAgentVersion.html
     */
    toDeleteAIAgentVersion(): this;
    /**
     * Grants permission to delete an ai guardrail
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteAIGuardrail.html
     */
    toDeleteAIGuardrail(): this;
    /**
     * Grants permission to delete an ai guardrail version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteAIGuardrailVersion.html
     */
    toDeleteAIGuardrailVersion(): this;
    /**
     * Grants permission to delete an ai prompt
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteAIPrompt.html
     */
    toDeleteAIPrompt(): this;
    /**
     * Grants permission to delete an ai prompt version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteAIPromptVersion.html
     */
    toDeleteAIPromptVersion(): this;
    /**
     * Grants permission to delete an assistant
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteAssistant.html
     */
    toDeleteAssistant(): this;
    /**
     * Grants permission to delete an assistant association
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteAssistantAssociation.html
     */
    toDeleteAssistantAssociation(): this;
    /**
     * Grants permission to delete content
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteContent.html
     */
    toDeleteContent(): this;
    /**
     * Grants permission to delete a content association
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteContentAssociation.html
     */
    toDeleteContentAssociation(): this;
    /**
     * Grants permission to delete a import job of a knowledge base
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteImportJob.html
     */
    toDeleteImportJob(): this;
    /**
     * Grants permission to delete a knowledge base
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteKnowledgeBase.html
     */
    toDeleteKnowledgeBase(): this;
    /**
     * Grants permission to delete a message template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteMessageTemplate.html
     */
    toDeleteMessageTemplate(): this;
    /**
     * Grants permission to delete an attachment from a message template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteMessageTemplateAttachment.html
     */
    toDeleteMessageTemplateAttachment(): this;
    /**
     * Grants permission to delete quick response
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteQuickResponse.html
     */
    toDeleteQuickResponse(): this;
    /**
     * Grants permission to retrieve information about an ai agent
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetAIAgent.html
     */
    toGetAIAgent(): this;
    /**
     * Grants permission to retrieve information about an ai guardrail
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetAIGuardrail.html
     */
    toGetAIGuardrail(): this;
    /**
     * Grants permission to retrieve information about an ai prompt
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetAIPrompt.html
     */
    toGetAIPrompt(): this;
    /**
     * Grants permission to retrieve information about an assistant
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetAssistant.html
     */
    toGetAssistant(): this;
    /**
     * Grants permission to retrieve information about an assistant association
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetAssistantAssociation.html
     */
    toGetAssistantAssociation(): this;
    /**
     * Grants permission to retrieve content, including a pre-signed URL to download the content
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetContent.html
     */
    toGetContent(): this;
    /**
     * Grants permission to retrieve information about a content association
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetContentAssociation.html
     */
    toGetContentAssociation(): this;
    /**
     * Grants permission to retrieve summary information about the content
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetContentSummary.html
     */
    toGetContentSummary(): this;
    /**
     * Grants permission to retrieve information about the import job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetImportJob.html
     */
    toGetImportJob(): this;
    /**
     * Grants permission to retrieve information about the knowledge base
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetKnowledgeBase.html
     */
    toGetKnowledgeBase(): this;
    /**
     * Grants permission to retrieve a message template
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifMessageTemplateRoutingProfileArn()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetMessageTemplate.html
     */
    toGetMessageTemplate(): this;
    /**
     * Grants permission to retrieve for next message in a session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetNextMessage.html
     */
    toGetNextMessage(): this;
    /**
     * Grants permission to retrieve content
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetQuickResponse.html
     */
    toGetQuickResponse(): this;
    /**
     * Grants permission to retrieve recommendations for the specified session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetRecommendations.html
     */
    toGetRecommendations(): this;
    /**
     * Grants permission to retrieve information for a specified session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetSession.html
     */
    toGetSession(): this;
    /**
     * Grants permission to list information about ai agent versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListAIAgentVersions.html
     */
    toListAIAgentVersions(): this;
    /**
     * Grants permission to list information about ai agents
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListAIAgents.html
     */
    toListAIAgents(): this;
    /**
     * Grants permission to list information about ai guardrail versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListAIGuardrailVersions.html
     */
    toListAIGuardrailVersions(): this;
    /**
     * Grants permission to list information about ai guardrails
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListAIGuardrails.html
     */
    toListAIGuardrails(): this;
    /**
     * Grants permission to list information about ai prompt versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListAIPromptVersions.html
     */
    toListAIPromptVersions(): this;
    /**
     * Grants permission to list information about ai prompts
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListAIPrompts.html
     */
    toListAIPrompts(): this;
    /**
     * Grants permission to list information about assistant associations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListAssistantAssociations.html
     */
    toListAssistantAssociations(): this;
    /**
     * Grants permission to list information about assistants
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListAssistants.html
     */
    toListAssistants(): this;
    /**
     * Grants permission to list information about content associations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListContentAssociations.html
     */
    toListContentAssociations(): this;
    /**
     * Grants permission to list the content with a knowledge base
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListContents.html
     */
    toListContents(): this;
    /**
     * Grants permission to list information about knowledge bases
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListImportJobs.html
     */
    toListImportJobs(): this;
    /**
     * Grants permission to list information about knowledge bases
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListKnowledgeBases.html
     */
    toListKnowledgeBases(): this;
    /**
     * Grants permission to list message template versions for the specified message template
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListMessageTemplateVersions.html
     */
    toListMessageTemplateVersions(): this;
    /**
     * Grants permission to list the message templates for a knowledge base
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListMessageTemplates.html
     */
    toListMessageTemplates(): this;
    /**
     * Grants permission to list messages in a session
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListMessages.html
     */
    toListMessages(): this;
    /**
     * Grants permission to list the quick response with a knowledge base
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListQuickResponses.html
     */
    toListQuickResponses(): this;
    /**
     * Grants permission to list the tags for the specified resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to remove the specified recommendations from the specified assistant's queue of newly available recommendations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_NotifyRecommendationsReceived.html
     */
    toNotifyRecommendationsReceived(): this;
    /**
     * Grants permission to submit feedback
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_PutFeedback.html
     */
    toPutFeedback(): this;
    /**
     * Grants permission to perform a manual search against the specified assistant
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_QueryAssistant.html
     */
    toQueryAssistant(): this;
    /**
     * Grants permission to remove an ai agent from an assistant
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_RemoveAssistantAIAgent.html
     */
    toRemoveAssistantAIAgent(): this;
    /**
     * Grants permission to remove a URI template from a knowledge base
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_RemoveKnowledgeBaseTemplateUri.html
     */
    toRemoveKnowledgeBaseTemplateUri(): this;
    /**
     * Grants permission to render a message template
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifMessageTemplateRoutingProfileArn()
     *
     * Dependent actions:
     * - wisdom:GetMessageTemplate
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_RenderMessageTemplate.html
     */
    toRenderMessageTemplate(): this;
    /**
     * Grants permission to retrieve knowledge content from specified assistant associations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_Retrieve.html
     */
    toRetrieve(): this;
    /**
     * Grants permission to search for content referencing a specified knowledge base. Can be used to get a specific content resource by its name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SearchContent.html
     */
    toSearchContent(): this;
    /**
     * Grants permission to search for message templates referencing a specified knowledge base
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifSearchFilterRoutingProfileArn()
     * - .ifSearchFilterQualifier()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SearchMessageTemplates.html
     */
    toSearchMessageTemplates(): this;
    /**
     * Grants permission to search for quick response referencing a specified knowledge base
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifSearchFilterRoutingProfileArn()
     *
     * Dependent actions:
     * - wisdom:GetQuickResponse
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SearchQuickResponses.html
     */
    toSearchQuickResponses(): this;
    /**
     * Grants permission to search for sessions referencing a specified assistant. Can be used to et a specific session resource by its name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SearchSessions.html
     */
    toSearchSessions(): this;
    /**
     * Grants permission to send a message
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SendMessage.html
     */
    toSendMessage(): this;
    /**
     * Grants permission to get a URL to upload content to a knowledge base
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html
     */
    toStartContentUpload(): this;
    /**
     * Grants permission to create multiple quick responses
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartImportJob.html
     */
    toStartImportJob(): this;
    /**
     * Grants permission to add the specified tags to the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove the specified tags from the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update information about an ai agent
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateAIAgent.html
     */
    toUpdateAIAgent(): this;
    /**
     * Grants permission to update information about an ai guardrail
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateAIGuardrail.html
     */
    toUpdateAIGuardrail(): this;
    /**
     * Grants permission to update information about an ai prompt
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateAIPrompt.html
     */
    toUpdateAIPrompt(): this;
    /**
     * Grants permission to update assistant information about an ai agent
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateAssistantAIAgent.html
     */
    toUpdateAssistantAIAgent(): this;
    /**
     * Grants permission to update information about the content
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateContent.html
     */
    toUpdateContent(): this;
    /**
     * Grants permission to update the template URI of a knowledge base
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateKnowledgeBaseTemplateUri.html
     */
    toUpdateKnowledgeBaseTemplateUri(): this;
    /**
     * Grants permission to update content of the message template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateMessageTemplate.html
     */
    toUpdateMessageTemplate(): this;
    /**
     * Grants permission to update metadata of the message template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateMessageTemplateMetadata.html
     */
    toUpdateMessageTemplateMetadata(): this;
    /**
     * Grants permission to update information or content of the quick response
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateQuickResponse.html
     */
    toUpdateQuickResponse(): this;
    /**
     * Grants permission to update a session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateSession.html
     */
    toUpdateSession(): this;
    /**
     * Grants permission to update data stored in a session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateSessionData.html
     */
    toUpdateSessionData(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type AIAgent to the statement
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_AIAgentData.html
     *
     * @param assistantId - Identifier for the assistantId.
     * @param aIAgentId - Identifier for the aIAgentId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAIAgent(assistantId: string, aIAgentId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type AIPrompt to the statement
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_AIPromptData.html
     *
     * @param assistantId - Identifier for the assistantId.
     * @param aIPromptId - Identifier for the aIPromptId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAIPrompt(assistantId: string, aIPromptId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type AIGuardrail to the statement
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_AIGuardrailData.html
     *
     * @param assistantId - Identifier for the assistantId.
     * @param aIGuardrailId - Identifier for the aIGuardrailId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAIGuardrail(assistantId: string, aIGuardrailId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Assistant to the statement
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_AssistantData.html
     *
     * @param assistantId - Identifier for the assistantId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAssistant(assistantId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type AssistantAssociation to the statement
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_AssistantAssociationData.html
     *
     * @param assistantId - Identifier for the assistantId.
     * @param assistantAssociationId - Identifier for the assistantAssociationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAssistantAssociation(assistantId: string, assistantAssociationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Content to the statement
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ContentData.html
     *
     * @param knowledgeBaseId - Identifier for the knowledgeBaseId.
     * @param contentId - Identifier for the contentId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onContent(knowledgeBaseId: string, contentId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ContentAssociation to the statement
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ContentAssociationData.html
     *
     * @param knowledgeBaseId - Identifier for the knowledgeBaseId.
     * @param contentId - Identifier for the contentId.
     * @param contentAssociationId - Identifier for the contentAssociationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onContentAssociation(knowledgeBaseId: string, contentId: string, contentAssociationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type KnowledgeBase to the statement
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_KnowledgeBaseData.html
     *
     * @param knowledgeBaseId - Identifier for the knowledgeBaseId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onKnowledgeBase(knowledgeBaseId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type MessageTemplate to the statement
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_MessageTemplateData.html
     *
     * @param knowledgeBaseId - Identifier for the knowledgeBaseId.
     * @param messageTemplateId - Identifier for the messageTemplateId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifMessageTemplateRoutingProfileArn()
     */
    onMessageTemplate(knowledgeBaseId: string, messageTemplateId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Session to the statement
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SessionData.html
     *
     * @param assistantId - Identifier for the assistantId.
     * @param sessionId - Identifier for the sessionId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSession(assistantId: string, sessionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type QuickResponse to the statement
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_QuickResponseData.html
     *
     * @param knowledgeBaseId - Identifier for the knowledgeBaseId.
     * @param quickResponseId - Identifier for the quickResponseId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onQuickResponse(knowledgeBaseId: string, quickResponseId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateAIAgent()
     * - .toCreateAIAgentVersion()
     * - .toCreateAIGuardrail()
     * - .toCreateAIGuardrailVersion()
     * - .toCreateAIPrompt()
     * - .toCreateAIPromptVersion()
     * - .toCreateAssistant()
     * - .toCreateAssistantAssociation()
     * - .toCreateContent()
     * - .toCreateContentAssociation()
     * - .toCreateKnowledgeBase()
     * - .toCreateMessageTemplate()
     * - .toCreateQuickResponse()
     * - .toCreateSession()
     * - .toStartImportJob()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toTagResource()
     * - .toUntagResource()
     *
     * Applies to resource types:
     * - AIAgent
     * - AIPrompt
     * - AIGuardrail
     * - Assistant
     * - AssistantAssociation
     * - Content
     * - ContentAssociation
     * - KnowledgeBase
     * - MessageTemplate
     * - Session
     * - QuickResponse
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateAIAgent()
     * - .toCreateAIAgentVersion()
     * - .toCreateAIGuardrail()
     * - .toCreateAIGuardrailVersion()
     * - .toCreateAIPrompt()
     * - .toCreateAIPromptVersion()
     * - .toCreateAssistant()
     * - .toCreateAssistantAssociation()
     * - .toCreateContent()
     * - .toCreateContentAssociation()
     * - .toCreateKnowledgeBase()
     * - .toCreateMessageTemplate()
     * - .toCreateQuickResponse()
     * - .toCreateSession()
     * - .toStartImportJob()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the connect routing profile arns associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonconnectwisdom.html#amazonconnectwisdom-policy-keys
     *
     * Applies to actions:
     * - .toGetMessageTemplate()
     * - .toRenderMessageTemplate()
     *
     * Applies to resource types:
     * - MessageTemplate
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifMessageTemplateRoutingProfileArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the qualifiers that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonconnectwisdom.html#amazonconnectwisdom-policy-keys
     *
     * Applies to actions:
     * - .toSearchMessageTemplates()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSearchFilterQualifier(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the connect routing profile arn that is passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonconnectwisdom.html#amazonconnectwisdom-policy-keys
     *
     * Applies to actions:
     * - .toSearchMessageTemplates()
     * - .toSearchQuickResponses()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifSearchFilterRoutingProfileArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [wisdom](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonqinconnect.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
