import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [repostspace](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsrepostprivate.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Repostspace extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to add a role to users and groups in a private re:Post channel in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/repostprivate/latest/APIReference/API_BatchAddChannelRoleToAccessors.html
     */
    toBatchAddChannelRoleToAccessors(): this;
    /**
     * Grants permission to add a role to users and groups in a private re:Post in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/repostprivate/latest/APIReference/API_BatchAddRole.html
     */
    toBatchAddRole(): this;
    /**
     * Grants permission to remove a role from users and groups in a private re:Post channel in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/repostprivate/latest/APIReference/API_BatchRemoveChannelRoleFromAccessors.html
     */
    toBatchRemoveChannelRoleFromAccessors(): this;
    /**
     * Grants permission to remove a role from users and groups in a private re:Post in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/repostprivate/latest/APIReference/API_BatchRemoveRole.html
     */
    toBatchRemoveRole(): this;
    /**
     * Grants permission to create a new channel in private re:Post in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/repostprivate/latest/APIReference/API_CreateChannel.html
     */
    toCreateChannel(): this;
    /**
     * Grants permission to create a new private re:Post in your account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/repostprivate/latest/APIReference/API_CreateSpace.html
     */
    toCreateSpace(): this;
    /**
     * Grants permission to delete a private re:Post from your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/repostprivate/latest/APIReference/API_DeleteSpace.html
     */
    toDeleteSpace(): this;
    /**
     * Grants permission to remove an administrator to a private re:Post in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/repostprivate/latest/APIReference/API_DeregisterAdmin.html
     */
    toDeregisterAdmin(): this;
    /**
     * Grants permission to get the description for a channel in private re:Post in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/repostprivate/latest/APIReference/API_GetChannel.html
     */
    toGetChannel(): this;
    /**
     * Grants permission to get the description for a private re:Post in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/repostprivate/latest/APIReference/API_GetSpace.html
     */
    toGetSpace(): this;
    /**
     * Grants permission to list all channels in a private re:Post in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/repostprivate/latest/APIReference/API_ListChannels.html
     */
    toListChannels(): this;
    /**
     * Grants permission to list all private re:Posts in your account
     *
     * Access Level: Read
     */
    toListSpaces(): this;
    /**
     * Grants permission to list the tags associated with a resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/repostprivate/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to add an administrator to a private re:Post in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/repostprivate/latest/APIReference/API_RegisterAdmin.html
     */
    toRegisterAdmin(): this;
    /**
     * Grants permission to send invites to users of a private re:Post in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/repostprivate/latest/APIReference/API_SendInvites.html
     */
    toSendInvites(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/repostprivate/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/repostprivate/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a channel in private re:Post in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/repostprivate/latest/APIReference/API_UpdateChannel.html
     */
    toUpdateChannel(): this;
    /**
     * Grants permission to update a private re:Post in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/repostprivate/latest/APIReference/API_UpdateSpace.html
     */
    toUpdateSpace(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type space to the statement
     *
     * https://docs.aws.amazon.com/repostprivate/latest/userguide/
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSpace(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the presence of tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateSpace()
     * - .toListTagsForResource()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - space
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the presence of tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateSpace()
     * - .toListTagsForResource()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [repostspace](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsrepostprivate.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
