import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [sagemaker-mlflow](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsagemakerwithmlflow.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class SagemakerMlflow extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to access the MLflow UI
     *
     * Access Level: Read
     */
    toAccessUI(): this;
    /**
     * Grants permission to create an MLflow experiment
     *
     * Access Level: Write
     */
    toCreateExperiment(): this;
    /**
     * Grants permission to create a new model version
     *
     * Access Level: Write
     */
    toCreateModelVersion(): this;
    /**
     * Grants permission to create a registered model
     *
     * Access Level: Write
     */
    toCreateRegisteredModel(): this;
    /**
     * Grants permission to create a new run within an experiment
     *
     * Access Level: Write
     */
    toCreateRun(): this;
    /**
     * Grants permission to mark an MLflow experiment for deletion
     *
     * Access Level: Write
     */
    toDeleteExperiment(): this;
    /**
     * Grants permission to delete a logged model in MLflow
     *
     * Access Level: Write
     */
    toDeleteLoggedModel(): this;
    /**
     * Grants permission to delete a tag for a logged model in MLflow
     *
     * Access Level: Write
     */
    toDeleteLoggedModelTag(): this;
    /**
     * Grants permission to delete a model version
     *
     * Access Level: Write
     */
    toDeleteModelVersion(): this;
    /**
     * Grants permission to delete a model version tag
     *
     * Access Level: Write
     */
    toDeleteModelVersionTag(): this;
    /**
     * Grants permission to delete a registered model
     *
     * Access Level: Write
     */
    toDeleteRegisteredModel(): this;
    /**
     * Grants permission to delete a registered model alias
     *
     * Access Level: Write
     */
    toDeleteRegisteredModelAlias(): this;
    /**
     * Grants permission to delete a registered model tag
     *
     * Access Level: Write
     */
    toDeleteRegisteredModelTag(): this;
    /**
     * Grants permission to mark a run for deletion
     *
     * Access Level: Write
     */
    toDeleteRun(): this;
    /**
     * Grants permission to delete a tag on a run
     *
     * Access Level: Write
     */
    toDeleteTag(): this;
    /**
     * Grants permission to delete a trace tag in MLflow
     *
     * Access Level: Write
     */
    toDeleteTraceTag(): this;
    /**
     * Grants permission to delete traces in MLflow
     *
     * Access Level: Write
     */
    toDeleteTraces(): this;
    /**
     * Grants permission to end a trace in MLflow
     *
     * Access Level: Write
     */
    toEndTrace(): this;
    /**
     * Grants permission to set status for a logged model in MLflow
     *
     * Access Level: Write
     */
    toFinalizeLoggedModel(): this;
    /**
     * Grants permission to get a URI to download model artifacts for a specific model version
     *
     * Access Level: Read
     */
    toGetDownloadURIForModelVersionArtifacts(): this;
    /**
     * Grants permission to get metadata for an MLflow experiment
     *
     * Access Level: Read
     */
    toGetExperiment(): this;
    /**
     * Grants permission to get metadata for an MLflow experiment by name
     *
     * Access Level: Read
     */
    toGetExperimentByName(): this;
    /**
     * Grants permission to get the latest model versions
     *
     * Access Level: List
     */
    toGetLatestModelVersions(): this;
    /**
     * Grants permission to get a logged model in MLflow
     *
     * Access Level: Read
     */
    toGetLoggedModel(): this;
    /**
     * Grants permission to get a list of all values for the specified metric for a given run
     *
     * Access Level: Read
     */
    toGetMetricHistory(): this;
    /**
     * Grants permission to get a model version by model name and version
     *
     * Access Level: Read
     */
    toGetModelVersion(): this;
    /**
     * Grants permission to get model version by alias in MLflow
     *
     * Access Level: Read
     */
    toGetModelVersionByAlias(): this;
    /**
     * Grants permission to get a registered model
     *
     * Access Level: Read
     */
    toGetRegisteredModel(): this;
    /**
     * Grants permission to get metadata, metrics, parameters, and tags for a run
     *
     * Access Level: Read
     */
    toGetRun(): this;
    /**
     * Grants permission to get information about a trace in MLflow
     *
     * Access Level: Read
     */
    toGetTraceInfo(): this;
    /**
     * Grants permission to list artifacts for a run
     *
     * Access Level: List
     */
    toListArtifacts(): this;
    /**
     * Grants permission to list artifacts for a logged model in MLflow
     *
     * Access Level: List
     */
    toListLoggedModelArtifacts(): this;
    /**
     * Grants permission to log a batch of metrics, parameters, and tags for a run
     *
     * Access Level: Write
     */
    toLogBatch(): this;
    /**
     * Grants permission to log inputs for a run
     *
     * Access Level: Write
     */
    toLogInputs(): this;
    /**
     * Grants permission to log params for a logged model in MLflow
     *
     * Access Level: Write
     */
    toLogLoggedModelParams(): this;
    /**
     * Grants permission to log a metric for a run
     *
     * Access Level: Write
     */
    toLogMetric(): this;
    /**
     * Grants permission to log the model associated with a run
     *
     * Access Level: Write
     */
    toLogModel(): this;
    /**
     * Grants permission to log outputs, such as models, for a run in MLflow
     *
     * Access Level: Write
     */
    toLogOutputs(): this;
    /**
     * Grants permission to log a parameter tracked during a run
     *
     * Access Level: Write
     */
    toLogParam(): this;
    /**
     * Grants permission to rename a registered model
     *
     * Access Level: Write
     */
    toRenameRegisteredModel(): this;
    /**
     * Grants permission to restore an experiment marked for deletion
     *
     * Access Level: Write
     */
    toRestoreExperiment(): this;
    /**
     * Grants permission to restore a deleted run
     *
     * Access Level: Write
     */
    toRestoreRun(): this;
    /**
     * Grants permission to search for MLflow experiments
     *
     * Access Level: Read
     */
    toSearchExperiments(): this;
    /**
     * Grants permission to search for logged models in MLflow
     *
     * Access Level: Read
     */
    toSearchLoggedModels(): this;
    /**
     * Grants permission to search for a model version
     *
     * Access Level: Read
     */
    toSearchModelVersions(): this;
    /**
     * Grants permission to search for registered models in MLflow
     *
     * Access Level: Read
     */
    toSearchRegisteredModels(): this;
    /**
     * Grants permission to search for runs that satisfy expressions
     *
     * Access Level: Read
     */
    toSearchRuns(): this;
    /**
     * Grants permission to search for traces in MLflow
     *
     * Access Level: Read
     */
    toSearchTraces(): this;
    /**
     * Grants permission to set a tag on an experiment
     *
     * Access Level: Write
     */
    toSetExperimentTag(): this;
    /**
     * Grants permission to set tags for a logged model in MLflow
     *
     * Access Level: Write
     */
    toSetLoggedModelTags(): this;
    /**
     * Grants permission to set a tag for the model version
     *
     * Access Level: Write
     */
    toSetModelVersionTag(): this;
    /**
     * Grants permission to set a registered model alias
     *
     * Access Level: Write
     */
    toSetRegisteredModelAlias(): this;
    /**
     * Grants permission to set a tag for a registered model
     *
     * Access Level: Write
     */
    toSetRegisteredModelTag(): this;
    /**
     * Grants permission to set a tag on a run
     *
     * Access Level: Write
     */
    toSetTag(): this;
    /**
     * Grants permission to set a trace tag in MLflow
     *
     * Access Level: Write
     */
    toSetTraceTag(): this;
    /**
     * Grants permission to start a trace in MLflow
     *
     * Access Level: Write
     */
    toStartTrace(): this;
    /**
     * Grants permission to transition a model version to a particular stage
     *
     * Access Level: Write
     */
    toTransitionModelVersionStage(): this;
    /**
     * Grants permission to update the metadata for an MLflow experiment
     *
     * Access Level: Write
     */
    toUpdateExperiment(): this;
    /**
     * Grants permission to update the model version
     *
     * Access Level: Write
     */
    toUpdateModelVersion(): this;
    /**
     * Grants permission to update a registered model
     *
     * Access Level: Write
     */
    toUpdateRegisteredModel(): this;
    /**
     * Grants permission to update run metadata
     *
     * Access Level: Write
     */
    toUpdateRun(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type mlflow-tracking-server to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_MlflowTrackingServer.html
     *
     * @param mlflowTrackingServerName - Identifier for the mlflowTrackingServerName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifSagemakerResourceTag()
     */
    onMlflowTrackingServer(mlflowTrackingServerName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by a tag key and value pair
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to resource types:
     * - mlflow-tracking-server
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a tag key and value pair
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to resource types:
     * - mlflow-tracking-server
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSagemakerResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [sagemaker-mlflow](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsagemakerwithmlflow.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
