"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SagemakerMlflow = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [sagemaker-mlflow](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsagemakerwithmlflow.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class SagemakerMlflow extends shared_1.PolicyStatement {
    /**
     * Grants permission to access the MLflow UI
     *
     * Access Level: Read
     */
    toAccessUI() {
        return this.to('AccessUI');
    }
    /**
     * Grants permission to create an MLflow experiment
     *
     * Access Level: Write
     */
    toCreateExperiment() {
        return this.to('CreateExperiment');
    }
    /**
     * Grants permission to create a new model version
     *
     * Access Level: Write
     */
    toCreateModelVersion() {
        return this.to('CreateModelVersion');
    }
    /**
     * Grants permission to create a registered model
     *
     * Access Level: Write
     */
    toCreateRegisteredModel() {
        return this.to('CreateRegisteredModel');
    }
    /**
     * Grants permission to create a new run within an experiment
     *
     * Access Level: Write
     */
    toCreateRun() {
        return this.to('CreateRun');
    }
    /**
     * Grants permission to mark an MLflow experiment for deletion
     *
     * Access Level: Write
     */
    toDeleteExperiment() {
        return this.to('DeleteExperiment');
    }
    /**
     * Grants permission to delete a logged model in MLflow
     *
     * Access Level: Write
     */
    toDeleteLoggedModel() {
        return this.to('DeleteLoggedModel');
    }
    /**
     * Grants permission to delete a tag for a logged model in MLflow
     *
     * Access Level: Write
     */
    toDeleteLoggedModelTag() {
        return this.to('DeleteLoggedModelTag');
    }
    /**
     * Grants permission to delete a model version
     *
     * Access Level: Write
     */
    toDeleteModelVersion() {
        return this.to('DeleteModelVersion');
    }
    /**
     * Grants permission to delete a model version tag
     *
     * Access Level: Write
     */
    toDeleteModelVersionTag() {
        return this.to('DeleteModelVersionTag');
    }
    /**
     * Grants permission to delete a registered model
     *
     * Access Level: Write
     */
    toDeleteRegisteredModel() {
        return this.to('DeleteRegisteredModel');
    }
    /**
     * Grants permission to delete a registered model alias
     *
     * Access Level: Write
     */
    toDeleteRegisteredModelAlias() {
        return this.to('DeleteRegisteredModelAlias');
    }
    /**
     * Grants permission to delete a registered model tag
     *
     * Access Level: Write
     */
    toDeleteRegisteredModelTag() {
        return this.to('DeleteRegisteredModelTag');
    }
    /**
     * Grants permission to mark a run for deletion
     *
     * Access Level: Write
     */
    toDeleteRun() {
        return this.to('DeleteRun');
    }
    /**
     * Grants permission to delete a tag on a run
     *
     * Access Level: Write
     */
    toDeleteTag() {
        return this.to('DeleteTag');
    }
    /**
     * Grants permission to delete a trace tag in MLflow
     *
     * Access Level: Write
     */
    toDeleteTraceTag() {
        return this.to('DeleteTraceTag');
    }
    /**
     * Grants permission to delete traces in MLflow
     *
     * Access Level: Write
     */
    toDeleteTraces() {
        return this.to('DeleteTraces');
    }
    /**
     * Grants permission to end a trace in MLflow
     *
     * Access Level: Write
     */
    toEndTrace() {
        return this.to('EndTrace');
    }
    /**
     * Grants permission to set status for a logged model in MLflow
     *
     * Access Level: Write
     */
    toFinalizeLoggedModel() {
        return this.to('FinalizeLoggedModel');
    }
    /**
     * Grants permission to get a URI to download model artifacts for a specific model version
     *
     * Access Level: Read
     */
    toGetDownloadURIForModelVersionArtifacts() {
        return this.to('GetDownloadURIForModelVersionArtifacts');
    }
    /**
     * Grants permission to get metadata for an MLflow experiment
     *
     * Access Level: Read
     */
    toGetExperiment() {
        return this.to('GetExperiment');
    }
    /**
     * Grants permission to get metadata for an MLflow experiment by name
     *
     * Access Level: Read
     */
    toGetExperimentByName() {
        return this.to('GetExperimentByName');
    }
    /**
     * Grants permission to get the latest model versions
     *
     * Access Level: List
     */
    toGetLatestModelVersions() {
        return this.to('GetLatestModelVersions');
    }
    /**
     * Grants permission to get a logged model in MLflow
     *
     * Access Level: Read
     */
    toGetLoggedModel() {
        return this.to('GetLoggedModel');
    }
    /**
     * Grants permission to get a list of all values for the specified metric for a given run
     *
     * Access Level: Read
     */
    toGetMetricHistory() {
        return this.to('GetMetricHistory');
    }
    /**
     * Grants permission to get a model version by model name and version
     *
     * Access Level: Read
     */
    toGetModelVersion() {
        return this.to('GetModelVersion');
    }
    /**
     * Grants permission to get model version by alias in MLflow
     *
     * Access Level: Read
     */
    toGetModelVersionByAlias() {
        return this.to('GetModelVersionByAlias');
    }
    /**
     * Grants permission to get a registered model
     *
     * Access Level: Read
     */
    toGetRegisteredModel() {
        return this.to('GetRegisteredModel');
    }
    /**
     * Grants permission to get metadata, metrics, parameters, and tags for a run
     *
     * Access Level: Read
     */
    toGetRun() {
        return this.to('GetRun');
    }
    /**
     * Grants permission to get information about a trace in MLflow
     *
     * Access Level: Read
     */
    toGetTraceInfo() {
        return this.to('GetTraceInfo');
    }
    /**
     * Grants permission to list artifacts for a run
     *
     * Access Level: List
     */
    toListArtifacts() {
        return this.to('ListArtifacts');
    }
    /**
     * Grants permission to list artifacts for a logged model in MLflow
     *
     * Access Level: List
     */
    toListLoggedModelArtifacts() {
        return this.to('ListLoggedModelArtifacts');
    }
    /**
     * Grants permission to log a batch of metrics, parameters, and tags for a run
     *
     * Access Level: Write
     */
    toLogBatch() {
        return this.to('LogBatch');
    }
    /**
     * Grants permission to log inputs for a run
     *
     * Access Level: Write
     */
    toLogInputs() {
        return this.to('LogInputs');
    }
    /**
     * Grants permission to log params for a logged model in MLflow
     *
     * Access Level: Write
     */
    toLogLoggedModelParams() {
        return this.to('LogLoggedModelParams');
    }
    /**
     * Grants permission to log a metric for a run
     *
     * Access Level: Write
     */
    toLogMetric() {
        return this.to('LogMetric');
    }
    /**
     * Grants permission to log the model associated with a run
     *
     * Access Level: Write
     */
    toLogModel() {
        return this.to('LogModel');
    }
    /**
     * Grants permission to log outputs, such as models, for a run in MLflow
     *
     * Access Level: Write
     */
    toLogOutputs() {
        return this.to('LogOutputs');
    }
    /**
     * Grants permission to log a parameter tracked during a run
     *
     * Access Level: Write
     */
    toLogParam() {
        return this.to('LogParam');
    }
    /**
     * Grants permission to rename a registered model
     *
     * Access Level: Write
     */
    toRenameRegisteredModel() {
        return this.to('RenameRegisteredModel');
    }
    /**
     * Grants permission to restore an experiment marked for deletion
     *
     * Access Level: Write
     */
    toRestoreExperiment() {
        return this.to('RestoreExperiment');
    }
    /**
     * Grants permission to restore a deleted run
     *
     * Access Level: Write
     */
    toRestoreRun() {
        return this.to('RestoreRun');
    }
    /**
     * Grants permission to search for MLflow experiments
     *
     * Access Level: Read
     */
    toSearchExperiments() {
        return this.to('SearchExperiments');
    }
    /**
     * Grants permission to search for logged models in MLflow
     *
     * Access Level: Read
     */
    toSearchLoggedModels() {
        return this.to('SearchLoggedModels');
    }
    /**
     * Grants permission to search for a model version
     *
     * Access Level: Read
     */
    toSearchModelVersions() {
        return this.to('SearchModelVersions');
    }
    /**
     * Grants permission to search for registered models in MLflow
     *
     * Access Level: Read
     */
    toSearchRegisteredModels() {
        return this.to('SearchRegisteredModels');
    }
    /**
     * Grants permission to search for runs that satisfy expressions
     *
     * Access Level: Read
     */
    toSearchRuns() {
        return this.to('SearchRuns');
    }
    /**
     * Grants permission to search for traces in MLflow
     *
     * Access Level: Read
     */
    toSearchTraces() {
        return this.to('SearchTraces');
    }
    /**
     * Grants permission to set a tag on an experiment
     *
     * Access Level: Write
     */
    toSetExperimentTag() {
        return this.to('SetExperimentTag');
    }
    /**
     * Grants permission to set tags for a logged model in MLflow
     *
     * Access Level: Write
     */
    toSetLoggedModelTags() {
        return this.to('SetLoggedModelTags');
    }
    /**
     * Grants permission to set a tag for the model version
     *
     * Access Level: Write
     */
    toSetModelVersionTag() {
        return this.to('SetModelVersionTag');
    }
    /**
     * Grants permission to set a registered model alias
     *
     * Access Level: Write
     */
    toSetRegisteredModelAlias() {
        return this.to('SetRegisteredModelAlias');
    }
    /**
     * Grants permission to set a tag for a registered model
     *
     * Access Level: Write
     */
    toSetRegisteredModelTag() {
        return this.to('SetRegisteredModelTag');
    }
    /**
     * Grants permission to set a tag on a run
     *
     * Access Level: Write
     */
    toSetTag() {
        return this.to('SetTag');
    }
    /**
     * Grants permission to set a trace tag in MLflow
     *
     * Access Level: Write
     */
    toSetTraceTag() {
        return this.to('SetTraceTag');
    }
    /**
     * Grants permission to start a trace in MLflow
     *
     * Access Level: Write
     */
    toStartTrace() {
        return this.to('StartTrace');
    }
    /**
     * Grants permission to transition a model version to a particular stage
     *
     * Access Level: Write
     */
    toTransitionModelVersionStage() {
        return this.to('TransitionModelVersionStage');
    }
    /**
     * Grants permission to update the metadata for an MLflow experiment
     *
     * Access Level: Write
     */
    toUpdateExperiment() {
        return this.to('UpdateExperiment');
    }
    /**
     * Grants permission to update the model version
     *
     * Access Level: Write
     */
    toUpdateModelVersion() {
        return this.to('UpdateModelVersion');
    }
    /**
     * Grants permission to update a registered model
     *
     * Access Level: Write
     */
    toUpdateRegisteredModel() {
        return this.to('UpdateRegisteredModel');
    }
    /**
     * Grants permission to update run metadata
     *
     * Access Level: Write
     */
    toUpdateRun() {
        return this.to('UpdateRun');
    }
    /**
     * Adds a resource of type mlflow-tracking-server to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_MlflowTrackingServer.html
     *
     * @param mlflowTrackingServerName - Identifier for the mlflowTrackingServerName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifSagemakerResourceTag()
     */
    onMlflowTrackingServer(mlflowTrackingServerName, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:sagemaker:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:mlflow-tracking-server/${mlflowTrackingServerName}`);
    }
    /**
     * Filters access by a tag key and value pair
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to resource types:
     * - mlflow-tracking-server
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey, value, operator) {
        return this.if(`aws:ResourceTag/${tagKey}`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by a tag key and value pair
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to resource types:
     * - mlflow-tracking-server
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSagemakerResourceTag(tagKey, value, operator) {
        return this.if(`sagemaker:ResourceTag/${tagKey}`, value, operator ?? 'StringLike');
    }
    /**
     * Statement provider for service [sagemaker-mlflow](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsagemakerwithmlflow.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'sagemaker-mlflow';
        this.accessLevelList = {
            Read: [
                'AccessUI',
                'GetDownloadURIForModelVersionArtifacts',
                'GetExperiment',
                'GetExperimentByName',
                'GetLoggedModel',
                'GetMetricHistory',
                'GetModelVersion',
                'GetModelVersionByAlias',
                'GetRegisteredModel',
                'GetRun',
                'GetTraceInfo',
                'SearchExperiments',
                'SearchLoggedModels',
                'SearchModelVersions',
                'SearchRegisteredModels',
                'SearchRuns',
                'SearchTraces'
            ],
            Write: [
                'CreateExperiment',
                'CreateModelVersion',
                'CreateRegisteredModel',
                'CreateRun',
                'DeleteExperiment',
                'DeleteLoggedModel',
                'DeleteLoggedModelTag',
                'DeleteModelVersion',
                'DeleteModelVersionTag',
                'DeleteRegisteredModel',
                'DeleteRegisteredModelAlias',
                'DeleteRegisteredModelTag',
                'DeleteRun',
                'DeleteTag',
                'DeleteTraceTag',
                'DeleteTraces',
                'EndTrace',
                'FinalizeLoggedModel',
                'LogBatch',
                'LogInputs',
                'LogLoggedModelParams',
                'LogMetric',
                'LogModel',
                'LogOutputs',
                'LogParam',
                'RenameRegisteredModel',
                'RestoreExperiment',
                'RestoreRun',
                'SetExperimentTag',
                'SetLoggedModelTags',
                'SetModelVersionTag',
                'SetRegisteredModelAlias',
                'SetRegisteredModelTag',
                'SetTag',
                'SetTraceTag',
                'StartTrace',
                'TransitionModelVersionStage',
                'UpdateExperiment',
                'UpdateModelVersion',
                'UpdateRegisteredModel',
                'UpdateRun'
            ],
            List: [
                'GetLatestModelVersions',
                'ListArtifacts',
                'ListLoggedModelArtifacts'
            ]
        };
    }
}
exports.SagemakerMlflow = SagemakerMlflow;
//# sourceMappingURL=data:application/json;base64,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