import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [securitylake](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsecuritylake.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Securitylake extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to enable any source type in any region for accounts that are either part of a trusted organization or standalone account
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - glue:CreateDatabase
     * - glue:CreateTable
     * - glue:GetDatabase
     * - glue:GetTable
     * - iam:CreateServiceLinkedRole
     * - kms:CreateGrant
     * - kms:DescribeKey
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateAwsLogSource.html
     */
    toCreateAwsLogSource(): this;
    /**
     * Grants permission to add a custom source
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - glue:CreateCrawler
     * - glue:CreateDatabase
     * - glue:CreateTable
     * - glue:StartCrawlerSchedule
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PassRole
     * - iam:PutRolePolicy
     * - kms:CreateGrant
     * - kms:DescribeKey
     * - kms:GenerateDataKey
     * - lakeformation:GrantPermissions
     * - lakeformation:RegisterResource
     * - s3:ListBucket
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateCustomLogSource.html
     */
    toCreateCustomLogSource(): this;
    /**
     * Grants permission to create a new security data lake
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - events:PutRule
     * - events:PutTargets
     * - iam:CreateServiceLinkedRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:ListAttachedRolePolicies
     * - iam:PassRole
     * - iam:PutRolePolicy
     * - kms:CreateGrant
     * - kms:DescribeKey
     * - lakeformation:GetDataLakeSettings
     * - lakeformation:PutDataLakeSettings
     * - lambda:AddPermission
     * - lambda:CreateEventSourceMapping
     * - lambda:CreateFunction
     * - organizations:DescribeOrganization
     * - organizations:ListAccounts
     * - organizations:ListDelegatedServicesForAccount
     * - s3:CreateBucket
     * - s3:GetObject
     * - s3:GetObjectVersion
     * - s3:ListBucket
     * - s3:PutBucketPolicy
     * - s3:PutBucketPublicAccessBlock
     * - s3:PutBucketVersioning
     * - sqs:CreateQueue
     * - sqs:GetQueueAttributes
     * - sqs:SetQueueAttributes
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDataLake.html
     */
    toCreateDataLake(): this;
    /**
     * Grants permission to get instant notifications about exceptions. Subscribes to the SNS topics for exception notifications
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDataLakeExceptionSubscription.html
     */
    toCreateDataLakeExceptionSubscription(): this;
    /**
     * Grants permission to automatically enable Amazon Security Lake for new member accounts in your organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDataLakeOrganizationConfiguration.html
     */
    toCreateDataLakeOrganizationConfiguration(): this;
    /**
     * Grants permission to create a subscriber
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:CreateRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PutRolePolicy
     * - lakeformation:GrantPermissions
     * - lakeformation:ListPermissions
     * - lakeformation:RegisterResource
     * - lakeformation:RevokePermissions
     * - ram:GetResourceShareAssociations
     * - ram:GetResourceShares
     * - ram:UpdateResourceShare
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateSubscriber.html
     */
    toCreateSubscriber(): this;
    /**
     * Grants permission to create a webhook invocation to notify a client when there is new data in the data lake
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:CreateApiDestination
     * - events:CreateConnection
     * - events:DescribeRule
     * - events:ListApiDestinations
     * - events:ListConnections
     * - events:PutRule
     * - events:PutTargets
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PassRole
     * - s3:GetBucketNotification
     * - s3:PutBucketNotification
     * - sqs:CreateQueue
     * - sqs:DeleteQueue
     * - sqs:GetQueueAttributes
     * - sqs:GetQueueUrl
     * - sqs:SetQueueAttributes
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateSubscriberNotification.html
     */
    toCreateSubscriberNotification(): this;
    /**
     * Grants permission to disable any source type in any region for accounts that are part of a trusted organization or standalone accounts
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteAwsLogSource.html
     */
    toDeleteAwsLogSource(): this;
    /**
     * Grants permission to remove a custom source
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - glue:StopCrawlerSchedule
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteCustomLogSource.html
     */
    toDeleteCustomLogSource(): this;
    /**
     * Grants permission to delete security data lake
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - organizations:DescribeOrganization
     * - organizations:ListDelegatedAdministrators
     * - organizations:ListDelegatedServicesForAccount
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteDataLake.html
     */
    toDeleteDataLake(): this;
    /**
     * Grants permission to unsubscribe from SNS topics for exception notifications. Removes exception notifications for the SNS topic
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteDataLakeExceptionSubscription.html
     */
    toDeleteDataLakeExceptionSubscription(): this;
    /**
     * Grants permission to remove the automatic enablement of Amazon Security Lake access for new organization accounts
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteDataLakeOrganizationConfiguration.html
     */
    toDeleteDataLakeOrganizationConfiguration(): this;
    /**
     * Grants permission to delete the specified subscriber
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:DeleteApiDestination
     * - events:DeleteConnection
     * - events:DeleteRule
     * - events:DescribeRule
     * - events:ListApiDestinations
     * - events:ListTargetsByRule
     * - events:RemoveTargets
     * - iam:DeleteRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:ListRolePolicies
     * - lakeformation:ListPermissions
     * - lakeformation:RevokePermissions
     * - sqs:DeleteQueue
     * - sqs:GetQueueUrl
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteSubscriber.html
     */
    toDeleteSubscriber(): this;
    /**
     * Grants permission to remove a webhook invocation to notify a client when there is new data in the data lake
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:DeleteApiDestination
     * - events:DeleteConnection
     * - events:DeleteRule
     * - events:DescribeRule
     * - events:ListApiDestinations
     * - events:ListTargetsByRule
     * - events:RemoveTargets
     * - iam:DeleteRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:ListRolePolicies
     * - lakeformation:RevokePermissions
     * - sqs:DeleteQueue
     * - sqs:GetQueueUrl
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeleteSubscriberNotification.html
     */
    toDeleteSubscriberNotification(): this;
    /**
     * Grants permission to remove the Delegated Administrator account and disable Amazon Security Lake as a service for this organization
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - organizations:DeregisterDelegatedAdministrator
     * - organizations:DescribeOrganization
     * - organizations:ListDelegatedServicesForAccount
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DeregisterDataLakeDelegatedAdministrator.html
     */
    toDeregisterDataLakeDelegatedAdministrator(): this;
    /**
     * Grants permission to query the protocol and endpoint that were provided when subscribing to SNS topics for exception notifications
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetDataLakeExceptionSubscription.html
     */
    toGetDataLakeExceptionSubscription(): this;
    /**
     * Grants permission to get an organization's configuration setting for automatically enabling Amazon Security Lake access for new organization accounts
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - organizations:DescribeOrganization
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetDataLakeOrganizationConfiguration.html
     */
    toGetDataLakeOrganizationConfiguration(): this;
    /**
     * Grants permission to get a static snapshot of the security data lake in the current region. The snapshot includes enabled accounts and log sources
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetDataLakeSources.html
     */
    toGetDataLakeSources(): this;
    /**
     * Grants permission to get information about subscriber that is already created
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_GetSubscriber.html
     */
    toGetSubscriber(): this;
    /**
     * Grants permission to get the list of all non-retryable failures
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_ListDataLakeExceptions.html
     */
    toListDataLakeExceptions(): this;
    /**
     * Grants permission to list information about the security data lakes
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_ListDataLakes.html
     */
    toListDataLakes(): this;
    /**
     * Grants permission to view the enabled accounts. You can view the enabled sources in the enabled regions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_ListLogSources.html
     */
    toListLogSources(): this;
    /**
     * Grants permission to list all subscribers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_ListSubscribers.html
     */
    toListSubscribers(): this;
    /**
     * Grants permission to list all tags for the resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to designate an account as the Amazon Security Lake administrator account for the organization
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - organizations:DescribeOrganization
     * - organizations:EnableAWSServiceAccess
     * - organizations:ListDelegatedAdministrators
     * - organizations:ListDelegatedServicesForAccount
     * - organizations:RegisterDelegatedAdministrator
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_RegisterDataLakeDelegatedAdministrator.html
     */
    toRegisterDataLakeDelegatedAdministrator(): this;
    /**
     * Grants permission to add tags to the resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from the resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a security data lake
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:PutRule
     * - events:PutTargets
     * - iam:CreateServiceLinkedRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:ListAttachedRolePolicies
     * - iam:PutRolePolicy
     * - kms:CreateGrant
     * - kms:DescribeKey
     * - lakeformation:GetDataLakeSettings
     * - lakeformation:PutDataLakeSettings
     * - lambda:AddPermission
     * - lambda:CreateEventSourceMapping
     * - lambda:CreateFunction
     * - organizations:DescribeOrganization
     * - organizations:ListDelegatedServicesForAccount
     * - s3:CreateBucket
     * - s3:GetObject
     * - s3:GetObjectVersion
     * - s3:ListBucket
     * - s3:PutBucketPolicy
     * - s3:PutBucketPublicAccessBlock
     * - s3:PutBucketVersioning
     * - sqs:CreateQueue
     * - sqs:GetQueueAttributes
     * - sqs:SetQueueAttributes
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateDataLake.html
     */
    toUpdateDataLake(): this;
    /**
     * Grants permission to update subscriptions to the SNS topics for exception notifications
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateDataLakeExceptionSubscription.html
     */
    toUpdateDataLakeExceptionSubscription(): this;
    /**
     * Grants permission to update subscriber
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:CreateApiDestination
     * - events:CreateConnection
     * - events:DescribeRule
     * - events:ListApiDestinations
     * - events:ListConnections
     * - events:PutRule
     * - events:PutTargets
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PutRolePolicy
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateSubscriber.html
     */
    toUpdateSubscriber(): this;
    /**
     * Grants permission to update a webhook invocation to notify a client when there is new data in the data lake
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:CreateApiDestination
     * - events:CreateConnection
     * - events:DescribeRule
     * - events:ListApiDestinations
     * - events:ListConnections
     * - events:PutRule
     * - events:PutTargets
     * - iam:CreateServiceLinkedRole
     * - iam:DeleteRolePolicy
     * - iam:GetRole
     * - iam:PassRole
     * - iam:PutRolePolicy
     * - s3:CreateBucket
     * - s3:GetBucketNotification
     * - s3:ListBucket
     * - s3:PutBucketNotification
     * - s3:PutBucketPolicy
     * - s3:PutBucketPublicAccessBlock
     * - s3:PutBucketVersioning
     * - s3:PutLifecycleConfiguration
     * - sqs:CreateQueue
     * - sqs:DeleteQueue
     * - sqs:GetQueueAttributes
     * - sqs:GetQueueUrl
     * - sqs:SetQueueAttributes
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateSubscriberNotification.html
     */
    toUpdateSubscriberNotification(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type data-lake to the statement
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_DataLakeResource.html
     *
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     */
    onDataLake(account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type subscriber to the statement
     *
     * https://docs.aws.amazon.com/security-lake/latest/APIReference/API_SubscriberResource.html
     *
     * @param subscriberId - Identifier for the subscriberId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     */
    onSubscriber(subscriberId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateDataLake()
     * - .toCreateSubscriber()
     * - .toTagResource()
     *
     * Applies to resource types:
     * - data-lake
     * - subscriber
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a tag key and value pair of a resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toCreateSubscriber()
     *
     * Applies to resource types:
     * - data-lake
     * - subscriber
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateDataLake()
     * - .toCreateSubscriber()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [securitylake](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsecuritylake.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
