import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [odb](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsservice-oracledatabase_aws.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Odb extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to register the Amazon Web Services Marketplace token for your Amazon Web Services account to activate your Oracle Database@Amazon Web Services subscription
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_AcceptMarketplaceRegistration.html
     */
    toAcceptMarketplaceRegistration(): this;
    /**
     * Grants permission to create a new Autonomous VM cluster in the specified Exadata infrastructure
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_CreateCloudAutonomousVmCluster.html
     */
    toCreateCloudAutonomousVmCluster(): this;
    /**
     * Grants permission to create an Exadata infrastructure
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_CreateCloudExadataInfrastructure.html
     */
    toCreateCloudExadataInfrastructure(): this;
    /**
     * Grants permission to create a VM cluster on the specified Exadata infrastructure
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_CreateCloudVmCluster.html
     */
    toCreateCloudVmCluster(): this;
    /**
     * Grants permission to create a DB Node
     *
     * Access Level: Write
     */
    toCreateDbNode(): this;
    /**
     * Grants permission to create an ODB network
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_CreateOdbNetwork.html
     */
    toCreateOdbNetwork(): this;
    /**
     * Grants permission to create an ODB Peering Connection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_CreateOdbPeeringConnection.html
     */
    toCreateOdbPeeringConnection(): this;
    /**
     * Grants permission to create an Outbound Integration
     *
     * Access Level: Write
     */
    toCreateOutboundIntegration(): this;
    /**
     * Grants permission to Deletes an Autonomous VM cluster
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_DeleteCloudAutonomousVmCluster.html
     */
    toDeleteCloudAutonomousVmCluster(): this;
    /**
     * Grants permission to delete a specified Exadata infrastructure. Before you use this operation, make sure to delete all of the VM clusters that are hosted on this Exadata infrastructure
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_DeleteCloudExadataInfrastructure.html
     */
    toDeleteCloudExadataInfrastructure(): this;
    /**
     * Grants permission to delete a specified VM cluster
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_DeleteCloudVmCluster.html
     */
    toDeleteCloudVmCluster(): this;
    /**
     * Grants permission to delete a DB Node
     *
     * Access Level: Write
     */
    toDeleteDbNode(): this;
    /**
     * Grants permission to delete the specified ODB network
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_DeleteOdbNetwork.html
     */
    toDeleteOdbNetwork(): this;
    /**
     * Grants permission to delete the specified ODB Peering Connection. When you delete an ODB peering connection, the underlying VPC peering connection is also deleted
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_DeleteOdbPeeringConnection.html
     */
    toDeleteOdbPeeringConnection(): this;
    /**
     * Grants permission to delete a resource policy
     *
     * Access Level: Write
     */
    toDeleteResourcePolicy(): this;
    /**
     * Grants permission to get information about a specific Autonomous VM cluster
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_GetCloudAutonomousVmCluster.html
     */
    toGetCloudAutonomousVmCluster(): this;
    /**
     * Grants permission to get information about the specified Exadata infrastructure
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_GetCloudExadataInfrastructure.html
     */
    toGetCloudExadataInfrastructure(): this;
    /**
     * Grants permission to retrieve information about unallocated resources in a specified Cloud Exadata Infrastructure
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_GetCloudExadataInfrastructureUnallocatedResources.html
     */
    toGetCloudExadataInfrastructureUnallocatedResources(): this;
    /**
     * Grants permission to get information about the specified VM cluster
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_GetCloudVmCluster.html
     */
    toGetCloudVmCluster(): this;
    /**
     * Grants permission to get information about the specified DB node
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_GetDbNode.html
     */
    toGetDbNode(): this;
    /**
     * Grants permission to get information about the specified database server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_GetDbServer.html
     */
    toGetDbServer(): this;
    /**
     * Grants permission to get the tenancy activation link and onboarding status for your Amazon Web Services account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_GetOciOnboardingStatus.html
     */
    toGetOciOnboardingStatus(): this;
    /**
     * Grants permission to get information about the specified ODB network
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_GetOdbNetwork.html
     */
    toGetOdbNetwork(): this;
    /**
     * Grants permission to get information about the specified ODB Peering connection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_GetOdbPeeringConnection.html
     */
    toGetOdbPeeringConnection(): this;
    /**
     * Grants permission to get a resource policy
     *
     * Access Level: Read
     */
    toGetResourcePolicy(): this;
    /**
     * Grants permission to initialize the ODB service for the first time in an account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_InitializeService.html
     */
    toInitializeService(): this;
    /**
     * Grants permission to list all Autonomous VMs in an Autonomous VM cluster
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_ListAutonomousVirtualMachines.html
     */
    toListAutonomousVirtualMachines(): this;
    /**
     * Grants permission to list all Autonomous VM clusters in a specified Cloud Exadata infrastructure
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_ListCloudAutonomousVmClusters.html
     */
    toListCloudAutonomousVmClusters(): this;
    /**
     * Grants permission to list information about the Exadata infrastructures owned by your Amazon Web Services account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_ListCloudExadataInfrastructures.html
     */
    toListCloudExadataInfrastructures(): this;
    /**
     * Grants permission to list information about the VM clusters owned by your Amazon Web Services account or only the ones on the specified Exadata infrastructure
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_ListCloudVmClusters.html
     */
    toListCloudVmClusters(): this;
    /**
     * Grants permission to list information about the DB nodes for the specified VM cluster
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_ListDbNodes.html
     */
    toListDbNodes(): this;
    /**
     * Grants permission to list information about the database servers that belong to the specified Exadata infrastructure
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_ListDbServers.html
     */
    toListDbServers(): this;
    /**
     * Grants permission to list information about the shapes that are available for an Exadata infrastructure
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_ListDbSystemShapes.html
     */
    toListDbSystemShapes(): this;
    /**
     * Grants permission to list information about Oracle Grid Infrastructure (GI) software versions that are available for a VM cluster for the specified shape
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_ListGiVersions.html
     */
    toListGiVersions(): this;
    /**
     * Grants permission to list information about the ODB networks owned by your Amazon Web Services account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_ListOdbNetworks.html
     */
    toListOdbNetworks(): this;
    /**
     * Grants permission to list all ODB peering connections or those associated with a specific ODB network
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_ListOdbPeeringConnections.html
     */
    toListOdbPeeringConnections(): this;
    /**
     * Grants permission to list information about the system versions that are available for a VM cluster for the specified giVersion and shape
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_ListSystemVersions.html
     */
    toListSystemVersions(): this;
    /**
     * Grants permission to list information about the tags applied to this resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to update a resource policy
     *
     * Access Level: Write
     */
    toPutResourcePolicy(): this;
    /**
     * Grants permission to reboot the specified DB node in a VM cluster
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_RebootDbNode.html
     */
    toRebootDbNode(): this;
    /**
     * Grants permission to start the specified DB node in a VM cluster
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_StartDbNode.html
     */
    toStartDbNode(): this;
    /**
     * Grants permission to stop the specified DB node in a VM cluster
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_StopDbNode.html
     */
    toStopDbNode(): this;
    /**
     * Grants permission to apply tags to the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the properties of an Exadata infrastructure resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_UpdateCloudExadataInfrastructure.html
     */
    toUpdateCloudExadataInfrastructure(): this;
    /**
     * Grants permission to update properties of a specified ODB network
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_UpdateOdbNetwork.html
     */
    toUpdateOdbNetwork(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type cloud-autonomous-vm-cluster to the statement
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_CloudAutonomousVmCluster.html
     *
     * @param cloudAutonomousVmClusterId - Identifier for the cloudAutonomousVmClusterId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCloudAutonomousVmCluster(cloudAutonomousVmClusterId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type cloud-exadata-infrastructure to the statement
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_CloudExadataInfrastructure.html
     *
     * @param cloudExadataInfrastructureId - Identifier for the cloudExadataInfrastructureId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCloudExadataInfrastructure(cloudExadataInfrastructureId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type cloud-vm-cluster to the statement
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_CloudVmCluster.html
     *
     * @param cloudVmClusterId - Identifier for the cloudVmClusterId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCloudVmCluster(cloudVmClusterId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type db-node to the statement
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_DbNode.html
     *
     * @param dbNodeId - Identifier for the dbNodeId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDbNode(dbNodeId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type odb-network to the statement
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_OdbNetwork.html
     *
     * @param odbNetworkId - Identifier for the odbNetworkId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onOdbNetwork(odbNetworkId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type odb-peering-connection to the statement
     *
     * https://docs.aws.amazon.com/odb/latest/APIReference/API_OdbPeeringConnection.html
     *
     * @param odbPeeringConnectionId - Identifier for the odbPeeringConnectionId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onOdbPeeringConnection(odbPeeringConnectionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by a tag key and value pair that is allowed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateCloudAutonomousVmCluster()
     * - .toCreateCloudExadataInfrastructure()
     * - .toCreateCloudVmCluster()
     * - .toCreateOdbNetwork()
     * - .toCreateOdbPeeringConnection()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a tag key and value pair of a resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toListTagsForResource()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * Applies to resource types:
     * - cloud-autonomous-vm-cluster
     * - cloud-exadata-infrastructure
     * - cloud-vm-cluster
     * - db-node
     * - odb-network
     * - odb-peering-connection
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a list of tag keys that are allowed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateCloudAutonomousVmCluster()
     * - .toCreateCloudExadataInfrastructure()
     * - .toCreateCloudVmCluster()
     * - .toCreateOdbNetwork()
     * - .toCreateOdbPeeringConnection()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [odb](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsservice-oracledatabase_aws.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
