import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [uxc](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsserviceformanagingawsconsoleuserexperiencecapabilities..html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Uxc extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to delete the color associated with the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/DeleteAccountColor.html
     */
    toDeleteAccountColor(): this;
    /**
     * Grants permission to get the color associated with the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/GetAccountColor.html
     */
    toGetAccountColor(): this;
    /**
     * Grants permission to sets the color associated with an account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/PutAccountColor.html
     */
    toPutAccountColor(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [uxc](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsserviceformanagingawsconsoleuserexperiencecapabilities..html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
