"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Uxc = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [uxc](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsserviceformanagingawsconsoleuserexperiencecapabilities..html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Uxc extends shared_1.PolicyStatement {
    /**
     * Grants permission to delete the color associated with the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/DeleteAccountColor.html
     */
    toDeleteAccountColor() {
        return this.to('DeleteAccountColor');
    }
    /**
     * Grants permission to get the color associated with the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/GetAccountColor.html
     */
    toGetAccountColor() {
        return this.to('GetAccountColor');
    }
    /**
     * Grants permission to sets the color associated with an account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/PutAccountColor.html
     */
    toPutAccountColor() {
        return this.to('PutAccountColor');
    }
    /**
     * Statement provider for service [uxc](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsserviceformanagingawsconsoleuserexperiencecapabilities..html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'uxc';
        this.accessLevelList = {
            Write: [
                'DeleteAccountColor',
                'PutAccountColor'
            ],
            Read: [
                'GetAccountColor'
            ]
        };
    }
}
exports.Uxc = Uxc;
//# sourceMappingURL=data:application/json;base64,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