import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [network-security-director](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsshieldnetworksecuritydirector.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class NetworkSecurityDirector extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to get a finding
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/network-security-director/latest/APIReference/API_GetFinding.html
     */
    toGetFinding(): this;
    /**
     * Grants permission to get the status of network security scan
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/network-security-director/latest/APIReference/API_GetNetworkSecurityScan.html
     */
    toGetNetworkSecurityScan(): this;
    /**
     * Grants permission to get a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/network-security-director/latest/APIReference/API_GetResource.html
     */
    toGetResource(): this;
    /**
     * Grants permission to list findings
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/network-security-director/latest/APIReference/API_ListFindings.html
     */
    toListFindings(): this;
    /**
     * Grants permission to list insights about the latest network security scan
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/network-security-director/latest/APIReference/API_ListInsights.html
     */
    toListInsights(): this;
    /**
     * Grants permission to list remediations for a finding
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/network-security-director/latest/APIReference/API_ListRemediations.html
     */
    toListRemediations(): this;
    /**
     * Grants permission to list resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/network-security-director/latest/APIReference/API_ListResources.html
     */
    toListResources(): this;
    /**
     * Grants permission to start a network security scan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/network-security-director/latest/APIReference/API_StartNetworkSecurityScan.html
     */
    toStartNetworkSecurityScan(): this;
    /**
     * Grants permission to update the status of a finding
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/network-security-director/latest/APIReference/API_UpdateFinding.html
     */
    toUpdateFinding(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [network-security-director](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsshieldnetworksecuritydirector.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
