"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkSecurityDirector = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [network-security-director](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsshieldnetworksecuritydirector.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class NetworkSecurityDirector extends shared_1.PolicyStatement {
    /**
     * Grants permission to get a finding
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/network-security-director/latest/APIReference/API_GetFinding.html
     */
    toGetFinding() {
        return this.to('GetFinding');
    }
    /**
     * Grants permission to get the status of network security scan
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/network-security-director/latest/APIReference/API_GetNetworkSecurityScan.html
     */
    toGetNetworkSecurityScan() {
        return this.to('GetNetworkSecurityScan');
    }
    /**
     * Grants permission to get a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/network-security-director/latest/APIReference/API_GetResource.html
     */
    toGetResource() {
        return this.to('GetResource');
    }
    /**
     * Grants permission to list findings
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/network-security-director/latest/APIReference/API_ListFindings.html
     */
    toListFindings() {
        return this.to('ListFindings');
    }
    /**
     * Grants permission to list insights about the latest network security scan
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/network-security-director/latest/APIReference/API_ListInsights.html
     */
    toListInsights() {
        return this.to('ListInsights');
    }
    /**
     * Grants permission to list remediations for a finding
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/network-security-director/latest/APIReference/API_ListRemediations.html
     */
    toListRemediations() {
        return this.to('ListRemediations');
    }
    /**
     * Grants permission to list resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/network-security-director/latest/APIReference/API_ListResources.html
     */
    toListResources() {
        return this.to('ListResources');
    }
    /**
     * Grants permission to start a network security scan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/network-security-director/latest/APIReference/API_StartNetworkSecurityScan.html
     */
    toStartNetworkSecurityScan() {
        return this.to('StartNetworkSecurityScan');
    }
    /**
     * Grants permission to update the status of a finding
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/network-security-director/latest/APIReference/API_UpdateFinding.html
     */
    toUpdateFinding() {
        return this.to('UpdateFinding');
    }
    /**
     * Statement provider for service [network-security-director](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsshieldnetworksecuritydirector.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'network-security-director';
        this.accessLevelList = {
            Read: [
                'GetFinding',
                'GetNetworkSecurityScan',
                'GetResource'
            ],
            List: [
                'ListFindings',
                'ListInsights',
                'ListRemediations',
                'ListResources'
            ],
            Write: [
                'StartNetworkSecurityScan',
                'UpdateFinding'
            ]
        };
    }
}
exports.NetworkSecurityDirector = NetworkSecurityDirector;
//# sourceMappingURL=data:application/json;base64,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