import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [ses-mailmanager](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsimpleemailservice-mailmanager.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class SesMailmanager extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to configure vended log delivery for Mail Manager resources
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/ses/latest/dg/eb-policies.html
     */
    toAllowVendedLogDeliveryForResource(): this;
    /**
     * Grants permission to create an addon instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAddonSubscriptionArn()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_CreateAddonInstance.html
     */
    toCreateAddonInstance(): this;
    /**
     * Grants permission to create an addon subscription
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_CreateAddonSubscription.html
     */
    toCreateAddonSubscription(): this;
    /**
     * Grants permission to create an address list
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_CreateAddressList.html
     */
    toCreateAddressList(): this;
    /**
     * Grants permission to create an import job on an address list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_CreateAddressListImportJob.html
     */
    toCreateAddressListImportJob(): this;
    /**
     * Grants permission to create an archive
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_CreateArchive.html
     */
    toCreateArchive(): this;
    /**
     * Grants permission to create an ingress point
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifMailManagerRuleSetArn()
     * - .ifMailManagerTrafficPolicyArn()
     *
     * Dependent actions:
     * - ec2:DescribeVpcEndpoints
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_CreateIngressPoint.html
     */
    toCreateIngressPoint(): this;
    /**
     * Grants permission to create a SMTP relay
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_CreateRelay.html
     */
    toCreateRelay(): this;
    /**
     * Grants permission to create a rule set
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_CreateRuleSet.html
     */
    toCreateRuleSet(): this;
    /**
     * Grants permission to create a traffic policy
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_CreateTrafficPolicy.html
     */
    toCreateTrafficPolicy(): this;
    /**
     * Grants permission to delete an addon instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_DeleteAddonInstance.html
     */
    toDeleteAddonInstance(): this;
    /**
     * Grants permission to delete an addon subscription
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_DeleteAddonSubscription.html
     */
    toDeleteAddonSubscription(): this;
    /**
     * Grants permission to delete an address list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_DeleteAddressList.html
     */
    toDeleteAddressList(): this;
    /**
     * Grants permission to delete an archive
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_DeleteArchive.html
     */
    toDeleteArchive(): this;
    /**
     * Grants permission to delete an ingress point
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_DeleteIngressPoint.html
     */
    toDeleteIngressPoint(): this;
    /**
     * Grants permission to delete a SMTP relay
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_DeleteRelay.html
     */
    toDeleteRelay(): this;
    /**
     * Grants permission to delete a rule set
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_DeleteRuleSet.html
     */
    toDeleteRuleSet(): this;
    /**
     * Grants permission to delete a traffic point
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_DeleteTrafficPolicy.html
     */
    toDeleteTrafficPolicy(): this;
    /**
     * Grants permission to remove a member from an address list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_DeregisterMemberFromAddressList.html
     */
    toDeregisterMemberFromAddressList(): this;
    /**
     * Grants permission to get information about an addon instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_GetAddonInstance.html
     */
    toGetAddonInstance(): this;
    /**
     * Grants permission to get information about an addon subscription
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_GetAddonSubscription.html
     */
    toGetAddonSubscription(): this;
    /**
     * Grants permission to get information about an address list
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_GetAddressList.html
     */
    toGetAddressList(): this;
    /**
     * Grants permission to get information about an import job on an address list
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_GetAddressListImportJob.html
     */
    toGetAddressListImportJob(): this;
    /**
     * Grants permission to get information about an archive
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_GetArchive.html
     */
    toGetArchive(): this;
    /**
     * Grants permission to get information about an archive export
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_GetArchiveExport.html
     */
    toGetArchiveExport(): this;
    /**
     * Grants permission to retrieve archived message
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_GetArchiveMessage.html
     */
    toGetArchiveMessage(): this;
    /**
     * Grants permission to retrieve archived message content
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_GetArchiveMessageContent.html
     */
    toGetArchiveMessageContent(): this;
    /**
     * Grants permission to get information about a search
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_GetArchiveSearch.html
     */
    toGetArchiveSearch(): this;
    /**
     * Grants permission to get information about search results
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_GetArchiveSearchResults.html
     */
    toGetArchiveSearchResults(): this;
    /**
     * Grants permission to get information about an ingress point
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_GetIngressPoint.html
     */
    toGetIngressPoint(): this;
    /**
     * Grants permission to get information about a member in an address list
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_GetMemberOfAddressList.html
     */
    toGetMemberOfAddressList(): this;
    /**
     * Grants permission to get information about a SMTP relay
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_GetRelay.html
     */
    toGetRelay(): this;
    /**
     * Grants permission to get information about a rule set
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_GetRuleSet.html
     */
    toGetRuleSet(): this;
    /**
     * Grants permission to get information about a traffic policy
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_GetTrafficPolicy.html
     */
    toGetTrafficPolicy(): this;
    /**
     * Grants permission to list all of the addon instances associated with your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_ListAddonInstances.html
     */
    toListAddonInstances(): this;
    /**
     * Grants permission to list all of the addon subscriptions associated with your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_ListAddonSubscriptions.html
     */
    toListAddonSubscriptions(): this;
    /**
     * Grants permission to list all of the import jobs associated with an address list
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_ListAddressListImportJobs.html
     */
    toListAddressListImportJobs(): this;
    /**
     * Grants permission to list all of the address lists associated with your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_ListAddressLists.html
     */
    toListAddressLists(): this;
    /**
     * Grants permission to list all of the archive exports associated with your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_ListArchiveExports.html
     */
    toListArchiveExports(): this;
    /**
     * Grants permission to list all of the archive searches associated with your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_ListArchiveSearches.html
     */
    toListArchiveSearches(): this;
    /**
     * Grants permission to list all of the archives associated with your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_ListArchives.html
     */
    toListArchives(): this;
    /**
     * Grants permission to list all of the ingress points associated with your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_ListIngressPoints.html
     */
    toListIngressPoints(): this;
    /**
     * Grants permission to list all of the members associated with an address list
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_ListMembersOfAddressList.html
     */
    toListMembersOfAddressList(): this;
    /**
     * Grants permission to list all of the SMTP relays associated with your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_ListRelays.html
     */
    toListRelays(): this;
    /**
     * Grants permission to list all of the rule sets associated with your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_ListRuleSets.html
     */
    toListRuleSets(): this;
    /**
     * Grants permission to list all of the tags associated with the resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list all of the traffic policies associated with your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_ListTrafficPolicies.html
     */
    toListTrafficPolicies(): this;
    /**
     * Grants permission to add a member to an address list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_RegisterMemberToAddressList.html
     */
    toRegisterMemberToAddressList(): this;
    /**
     * Grants permission to start an import job on an address list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_StartAddressListImportJob.html
     */
    toStartAddressListImportJob(): this;
    /**
     * Grants permission to start an archive export
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_StartArchiveExport.html
     */
    toStartArchiveExport(): this;
    /**
     * Grants permission to start an archive search
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_StartArchiveSearch.html
     */
    toStartArchiveSearch(): this;
    /**
     * Grants permission to stop an ongoing import job on an address list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_StopAddressListImportJob.html
     */
    toStopAddressListImportJob(): this;
    /**
     * Grants permission to stop archive export
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_StopArchiveExport.html
     */
    toStopArchiveExport(): this;
    /**
     * Grants permission to stop archive search
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_StopArchiveSearch.html
     */
    toStopArchiveSearch(): this;
    /**
     * Grants permission to add one or more tags (keys and values) to a specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove one or more tags (keys and values) from a specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an archive
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_UpdateArchive.html
     */
    toUpdateArchive(): this;
    /**
     * Grants permission to update an ingress point
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifMailManagerTrafficPolicyArn()
     * - .ifMailManagerRuleSetArn()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_UpdateIngressPoint.html
     */
    toUpdateIngressPoint(): this;
    /**
     * Grants permission to update a SMTP relay
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_UpdateRelay.html
     */
    toUpdateRelay(): this;
    /**
     * Grants permission to update a rule set
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_UpdateRuleSet.html
     */
    toUpdateRuleSet(): this;
    /**
     * Grants permission to update a traffic policy
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_UpdateTrafficPolicy.html
     */
    toUpdateTrafficPolicy(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type addon-instance to the statement
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_AddonInstance.html
     *
     * @param addonInstanceId - Identifier for the addonInstanceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAddonInstance(addonInstanceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type addon-subscription to the statement
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_AddonSubscription.html
     *
     * @param addonSubscriptionId - Identifier for the addonSubscriptionId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAddonSubscription(addonSubscriptionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type mailmanager-archive to the statement
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_Archive.html
     *
     * @param archiveId - Identifier for the archiveId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMailmanagerArchive(archiveId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type mailmanager-ingress-point to the statement
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_IngressPoint.html
     *
     * @param ingressPointId - Identifier for the ingressPointId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifMailManagerIngressPointType()
     */
    onMailmanagerIngressPoint(ingressPointId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type mailmanager-smtp-relay to the statement
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_Relay.html
     *
     * @param relayId - Identifier for the relayId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMailmanagerSmtpRelay(relayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type mailmanager-rule-set to the statement
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_RuleSet.html
     *
     * @param ruleSetId - Identifier for the ruleSetId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMailmanagerRuleSet(ruleSetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type mailmanager-traffic-policy to the statement
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_TrafficPolicy.html
     *
     * @param trafficPolicyId - Identifier for the trafficPolicyId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMailmanagerTrafficPolicy(trafficPolicyId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type mailmanager-address-list to the statement
     *
     * https://docs.aws.amazon.com/sesmailmanager/latest/APIReference/API_AddressList.html
     *
     * @param addressListId - Identifier for the addressListId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMailmanagerAddressList(addressListId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the presence of tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateAddonInstance()
     * - .toCreateAddonSubscription()
     * - .toCreateAddressList()
     * - .toCreateArchive()
     * - .toCreateIngressPoint()
     * - .toCreateRelay()
     * - .toCreateRuleSet()
     * - .toCreateTrafficPolicy()
     * - .toDeleteAddonInstance()
     * - .toDeleteAddonSubscription()
     * - .toDeleteArchive()
     * - .toDeleteIngressPoint()
     * - .toDeleteRelay()
     * - .toDeleteRuleSet()
     * - .toDeleteTrafficPolicy()
     * - .toGetAddonInstance()
     * - .toGetAddonSubscription()
     * - .toGetArchive()
     * - .toGetIngressPoint()
     * - .toGetRelay()
     * - .toGetRuleSet()
     * - .toGetTrafficPolicy()
     * - .toTagResource()
     * - .toUpdateArchive()
     * - .toUpdateIngressPoint()
     * - .toUpdateRelay()
     * - .toUpdateRuleSet()
     * - .toUpdateTrafficPolicy()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toCreateAddressListImportJob()
     * - .toDeleteAddressList()
     * - .toDeregisterMemberFromAddressList()
     * - .toGetAddressList()
     * - .toGetAddressListImportJob()
     * - .toGetMemberOfAddressList()
     * - .toListAddressListImportJobs()
     * - .toListMembersOfAddressList()
     * - .toRegisterMemberToAddressList()
     * - .toStartAddressListImportJob()
     * - .toStopAddressListImportJob()
     *
     * Applies to resource types:
     * - addon-instance
     * - addon-subscription
     * - mailmanager-archive
     * - mailmanager-ingress-point
     * - mailmanager-smtp-relay
     * - mailmanager-rule-set
     * - mailmanager-traffic-policy
     * - mailmanager-address-list
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the presence of tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateAddonInstance()
     * - .toCreateAddonSubscription()
     * - .toCreateAddressList()
     * - .toCreateArchive()
     * - .toCreateIngressPoint()
     * - .toCreateRelay()
     * - .toCreateRuleSet()
     * - .toCreateTrafficPolicy()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by SES Addon Subscription ARN
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsesmailmanager.html#amazonsesmailmanager-policy-keys
     *
     * Applies to actions:
     * - .toCreateAddonInstance()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifAddonSubscriptionArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by SES Mail Manager ingress point type, for example OPEN or AUTH
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsesmailmanager.html#amazonsesmailmanager-policy-keys
     *
     * Applies to resource types:
     * - mailmanager-ingress-point
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifMailManagerIngressPointType(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by SES Mail Manager rule set ARN
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsesmailmanager.html#amazonsesmailmanager-policy-keys
     *
     * Applies to actions:
     * - .toCreateIngressPoint()
     * - .toUpdateIngressPoint()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifMailManagerRuleSetArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by SES Mail Manager traffic policy ARN
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsesmailmanager.html#amazonsesmailmanager-policy-keys
     *
     * Applies to actions:
     * - .toCreateIngressPoint()
     * - .toUpdateIngressPoint()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifMailManagerTrafficPolicyArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [ses-mailmanager](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsimpleemailservice-mailmanager.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
