import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [simspaceweaver](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssimspaceweaver.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Simspaceweaver extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a snapshot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/simspaceweaver/latest/APIReference/API_CreateSnapshot.html
     */
    toCreateSnapshot(): this;
    /**
     * Grants permission to delete an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/simspaceweaver/latest/APIReference/API_DeleteApp.html
     */
    toDeleteApp(): this;
    /**
     * Grants permission to delete a simulation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/simspaceweaver/latest/APIReference/API_DeleteSimulation.html
     */
    toDeleteSimulation(): this;
    /**
     * Grants permission to describe an app
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/simspaceweaver/latest/APIReference/API_DescribeApp.html
     */
    toDescribeApp(): this;
    /**
     * Grants permission to describe a simulation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/simspaceweaver/latest/APIReference/API_DescribeSimulation.html
     */
    toDescribeSimulation(): this;
    /**
     * Grants permission to list apps
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/simspaceweaver/latest/APIReference/API_ListApps.html
     */
    toListApps(): this;
    /**
     * Grants permission to list simulations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/simspaceweaver/latest/APIReference/API_ListSimulations.html
     */
    toListSimulations(): this;
    /**
     * Grants permission to list the tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/simspaceweaver/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to start an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/simspaceweaver/latest/APIReference/API_StartApp.html
     */
    toStartApp(): this;
    /**
     * Grants permission to start a simulation clock
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/simspaceweaver/latest/APIReference/API_StartClock.html
     */
    toStartClock(): this;
    /**
     * Grants permission to start a simulation
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/simspaceweaver/latest/APIReference/API_StartSimulation.html
     */
    toStartSimulation(): this;
    /**
     * Grants permission to stop an app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/simspaceweaver/latest/APIReference/API_StopApp.html
     */
    toStopApp(): this;
    /**
     * Grants permission to stop a simulation clock
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/simspaceweaver/latest/APIReference/API_StopClock.html
     */
    toStopClock(): this;
    /**
     * Grants permission to stop a simulation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/simspaceweaver/latest/APIReference/API_StopSimulation.html
     */
    toStopSimulation(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/simspaceweaver/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/simspaceweaver/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type Simulation to the statement
     *
     * https://docs.aws.amazon.com/simspaceweaver/latest/userguide/working-with_configuring-simulation.html
     *
     * @param simulationName - Identifier for the simulationName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSimulation(simulationName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toStartSimulation()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - Simulation
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toStartSimulation()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [simspaceweaver](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssimspaceweaver.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
