import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [states](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsstepfunctions.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class States extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create an activity
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_CreateActivity.html
     */
    toCreateActivity(): this;
    /**
     * Grants permission to create a state machine
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:PassRole
     * - states:PublishStateMachineVersion
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_CreateStateMachine.html
     */
    toCreateStateMachine(): this;
    /**
     * Grants permission to create a state machine alias
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifStateMachineQualifier()
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_CreateStateMachineAlias.html
     */
    toCreateStateMachineAlias(): this;
    /**
     * Grants permission to delete an activity
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_DeleteActivity.html
     */
    toDeleteActivity(): this;
    /**
     * Grants permission to delete a state machine
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_DeleteStateMachine.html
     */
    toDeleteStateMachine(): this;
    /**
     * Grants permission to delete a state machine alias
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifStateMachineQualifier()
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_DeleteStateMachineAlias.html
     */
    toDeleteStateMachineAlias(): this;
    /**
     * Grants permission to delete a state machine version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifStateMachineQualifier()
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_DeleteStateMachineVersion.html
     */
    toDeleteStateMachineVersion(): this;
    /**
     * Grants permission to describe an activity
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_DescribeActivity.html
     */
    toDescribeActivity(): this;
    /**
     * Grants permission to describe an execution
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_DescribeExecution.html
     */
    toDescribeExecution(): this;
    /**
     * Grants permission to describe a map run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_DescribeMapRun.html
     */
    toDescribeMapRun(): this;
    /**
     * Grants permission to describe a state machine
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifStateMachineQualifier()
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_DescribeStateMachine.html
     */
    toDescribeStateMachine(): this;
    /**
     * Grants permission to describe a state machine alias
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifStateMachineQualifier()
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_DescribeStateMachineAlias.html
     */
    toDescribeStateMachineAlias(): this;
    /**
     * Grants permission to describe the state machine for an execution
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_DescribeStateMachineForExecution.html
     */
    toDescribeStateMachineForExecution(): this;
    /**
     * Grants permission to be used by workers to retrieve a task (with the specified activity ARN) which has been scheduled for execution by a running state machine
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_GetActivityTask.html
     */
    toGetActivityTask(): this;
    /**
     * Grants permission to return the history of the specified execution as a list of events
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_GetExecutionHistory.html
     */
    toGetExecutionHistory(): this;
    /**
     * Grants permission to invoke the HTTP Task state
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/step-functions/latest/dg/connect-third-party-apis.html
     */
    toInvokeHTTPEndpoint(): this;
    /**
     * Grants permission to list the existing activities
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_ListActivities.html
     */
    toListActivities(): this;
    /**
     * Grants permission to list the executions of a state machine
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifStateMachineQualifier()
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_ListExecutions.html
     */
    toListExecutions(): this;
    /**
     * Grants permission to list the map runs of an execution
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_ListMapRuns.html
     */
    toListMapRuns(): this;
    /**
     * Grants permission to list the aliases of a state machine
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifStateMachineQualifier()
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_ListStateMachineAliases.html
     */
    toListStateMachineAliases(): this;
    /**
     * Grants permission to list the versions of a state machine
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_ListStateMachineVersions.html
     */
    toListStateMachineVersions(): this;
    /**
     * Grants permission to lists the existing state machines
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_ListStateMachines.html
     */
    toListStateMachines(): this;
    /**
     * Grants permission to list tags for an AWS Step Functions resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to publish a state machine version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_PublishStateMachineVersion.html
     */
    toPublishStateMachineVersion(): this;
    /**
     * Grants permission to redrive an execution
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_RedriveExecution.html
     */
    toRedriveExecution(): this;
    /**
     * Grants permission to reveal sensitive data from an execution
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/step-functions/latest/dg/test-state-isolation.html
     */
    toRevealSecrets(): this;
    /**
     * Grants permission to report that the task identified by the taskToken failed
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_SendTaskFailure.html
     */
    toSendTaskFailure(): this;
    /**
     * Grants permission to report to the service that the task represented by the specified taskToken is still making progress
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_SendTaskHeartbeat.html
     */
    toSendTaskHeartbeat(): this;
    /**
     * Grants permission to report that the task identified by the taskToken completed successfully
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_SendTaskSuccess.html
     */
    toSendTaskSuccess(): this;
    /**
     * Grants permission to start a state machine execution
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifStateMachineQualifier()
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
     */
    toStartExecution(): this;
    /**
     * Grants permission to start a Synchronous Express state machine execution
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifStateMachineQualifier()
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartSyncExecution.html
     */
    toStartSyncExecution(): this;
    /**
     * Grants permission to stop an execution
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_StopExecution.html
     */
    toStopExecution(): this;
    /**
     * Grants permission to tag an AWS Step Functions resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to test a state machine definition
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - states:RevealSecrets
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_TestState.html
     */
    toTestState(): this;
    /**
     * Grants permission to remove a tag from an AWS Step Functions resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a map run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_UpdateMapRun.html
     */
    toUpdateMapRun(): this;
    /**
     * Grants permission to update a state machine
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:PassRole
     * - states:PublishStateMachineVersion
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_UpdateStateMachine.html
     */
    toUpdateStateMachine(): this;
    /**
     * Grants permission to update a state machine alias
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifStateMachineQualifier()
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_UpdateStateMachineAlias.html
     */
    toUpdateStateMachineAlias(): this;
    /**
     * Grants permission to validate a state machine definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/step-functions/latest/apireference/API_ValidateStateMachineDefinition.html
     */
    toValidateStateMachineDefinition(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type activity to the statement
     *
     * https://docs.aws.amazon.com/step-functions/latest/dg/concepts-activities.html
     *
     * @param activityName - Identifier for the activityName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onActivity(activityName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type execution to the statement
     *
     * https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-executions.html
     *
     * @param stateMachineName - Identifier for the stateMachineName.
     * @param executionId - Identifier for the executionId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onExecution(stateMachineName: string, executionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type express to the statement
     *
     * https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-executions.html
     *
     * @param stateMachineName - Identifier for the stateMachineName.
     * @param executionId - Identifier for the executionId.
     * @param expressId - Identifier for the expressId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onExpress(stateMachineName: string, executionId: string, expressId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type statemachine to the statement
     *
     * https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html
     *
     * @param stateMachineName - Identifier for the stateMachineName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onStatemachine(stateMachineName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type statemachineversion to the statement
     *
     * https://docs.aws.amazon.com/step-functions/latest/dg/concepts-cd-aliasing-versioning.html
     *
     * @param stateMachineName - Identifier for the stateMachineName.
     * @param stateMachineVersionId - Identifier for the stateMachineVersionId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onStatemachineversion(stateMachineName: string, stateMachineVersionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type statemachinealias to the statement
     *
     * https://docs.aws.amazon.com/step-functions/latest/dg/concepts-cd-aliasing-versioning.html
     *
     * @param stateMachineName - Identifier for the stateMachineName.
     * @param stateMachineAliasName - Identifier for the stateMachineAliasName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onStatemachinealias(stateMachineName: string, stateMachineAliasName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type maprun to the statement
     *
     * https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html
     *
     * @param stateMachineName - Identifier for the stateMachineName.
     * @param mapRunLabel - Identifier for the mapRunLabel.
     * @param mapRunId - Identifier for the mapRunId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onMaprun(stateMachineName: string, mapRunLabel: string, mapRunId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type labelled execution to the statement
     *
     * https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html
     *
     * @param stateMachineName - Identifier for the stateMachineName.
     * @param mapRunLabel - Identifier for the mapRunLabel.
     * @param executionId - Identifier for the executionId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onLabelledExecution(stateMachineName: string, mapRunLabel: string, executionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type labelled express to the statement
     *
     * https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html
     *
     * @param stateMachineName - Identifier for the stateMachineName.
     * @param mapRunLabel - Identifier for the mapRunLabel.
     * @param executionId - Identifier for the executionId.
     * @param expressId - Identifier for the expressId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onLabelledExpress(stateMachineName: string, mapRunLabel: string, executionId: string, expressId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by a tag key and value pair that is allowed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateActivity()
     * - .toCreateStateMachine()
     * - .toTagResource()
     * - .toUpdateStateMachine()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a tag key and value pair of a resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - activity
     * - execution
     * - statemachine
     * - statemachineversion
     * - statemachinealias
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a list of tag keys that are allowed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateActivity()
     * - .toCreateStateMachine()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateStateMachine()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the endpoint that the HTTP Task state allows in the request
     *
     * https://docs.aws.amazon.com/step-functions/latest/dg/connect-third-party-apis.html
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifHTTPEndpoint(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the method that the HTTP Task state allows in the request
     *
     * https://docs.aws.amazon.com/step-functions/latest/dg/connect-third-party-apis.html
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifHTTPMethod(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the qualifier of a state machine ARN
     *
     * https://docs.aws.amazon.com/step-functions/latest/dg/auth-version-alias.html
     *
     * Applies to actions:
     * - .toCreateStateMachineAlias()
     * - .toDeleteStateMachineAlias()
     * - .toDeleteStateMachineVersion()
     * - .toDescribeStateMachine()
     * - .toDescribeStateMachineAlias()
     * - .toListExecutions()
     * - .toListStateMachineAliases()
     * - .toStartExecution()
     * - .toStartSyncExecution()
     * - .toUpdateStateMachineAlias()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifStateMachineQualifier(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [states](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsstepfunctions.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
