import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [supportplans](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupportplans.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Supportplans extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create support plan schedules for this AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-support-plans.html
     */
    toCreateSupportPlanSchedule(): this;
    /**
     * Grants permission to view details about the current support plan for this AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-support-plans.html
     */
    toGetSupportPlan(): this;
    /**
     * Grants permission to view details about the status for a request to update a support plan
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-support-plans.html
     */
    toGetSupportPlanUpdateStatus(): this;
    /**
     * Grants permission to view a list of all support plan modifiers for this AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-support-plans.html
     */
    toListSupportPlanModifiers(): this;
    /**
     * Grants permission to update the support plan for this AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-support-plans.html
     */
    toStartSupportPlanUpdate(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [supportplans](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupportplans.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
