"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Supportplans = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [supportplans](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupportplans.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Supportplans extends shared_1.PolicyStatement {
    /**
     * Grants permission to create support plan schedules for this AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-support-plans.html
     */
    toCreateSupportPlanSchedule() {
        return this.to('CreateSupportPlanSchedule');
    }
    /**
     * Grants permission to view details about the current support plan for this AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-support-plans.html
     */
    toGetSupportPlan() {
        return this.to('GetSupportPlan');
    }
    /**
     * Grants permission to view details about the status for a request to update a support plan
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-support-plans.html
     */
    toGetSupportPlanUpdateStatus() {
        return this.to('GetSupportPlanUpdateStatus');
    }
    /**
     * Grants permission to view a list of all support plan modifiers for this AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-support-plans.html
     */
    toListSupportPlanModifiers() {
        return this.to('ListSupportPlanModifiers');
    }
    /**
     * Grants permission to update the support plan for this AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-support-plans.html
     */
    toStartSupportPlanUpdate() {
        return this.to('StartSupportPlanUpdate');
    }
    /**
     * Statement provider for service [supportplans](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupportplans.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'supportplans';
        this.accessLevelList = {
            Write: [
                'CreateSupportPlanSchedule',
                'StartSupportPlanUpdate'
            ],
            Read: [
                'GetSupportPlan',
                'GetSupportPlanUpdateStatus'
            ],
            List: [
                'ListSupportPlanModifiers'
            ]
        };
    }
}
exports.Supportplans = Supportplans;
//# sourceMappingURL=data:application/json;base64,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