import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [transfer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstransferfamily.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Transfer extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to add an access associated with a server
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_CreateAccess.html
     */
    toCreateAccess(): this;
    /**
     * Grants permission to add an agreement associated with a server
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_CreateAgreement.html
     */
    toCreateAgreement(): this;
    /**
     * Grants permission to create a connector
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_CreateConnector.html
     */
    toCreateConnector(): this;
    /**
     * Grants permission to create a profile
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_CreateProfile.html
     */
    toCreateProfile(): this;
    /**
     * Grants permission to create a server
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_CreateServer.html
     */
    toCreateServer(): this;
    /**
     * Grants permission to add a user associated with a server
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_CreateUser.html
     */
    toCreateUser(): this;
    /**
     * Grants permission to create a webapp
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_CreateWebApp.html
     */
    toCreateWebApp(): this;
    /**
     * Grants permission to create a workflow
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_CreateWorkflow.html
     */
    toCreateWorkflow(): this;
    /**
     * Grants permission to delete access
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DeleteAccess.html
     */
    toDeleteAccess(): this;
    /**
     * Grants permission to delete agreement
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DeleteAgreement.html
     */
    toDeleteAgreement(): this;
    /**
     * Grants permission to delete certificate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DeleteCertificate.html
     */
    toDeleteCertificate(): this;
    /**
     * Grants permission to delete connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DeleteConnector.html
     */
    toDeleteConnector(): this;
    /**
     * Grants permission to delete a host key associated with a server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DeleteHostKey.html
     */
    toDeleteHostKey(): this;
    /**
     * Grants permission to delete profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DeleteProfile.html
     */
    toDeleteProfile(): this;
    /**
     * Grants permission to delete a server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DeleteServer.html
     */
    toDeleteServer(): this;
    /**
     * Grants permission to delete an SSH public key from a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DeleteSshPublicKey.html
     */
    toDeleteSshPublicKey(): this;
    /**
     * Grants permission to delete a user associated with a server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DeleteUser.html
     */
    toDeleteUser(): this;
    /**
     * Grants permission to delete webapp
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DeleteWebApp.html
     */
    toDeleteWebApp(): this;
    /**
     * Grants permission to delete webapp customization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DeleteWebAppCustomization.html
     */
    toDeleteWebAppCustomization(): this;
    /**
     * Grants permission to delete a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DeleteWorkflow.html
     */
    toDeleteWorkflow(): this;
    /**
     * Grants permission to describe an access assigned to a server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DescribeAccess.html
     */
    toDescribeAccess(): this;
    /**
     * Grants permission to describe an agreement assigned to a server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DescribeAgreement.html
     */
    toDescribeAgreement(): this;
    /**
     * Grants permission to describe a certificate
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DescribeCertificate.html
     */
    toDescribeCertificate(): this;
    /**
     * Grants permission to describe a connector
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DescribeConnector.html
     */
    toDescribeConnector(): this;
    /**
     * Grants permission to describe an execution associated with a workflow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DescribeExecution.html
     */
    toDescribeExecution(): this;
    /**
     * Grants permission to describe a host key associated with a server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DescribeHostKey.html
     */
    toDescribeHostKey(): this;
    /**
     * Grants permission to describe a profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DescribeProfile.html
     */
    toDescribeProfile(): this;
    /**
     * Grants permission to describe a security policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DescribeSecurityPolicy.html
     */
    toDescribeSecurityPolicy(): this;
    /**
     * Grants permission to describe a server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DescribeServer.html
     */
    toDescribeServer(): this;
    /**
     * Grants permission to describe a user associated with a server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DescribeUser.html
     */
    toDescribeUser(): this;
    /**
     * Grants permission to describe a webapp
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DescribeWebApp.html
     */
    toDescribeWebApp(): this;
    /**
     * Grants permission to describe a webapp customization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DescribeWebAppCustomization.html
     */
    toDescribeWebAppCustomization(): this;
    /**
     * Grants permission to describe a workflow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_DescribeWorkflow.html
     */
    toDescribeWorkflow(): this;
    /**
     * Grants permission to add a certificate
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ImportCertificate.html
     */
    toImportCertificate(): this;
    /**
     * Grants permission to add a host key to a server
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ImportHostKey.html
     */
    toImportHostKey(): this;
    /**
     * Grants permission to add an SSH public key to a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ImportSshPublicKey.html
     */
    toImportSshPublicKey(): this;
    /**
     * Grants permission to list accesses
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ListAccesses.html
     */
    toListAccesses(): this;
    /**
     * Grants permission to list agreements
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ListAgreements.html
     */
    toListAgreements(): this;
    /**
     * Grants permission to list certificates
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ListCertificates.html
     */
    toListCertificates(): this;
    /**
     * Grants permission to list connectors
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ListConnectors.html
     */
    toListConnectors(): this;
    /**
     * Grants permission to list executions associated with a workflow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ListExecutions.html
     */
    toListExecutions(): this;
    /**
     * Grants permission to list file transfer statuses for connectors
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ListFileTransferResults.html
     */
    toListFileTransferResults(): this;
    /**
     * Grants permission to list host keys associated with a server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ListHostKeys.html
     */
    toListHostKeys(): this;
    /**
     * Grants permission to list profiles
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ListProfiles.html
     */
    toListProfiles(): this;
    /**
     * Grants permission to list security policies
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ListSecurityPolicies.html
     */
    toListSecurityPolicies(): this;
    /**
     * Grants permission to list servers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ListServers.html
     */
    toListServers(): this;
    /**
     * Grants permission to list tags for an AWS Transfer Family resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list users associated with a server
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ListUsers.html
     */
    toListUsers(): this;
    /**
     * Grants permission to list webapps
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ListWebApps.html
     */
    toListWebApps(): this;
    /**
     * Grants permission to list workflows
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_ListWorkflows.html
     */
    toListWorkflows(): this;
    /**
     * Grants permission to send a callback for asynchronous custom steps
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_SendWorkflowStepState.html
     */
    toSendWorkflowStepState(): this;
    /**
     * Grants permission to initiate a list operation on a remote server using a connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_StartDirectoryListing.html
     */
    toStartDirectoryListing(): this;
    /**
     * Grants permission to initiate a connector file transfer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_StartFileTransfer.html
     */
    toStartFileTransfer(): this;
    /**
     * Grants permission to initiate a connector delete operation on remote server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_StartRemoteDelete.html
     */
    toStartRemoteDelete(): this;
    /**
     * Grants permission to initiate a connector move operation on remote server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_StartRemoteMove.html
     */
    toStartRemoteMove(): this;
    /**
     * Grants permission to start a server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_StartServer.html
     */
    toStartServer(): this;
    /**
     * Grants permission to stop a server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_StopServer.html
     */
    toStopServer(): this;
    /**
     * Grants permission to tag an AWS Transfer Family resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to test a connector's connection to remote server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_TestConnection.html
     */
    toTestConnection(): this;
    /**
     * Grants permission to test a server's custom identity provider
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_TestIdentityProvider.html
     */
    toTestIdentityProvider(): this;
    /**
     * Grants permission to untag an AWS Transfer Family resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update access
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateAccess.html
     */
    toUpdateAccess(): this;
    /**
     * Grants permission to update an agreement
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateAgreement.html
     */
    toUpdateAgreement(): this;
    /**
     * Grants permission to update a certificate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateCertificate.html
     */
    toUpdateCertificate(): this;
    /**
     * Grants permission to update a connector
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateConnector.html
     */
    toUpdateConnector(): this;
    /**
     * Grants permission to update a host key
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateHostKey.html
     */
    toUpdateHostKey(): this;
    /**
     * Grants permission to update a profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateProfile.html
     */
    toUpdateProfile(): this;
    /**
     * Grants permission to update the configuration of a server
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html
     */
    toUpdateServer(): this;
    /**
     * Grants permission to update the configuration of a user
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateUser.html
     */
    toUpdateUser(): this;
    /**
     * Grants permission to update the configuration of a webapp
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateWebApp.html
     */
    toUpdateWebApp(): this;
    /**
     * Grants permission to update the configuration of a webapp cutomization
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateWebAppCustomization.html
     */
    toUpdateWebAppCustomization(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type user to the statement
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/create-user.html
     *
     * @param serverId - Identifier for the serverId.
     * @param userName - Identifier for the userName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onUser(serverId: string, userName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type server to the statement
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/configuring-servers.html
     *
     * @param serverId - Identifier for the serverId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onServer(serverId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type workflow to the statement
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/transfer-workflows.html
     *
     * @param workflowId - Identifier for the workflowId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWorkflow(workflowId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type certificate to the statement
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/create-b2b-server.html
     *
     * @param certificateId - Identifier for the certificateId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCertificate(certificateId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type connector to the statement
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/create-b2b-server.html
     *
     * @param connectorId - Identifier for the connectorId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConnector(connectorId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type profile to the statement
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/create-b2b-server.html
     *
     * @param profileId - Identifier for the profileId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProfile(profileId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type agreement to the statement
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/create-b2b-server.html
     *
     * @param serverId - Identifier for the serverId.
     * @param agreementId - Identifier for the agreementId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAgreement(serverId: string, agreementId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type host-key to the statement
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html
     *
     * @param serverId - Identifier for the serverId.
     * @param hostKeyId - Identifier for the hostKeyId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onHostKey(serverId: string, hostKeyId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type webapp to the statement
     *
     * https://docs.aws.amazon.com/transfer/latest/userguide/web-app.html
     *
     * @param webAppId - Identifier for the webAppId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWebapp(webAppId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateAgreement()
     * - .toCreateConnector()
     * - .toCreateProfile()
     * - .toCreateServer()
     * - .toCreateUser()
     * - .toCreateWebApp()
     * - .toCreateWorkflow()
     * - .toImportCertificate()
     * - .toImportHostKey()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - user
     * - server
     * - workflow
     * - certificate
     * - connector
     * - profile
     * - agreement
     * - host-key
     * - webapp
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateAgreement()
     * - .toCreateConnector()
     * - .toCreateProfile()
     * - .toCreateServer()
     * - .toCreateUser()
     * - .toCreateWebApp()
     * - .toCreateWorkflow()
     * - .toImportCertificate()
     * - .toImportHostKey()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [transfer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstransferfamily.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
