import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [transform](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstransform.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Transform extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to invoke AssociateConnectorResource on AWS Transform
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transform/latest/userguide/security_iam_permissions.html/
     */
    toAssociateConnectorResource(): this;
    /**
     * Grants permission to invoke CreateProfile on AWS Transform
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transform/latest/userguide/security_iam_permissions.html/
     */
    toCreateProfile(): this;
    /**
     * Grants permission to invoke DeleteConnector on AWS Transform
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transform/latest/userguide/security_iam_permissions.html/
     */
    toDeleteConnector(): this;
    /**
     * Grants permission to invoke DeleteProfile on AWS Transform
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transform/latest/userguide/security_iam_permissions.html/
     */
    toDeleteProfile(): this;
    /**
     * Grants permission to invoke GetConnector on AWS Transform
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transform/latest/userguide/security_iam_permissions.html/
     */
    toGetConnector(): this;
    /**
     * Grants permission to invoke ListConnectors on AWS Transform
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transform/latest/userguide/security_iam_permissions.html/
     */
    toListConnectors(): this;
    /**
     * Grants permission to invoke ListProfiles on AWS Transform
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/transform/latest/userguide/security_iam_permissions.html/
     */
    toListProfiles(): this;
    /**
     * Grants permission to invoke ListTagsForResource on AWS Transform
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/transform/latest/userguide/security_iam_permissions.html/
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to invoke RejectConnector on AWS Transform
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transform/latest/userguide/security_iam_permissions.html/
     */
    toRejectConnector(): this;
    /**
     * Grants permission to invoke TagResource on AWS Transform
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/transform/latest/userguide/security_iam_permissions.html/
     */
    toTagResource(): this;
    /**
     * Grants permission to invoke UntagResource on AWS Transform
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/transform/latest/userguide/security_iam_permissions.html/
     */
    toUntagResource(): this;
    /**
     * Grants permission to invoke UpdateProfile on AWS Transform
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/transform/latest/userguide/security_iam_permissions.html/
     */
    toUpdateProfile(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type profile to the statement
     *
     * https://docs.aws.amazon.com/transform/latest/userguide/security_iam_permissions.html
     *
     * @param identifier - Identifier for the identifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onProfile(identifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type connector to the statement
     *
     * https://docs.aws.amazon.com/transform/latest/userguide/security_iam_permissions.html
     *
     * @param workspaceId - Identifier for the workspaceId.
     * @param connectorId - Identifier for the connectorId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onConnector(workspaceId: string, connectorId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [transform](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstransform.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
