import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [notifications](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsusernotifications.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Notifications extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to associate a new Channel with a particular NotificationConfiguration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_AssociateChannel.html
     */
    toAssociateChannel(): this;
    /**
     * Grants permission to associate an Account contact to a particular Managed Notification Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_AssociateManagedNotificationAccountContact.html
     */
    toAssociateManagedNotificationAccountContact(): this;
    /**
     * Grants permission to associate a Channel to a particular Managed Notification Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_AssociateManagedNotificationAdditionalChannel.html
     */
    toAssociateManagedNotificationAdditionalChannel(): this;
    /**
     * Grants permission to associate an Organizational Unit to a particular Notification Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_AssociateOrganizationalUnit.html
     */
    toAssociateOrganizationalUnit(): this;
    /**
     * Grants permission to create a new EventRule, associating it with a NotificationConfiguration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_CreateEventRule.html
     */
    toCreateEventRule(): this;
    /**
     * Grants permission to create a NotificationConfiguration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_CreateNotificationConfiguration.html
     */
    toCreateNotificationConfiguration(): this;
    /**
     * Grants permission to delete an EventRule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_DeleteEventRule.html
     */
    toDeleteEventRule(): this;
    /**
     * Grants permission to delete a NotificationConfiguration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_DeleteNotificationConfiguration.html
     */
    toDeleteNotificationConfiguration(): this;
    /**
     * Grants permission to deregister a NotificationHub
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_DeregisterNotificationHub.html
     */
    toDeregisterNotificationHub(): this;
    /**
     * Grants permission to disable Service Trust for AWS User Notifications
     *
     * Access Level: Permissions management
     *
     * Dependent actions:
     * - organizations:DisableAWSServiceAccess
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_DisableNotificationsAccessForOrganization.html
     */
    toDisableNotificationsAccessForOrganization(): this;
    /**
     * Grants permission to remove a Channel from a NotificationConfiguration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_DisassociateChannel.html
     */
    toDisassociateChannel(): this;
    /**
     * Grants permission to remove an Account contact from a Managed Notification Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_DisassociateManagedNotificationAccountContact.html
     */
    toDisassociateManagedNotificationAccountContact(): this;
    /**
     * Grants permission to remove a Channel from a Managed Notification Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_DisassociateManagedNotificationAdditionalChannel.html
     */
    toDisassociateManagedNotificationAdditionalChannel(): this;
    /**
     * Grants permission to disassociate an Organizational Unit to a particular Notification Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_DisassociateOrganizationalUnit.html
     */
    toDisassociateOrganizationalUnit(): this;
    /**
     * Grants permission to enable Service Trust for AWS User Notifications
     *
     * Access Level: Permissions management
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - organizations:EnableAWSServiceAccess
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_EnableNotificationsAccessForOrganization.html
     */
    toEnableNotificationsAccessForOrganization(): this;
    /**
     * Grants permission to get an EventRule
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_GetEventRule.html
     */
    toGetEventRule(): this;
    /**
     * Grants permission to read the opt-in status of an AWS User Notification Service feature
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/notifications/latest/userguide/managing-notification-features.html
     */
    toGetFeatureOptInStatus(): this;
    /**
     * Grants permission to get a Managed Notification Child Event
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_GetManagedNotificationChildEvent.html
     */
    toGetManagedNotificationChildEvent(): this;
    /**
     * Grants permission to get a Managed Notification Configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_GetManagedNotificationConfiguration.html
     */
    toGetManagedNotificationConfiguration(): this;
    /**
     * Grants permission to get a Managed NotificationEvent
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_GetManagedNotificationEvent.html
     */
    toGetManagedNotificationEvent(): this;
    /**
     * Grants permission to get a NotificationConfiguration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_GetNotificationConfiguration.html
     */
    toGetNotificationConfiguration(): this;
    /**
     * Grants permission to get a NotificationEvent
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_GetNotificationEvent.html
     */
    toGetNotificationEvent(): this;
    /**
     * Grants permission to read Service Trust for AWS User Notifications
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_GetNotificationsAccessForOrganization.html
     */
    toGetNotificationsAccessForOrganization(): this;
    /**
     * Grants permission to list Channels by NotificationConfiguration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_ListChannels.html
     */
    toListChannels(): this;
    /**
     * Grants permission to list EventRules
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_ListEventRules.html
     */
    toListEventRules(): this;
    /**
     * Grants permission to list Account contacts and Channels associated with a Managed Notification Configuration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_ListManagedNotificationChannelAssociations.html
     */
    toListManagedNotificationChannelAssociations(): this;
    /**
     * Grants permission to list Managed Notification Child Events
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_ListManagedNotificationChildEvents.html
     */
    toListManagedNotificationChildEvents(): this;
    /**
     * Grants permission to list Managed Notification Configurations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_ListManagedNotificationConfigurations.html
     */
    toListManagedNotificationConfigurations(): this;
    /**
     * Grants permission to list Managed Notification Events
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_ListManagedNotificationEvents.html
     */
    toListManagedNotificationEvents(): this;
    /**
     * Grants permission to list Member Accounts for a Notification Configuration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_ListMemberAccounts.html
     */
    toListMemberAccounts(): this;
    /**
     * Grants permission to list NotificationConfigurations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_ListNotificationConfigurations.html
     */
    toListNotificationConfigurations(): this;
    /**
     * Grants permission to list NotificationEvents
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_ListNotificationEvents.html
     */
    toListNotificationEvents(): this;
    /**
     * Grants permission to list NotificationHubs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_ListNotificationHubs.html
     */
    toListNotificationHubs(): this;
    /**
     * Grants permission to list Organizational Units for a Notification Configuration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_ListOrganizationalUnits.html
     */
    toListOrganizationalUnits(): this;
    /**
     * Grants permission to get tags for a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to update the opt-in status of an AWS User Notification Service feature
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/notifications/latest/userguide/managing-notification-features.html
     */
    toPutFeatureOptInStatus(): this;
    /**
     * Grants permission to register a NotificationHub
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_RegisterNotificationHub.html
     */
    toRegisterNotificationHub(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an EventRule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_UpdateEventRule.html
     */
    toUpdateEventRule(): this;
    /**
     * Grants permission to update a NotificationConfiguration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/notifications/latest/APIReference/API_UpdateNotificationConfiguration.html
     */
    toUpdateNotificationConfiguration(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type EventRule to the statement
     *
     * https://docs.aws.amazon.com/notifications/latest/userguide/resource-level-permissions.html
     *
     * @param notificationConfigurationId - Identifier for the notificationConfigurationId.
     * @param eventRuleId - Identifier for the eventRuleId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEventRule(notificationConfigurationId: string, eventRuleId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type NotificationConfiguration to the statement
     *
     * https://docs.aws.amazon.com/notifications/latest/userguide/resource-level-permissions.html
     *
     * @param notificationConfigurationId - Identifier for the notificationConfigurationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onNotificationConfiguration(notificationConfigurationId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type NotificationEvent to the statement
     *
     * https://docs.aws.amazon.com/notifications/latest/userguide/resource-level-permissions.html
     *
     * @param notificationConfigurationId - Identifier for the notificationConfigurationId.
     * @param notificationEventId - Identifier for the notificationEventId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onNotificationEvent(notificationConfigurationId: string, notificationEventId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ManagedNotificationChildEvent to the statement
     *
     * https://docs.aws.amazon.com/notifications/latest/userguide/resource-level-permissions.html
     *
     * @param category - Identifier for the category.
     * @param subcategory - Identifier for the subcategory.
     * @param notificationEventId - Identifier for the notificationEventId.
     * @param notificationChildEventId - Identifier for the notificationChildEventId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onManagedNotificationChildEvent(category: string, subcategory: string, notificationEventId: string, notificationChildEventId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type ManagedNotificationConfiguration to the statement
     *
     * https://docs.aws.amazon.com/notifications/latest/userguide/resource-level-permissions.html
     *
     * @param category - Identifier for the category.
     * @param subcategory - Identifier for the subcategory.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onManagedNotificationConfiguration(category: string, subcategory: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type ManagedNotificationEvent to the statement
     *
     * https://docs.aws.amazon.com/notifications/latest/userguide/resource-level-permissions.html
     *
     * @param category - Identifier for the category.
     * @param subcategory - Identifier for the subcategory.
     * @param notificationEventId - Identifier for the notificationEventId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onManagedNotificationEvent(category: string, subcategory: string, notificationEventId: string, account?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateNotificationConfiguration()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - NotificationConfiguration
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateNotificationConfiguration()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [notifications](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsusernotifications.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
